/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.util.DialogUI;
import org.nuiton.jaxx.util.DialogUIHandler;
import org.nuiton.jaxx.util.DialogUIModel;
import org.nuiton.jaxx.util.UIHelper;

public class DialogUIDef<M extends DialogUIModel, U extends DialogUI<H>, H extends DialogUIHandler<M, U>>
implements Serializable {
    protected static final Log log = LogFactory.getLog(DialogUIDef.class);
    private final Class<M> modelClass;
    private final Class<H> handlerClass;
    private final Class<U> uiClass;
    private Class<? extends U> uiImplClass;
    protected U uiInstance;
    protected final String name;
    protected final String uiTitle;
    protected final String showActionLibelle;
    protected final String showActionTip;
    protected ImageIcon showUIActionIcon;
    private static final long serialVersionUID = 1L;

    public static <M extends DialogUIModel, U extends DialogUI<H>, H extends DialogUIHandler<M, U>> DialogUIDef<M, U, H> newDef(Class<H> handlerClass, Class<U> uiClass, Class<M> modelClass, String showActionLibelle, String showActionTip, String uiTitle) {
        DialogUIDef<M, U, H> result = new DialogUIDef<M, U, H>(handlerClass, uiClass, modelClass, showActionLibelle, showActionTip, uiTitle);
        return result;
    }

    private DialogUIDef(Class<H> handlerClass, Class<U> uiClass, Class<M> modelClass, String showActionLibelle, String showActionTip, String uiTitle) {
        this.handlerClass = handlerClass;
        this.uiClass = uiClass;
        this.modelClass = modelClass;
        this.showActionLibelle = showActionLibelle;
        this.name = uiClass.getSimpleName().toLowerCase();
        this.showActionTip = showActionTip;
        this.uiTitle = uiTitle;
    }

    public Class<U> getUiClass() {
        return this.uiClass;
    }

    public Class<H> getHandlerClass() {
        return this.handlerClass;
    }

    public Class<M> getModelClass() {
        return this.modelClass;
    }

    public Class<? extends U> getUiImplClass() {
        return this.uiImplClass;
    }

    public String getUiTitle() {
        return I18n._((String)this.uiTitle);
    }

    public String getShowActionLibelle() {
        return I18n._((String)this.showActionLibelle);
    }

    public String getShowActionTip() {
        return I18n._((String)this.showActionTip);
    }

    public ImageIcon getShowUIActionIcon() {
        if (this.showUIActionIcon == null) {
            this.showUIActionIcon = UIHelper.createActionIcon("show-" + this.name);
        }
        return this.showUIActionIcon;
    }

    public void setUiImplClass(Class<?> uiImplClass) {
        this.uiImplClass = uiImplClass;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DialogUIDef && this.uiClass.equals(((DialogUIDef)o).uiClass);
    }

    public int hashCode() {
        return this.uiClass.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append('<');
        sb.append(this.printClass("handler", this.handlerClass, true));
        sb.append(this.printClass("model", this.modelClass, true));
        sb.append(this.printClass("ui", this.uiClass, true));
        sb.append(this.printClass("uiImpl", this.uiImplClass, false));
        return sb.toString();
    }

    protected U getUiInstance() {
        return this.uiInstance;
    }

    protected void setUiInstance(U uiInstance) {
        this.uiInstance = uiInstance;
    }

    protected U newUI() {
        if (this.uiImplClass == null) {
            throw new IllegalStateException("no concrete ui impl found in " + this);
        }
        try {
            DialogUI result = (DialogUI)this.uiImplClass.newInstance();
            log.info((Object)result);
            return (U)result;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not instanciate ui " + this, e);
        }
    }

    protected M newModel() {
        if (this.modelClass == null) {
            throw new IllegalStateException("no model impl found in " + this);
        }
        try {
            DialogUIModel model = (DialogUIModel)this.modelClass.newInstance();
            log.info((Object)model);
            return (M)model;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not instanciate ui " + this, e);
        }
    }

    protected H newHandler(U ui, M model, Object ... params) {
        if (this.handlerClass == null) {
            throw new IllegalStateException("no handler impl found in " + this);
        }
        try {
            Class<?>[] prototype = this.getHandlerPrototype(params);
            Object[] parameters = this.getHandlerParameters(ui, model, params);
            DialogUIHandler result = (DialogUIHandler)this.handlerClass.getConstructor(prototype).newInstance(parameters);
            log.info((Object)result);
            return (H)result;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not instanciate ui " + this, e);
        }
    }

    protected Object[] getHandlerParameters(U ui, M model, Object[] params) {
        Object[] result = new Object[2 + params.length];
        result[0] = ui;
        result[1] = model;
        System.arraycopy(params, 0, result, 2, params.length);
        return result;
    }

    protected Class<?>[] getHandlerPrototype(Object[] params) {
        int length = params.length;
        for (Constructor<?> constructor : this.handlerClass.getConstructors()) {
            Class<?>[] prototype = constructor.getParameterTypes();
            if (prototype.length != 2 + length || prototype[0] != this.uiClass || prototype[1] != this.modelClass) continue;
            return prototype;
        }
        throw new IllegalStateException("could not find a matching constructor in " + this.handlerClass);
    }

    protected String printClass(String s, Class<?> aClass, boolean notLast) {
        return s + ':' + (aClass == null ? null : aClass.getSimpleName()) + (notLast ? ", " : ">");
    }
}

