/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.wizard;

import java.awt.Window;
import javax.swing.ImageIcon;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.WizardUI;
import org.apache.commons.beanutils.ConstructorUtils;

public abstract class WizardUILancher<E extends WizardStep, M extends WizardModel<E>, UI extends WizardUI<E, M>> {
    protected UI ui;

    public WizardUILancher(JAXXContext context, Class<UI> uiClass, Class<M> modelClass, String title, String tip, ImageIcon icon) {
        this(context, uiClass, modelClass, null, title, tip, icon);
    }

    public WizardUILancher(JAXXContext context, Class<UI> uiClass, Class<M> modelClass, M model, String title, String tip, ImageIcon icon) {
        try {
            this.ui = this.createUI(context, uiClass, modelClass, model, title, tip, icon);
        }
        catch (Exception ex) {
            throw new RuntimeException("could not instanciate launcher for reason " + ex.getMessage(), ex);
        }
    }

    public WizardUILancher(JAXXContext context, Window mainUI, Class<UI> uiClass, Class<M> modelClass, M model) {
        try {
            this.ui = this.createUI(context, mainUI, uiClass, modelClass, model);
        }
        catch (Exception ex) {
            throw new RuntimeException("could not instanciate launcher for reason " + ex.getMessage(), ex);
        }
    }

    public WizardUILancher(JAXXContext context, Window mainUI, Class<UI> uiClass, Class<M> modelClass) {
        this(context, mainUI, uiClass, modelClass, null);
    }

    public void start() {
        this.init(this.ui);
        this.start(this.ui);
    }

    protected void start(UI ui) {
        ui.start();
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        if (this.ui == null) {
            throw new NullPointerException("ui can not be null");
        }
        if (!(this.ui instanceof JAXXObject)) {
            throw new ClassCastException("ui can not be casted to JAXXObject ");
        }
        return ((JAXXObject)this.ui).getContextValue(clazz, name);
    }

    public <T> T getContextValue(Class<T> clazz) {
        return this.getContextValue(clazz, null);
    }

    protected void init(UI ui) {
    }

    protected void doAction(UI ui) {
    }

    protected void doCancel(UI ui) {
    }

    protected void doClose(UI ui, boolean wasCanceld) {
    }

    protected UI createUI(JAXXContext context, Window mainUI, Class<UI> uiClass, Class<M> modelClass, M model) throws Exception {
        JAXXInitialContext uiContext = new JAXXInitialContext();
        uiContext.add(mainUI == null ? context : mainUI);
        uiContext.add(modelClass.newInstance());
        if (model != null) {
            uiContext.add("incoming", model);
        }
        uiContext.add("apply", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WizardUILancher.this.doAction(WizardUILancher.this.ui);
                }
                finally {
                    WizardUILancher.this.doClose(WizardUILancher.this.ui, false);
                }
            }
        });
        uiContext.add("cancel", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WizardUILancher.this.doCancel(WizardUILancher.this.ui);
                }
                finally {
                    WizardUILancher.this.doClose(WizardUILancher.this.ui, true);
                }
            }
        });
        WizardUI newUI = (WizardUI)ConstructorUtils.invokeConstructor(uiClass, (Object[])new Object[]{mainUI, uiContext}, (Class[])new Class[]{Window.class, JAXXContext.class});
        return (UI)newUI;
    }

    protected UI createUI(JAXXContext context, Class<UI> uiClass, Class<M> modelClass, M model, String title, String tip, ImageIcon icon) throws Exception {
        JAXXInitialContext uiContext = new JAXXInitialContext();
        uiContext.add(context);
        uiContext.add(modelClass.newInstance());
        if (model != null) {
            uiContext.add("incoming", model);
        }
        uiContext.add("apply", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WizardUILancher.this.doAction(WizardUILancher.this.ui);
                }
                finally {
                    WizardUILancher.this.doClose(WizardUILancher.this.ui, false);
                }
            }
        });
        uiContext.add("cancel", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WizardUILancher.this.doCancel(WizardUILancher.this.ui);
                }
                finally {
                    WizardUILancher.this.doClose(WizardUILancher.this.ui, true);
                }
            }
        });
        WizardUI newUI = (WizardUI)ConstructorUtils.invokeConstructor(uiClass, (Object[])new Object[]{uiContext, title, tip, icon}, (Class[])new Class[]{JAXXContext.class, String.class, String.class, ImageIcon.class});
        return (UI)newUI;
    }
}

