/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationTreeNodeRenderer;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigationTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NavigationTreeNode.class);
    protected final String pathSeparator;
    protected String path;
    protected String fullPath;
    protected Class<? extends JAXXObject> uIClass;
    protected Class<? extends JAXXAction> uIHandlerClass;
    protected JAXXContextEntryDef<?> jaxxContextEntryDef;
    protected String jaxxContextEntryPath;
    protected transient Object bean;
    protected Class<?> internalClass;

    public NavigationTreeNode(String pathSeparator, String navigationPath, Object jaxxContextEntryDef) {
        this.pathSeparator = pathSeparator;
        this.path = navigationPath;
        if (jaxxContextEntryDef instanceof JAXXContextEntryDef) {
            this.jaxxContextEntryDef = (JAXXContextEntryDef)jaxxContextEntryDef;
        } else if (jaxxContextEntryDef instanceof String) {
            this.jaxxContextEntryPath = (String)jaxxContextEntryDef;
        } else if (jaxxContextEntryDef != null) {
            throw new IllegalArgumentException("to define a context link, must be a String (jxpath) or a " + JAXXContextEntryDef.class + ", but was " + jaxxContextEntryDef);
        }
    }

    public NavigationTreeNode(String pathSeparator, String navigationPath, JAXXContextEntryDef<?> jaxxContextEntryDef, String jaxxContextEntryPath) {
        this.pathSeparator = pathSeparator;
        this.path = navigationPath;
        this.jaxxContextEntryDef = jaxxContextEntryDef;
        this.jaxxContextEntryPath = jaxxContextEntryPath;
    }

    public NavigationTreeNodeRenderer getRenderer() {
        NavigationTreeNodeRenderer render = null;
        Object o = this.getUserObject();
        if (o != null && o instanceof NavigationTreeNodeRenderer) {
            render = (NavigationTreeNodeRenderer)o;
        }
        return render;
    }

    public void setRenderer(NavigationTreeNodeRenderer renderer) {
        this.bean = null;
        this.setUserObject(renderer);
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getNodePath() {
        return this.path;
    }

    public void setNodePath(String navigationPath) {
        this.path = navigationPath;
    }

    public Class<? extends JAXXObject> getUIClass() {
        return this.uIClass;
    }

    public void setUIClass(Class<? extends JAXXObject> uIClass) {
        this.uIClass = uIClass;
    }

    public void setInternalClass(Class<?> internalClass) {
        this.internalClass = internalClass;
    }

    public Class<? extends JAXXAction> getUIHandlerClass() {
        return this.uIHandlerClass;
    }

    public void setUIHandlerClass(Class<? extends JAXXAction> uIHandlerClass) {
        this.uIHandlerClass = uIHandlerClass;
    }

    public JAXXContextEntryDef<?> getJaxxContextEntryDef() {
        return this.jaxxContextEntryDef;
    }

    public void setJaxxContextEntryDef(JAXXContextEntryDef<?> jaxxContextEntryDef) {
        this.jaxxContextEntryDef = jaxxContextEntryDef;
    }

    public String getJaxxContextEntryPath() {
        return this.jaxxContextEntryPath;
    }

    public void setJaxxContextEntryPath(String jaxxContextEntryPath) {
        this.jaxxContextEntryPath = jaxxContextEntryPath;
    }

    public Class<?> getInternalClass() {
        if (this.internalClass == null && this.getRenderer() != null) {
            return this.getRenderer().getInternalClass();
        }
        return this.internalClass;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            StringBuilder sb = new StringBuilder();
            for (TreeNode treeNode : this.getPath()) {
                NavigationTreeNode myNode = (NavigationTreeNode)treeNode;
                sb.append(this.pathSeparator).append(myNode.getNodePath());
            }
            this.fullPath = sb.substring(1);
        }
        return this.fullPath;
    }

    @Override
    public NavigationTreeNode getChildAt(int index) {
        return (NavigationTreeNode)super.getChildAt(index);
    }

    @Override
    public NavigationTreeNode getParent() {
        return (NavigationTreeNode)super.getParent();
    }

    public NavigationTreeNode getChild(String path) {
        Enumeration<TreeNode> childs = this.children();
        while (childs.hasMoreElements()) {
            NavigationTreeNode son = (NavigationTreeNode)childs.nextElement();
            if (!path.equals(son.getNodePath())) continue;
            return son;
        }
        return null;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void reload(JAXXContext context) {
        this.bean = null;
        this.fullPath = null;
        NavigationTreeNodeRenderer renderer = this.getRenderer();
        if (renderer == null) {
            throw new NullPointerException("could not find the renderer for node " + this);
        }
        Object b = this.getBean(context);
        renderer.reload(b);
    }

    public Object getBean(JAXXContext context) {
        if (this.bean != null) {
            return this.bean;
        }
        if (this.getJaxxContextEntryDef() != null && this.jaxxContextEntryPath == null) {
            Object result = this.getJaxxContextEntryDef().getContextValue(context);
            this.setBean(result);
            return result;
        }
        NavigationTreeNode parentNode = this.getFirstAncestorWithDef();
        if (parentNode == null) {
            log.warn((Object)("could not find a ancestor node with a definition of a context entry from node (" + this + ")"));
            return null;
        }
        Object parentBean = parentNode.getJaxxContextEntryDef().getContextValue(context);
        if (parentBean == null) {
            log.warn((Object)("could not find a bean attached in context from context entry definition " + parentNode.getJaxxContextEntryDef()));
            return null;
        }
        if (parentNode.jaxxContextEntryPath != null) {
            JXPathContext jxcontext = JXPathContext.newContext(parentBean);
            parentBean = jxcontext.getValue(parentNode.jaxxContextEntryPath);
        }
        parentNode.setBean(parentBean);
        if (this == parentNode) {
            return parentBean;
        }
        if (this.jaxxContextEntryPath == null) {
            log.warn((Object)("must find a jaxxContextEntryPath on node (" + this + ")"));
            return null;
        }
        String jxpathExpression = this.computeJXPath(this.jaxxContextEntryPath, parentNode);
        if (jxpathExpression == null) {
            log.warn((Object)("could not build jxpath from node " + parentNode + " to " + this));
            return null;
        }
        if (jxpathExpression.startsWith("[")) {
            jxpathExpression = '.' + jxpathExpression;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("jxpath : " + jxpathExpression));
        }
        JXPathContext jxcontext = JXPathContext.newContext(parentBean);
        Object result = jxcontext.getValue(jxpathExpression);
        this.setBean(result);
        return result;
    }

    protected NavigationTreeNode getFirstAncestorWithDef() {
        if (this.jaxxContextEntryDef != null) {
            return this;
        }
        NavigationTreeNode ancestor = this.getParent();
        return ancestor == null ? null : ancestor.getFirstAncestorWithDef();
    }

    protected String computeJXPath(String expr, NavigationTreeNode parentNode) {
        if (parentNode == this) {
            return expr;
        }
        int firstIndex = expr.indexOf("..");
        int lastIndex = expr.lastIndexOf("..");
        if (firstIndex == -1) {
            throw new IllegalArgumentException(expr + " should contains at least one \"..\"");
        }
        if (firstIndex != 0) {
            throw new IllegalArgumentException("\"..\" must be at the beginning but was : " + expr);
        }
        NavigationTreeNode ancestor = this.getParent();
        if (firstIndex == lastIndex) {
            String newExpr = expr.substring(2);
            if (this.getParent().equals(parentNode)) {
                return newExpr;
            }
            if (ancestor.jaxxContextEntryPath == null) {
                throw new IllegalArgumentException("with the expression " + expr + ", the ancestor node (" + ancestor + ") must have a jaxxContextEntryPath definition, but was not ");
            }
            newExpr = ancestor.jaxxContextEntryPath + newExpr;
            return ancestor.computeJXPath(newExpr, parentNode);
        }
        if (ancestor.jaxxContextEntryPath != null) {
            throw new IllegalArgumentException("with the expression " + expr + ", the ancestor node can not have a jaxxContextEntryPath definition");
        }
        String newExpr = expr.substring(0, lastIndex - 1) + expr.substring(lastIndex + (expr.charAt(lastIndex + 3) == '/' ? 3 : 2));
        return ancestor.computeJXPath(newExpr, parentNode);
    }
}

