/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.decorator.MultiJXPathDecorator;
import jaxx.runtime.decorator.PropertyDecorator;

public class DecoratorUtils {
    public static <O> PropertyDecorator<O> newPropertyDecorator(Class<O> internalClass, String property) throws IllegalArgumentException, NullPointerException {
        return new PropertyDecorator<O>(internalClass, property);
    }

    public static <O> JXPathDecorator<O> newJXPathDecorator(Class<O> internalClass, String expression) throws IllegalArgumentException, NullPointerException {
        JXPathDecorator.Context<O> context = DecoratorUtils.createJXPathContext(expression);
        return new JXPathDecorator<O>(internalClass, expression, context);
    }

    public static <O> MultiJXPathDecorator<O> newMultiJXPathDecorator(Class<O> internalClass, String expression, String separator) throws IllegalArgumentException, NullPointerException {
        return DecoratorUtils.newMultiJXPathDecorator(internalClass, expression, separator, separator);
    }

    public static <O> MultiJXPathDecorator<O> newMultiJXPathDecorator(Class<O> internalClass, String expression, String separator, String separatorReplacement) throws IllegalArgumentException, NullPointerException {
        JXPathDecorator.Context<O>[] contexts = DecoratorUtils.createMultiJXPathContext(expression, separator, separatorReplacement);
        return new MultiJXPathDecorator<O>(internalClass, expression, separator, separatorReplacement, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <O> void sort(JXPathDecorator<O> decorator, List<O> datas, int pos) {
        Comparator<O> c = null;
        boolean cachedComparator = false;
        try {
            c = decorator.getComparator(pos);
            cachedComparator = c instanceof JXPathDecorator.JXPathComparator;
            if (cachedComparator) {
                ((JXPathDecorator.JXPathComparator)c).init(decorator, datas);
            }
            Collections.sort(datas, c);
        }
        finally {
            if (cachedComparator) {
                ((JXPathDecorator.JXPathComparator)c).clear();
            }
        }
    }

    public static <O> JXPathDecorator.Context<O> createJXPathContext(String expression) {
        int start;
        ArrayList<String> lTokens = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int size = expression.length();
        int end = -1;
        while ((start = expression.indexOf("${", end + 1)) > -1) {
            if (start > end + 1) {
                buffer.append(expression.substring(end + 1, start));
            }
            if ((end = expression.indexOf("}", start + 1)) == -1) {
                throw new IllegalArgumentException("could not find the rigth brace starting at car " + start + " : " + expression.substring(start + 2));
            }
            String jxpath = expression.substring(start + 2, end);
            if (jxpath.indexOf("${") > -1) {
                throw new IllegalArgumentException("could not find a ${ inside a jxpath expression at car " + (start + 2) + " : " + jxpath);
            }
            lTokens.add(jxpath);
            buffer.append("%").append(lTokens.size());
        }
        if (size > end + 1) {
            buffer.append(expression.substring(end + 1));
        }
        return new JXPathDecorator.Context(buffer.toString(), lTokens.toArray(new String[lTokens.size()]));
    }

    public static <O> JXPathDecorator.Context<O>[] createMultiJXPathContext(String expression, String separator, String separatorReplacement) {
        int sep = expression.indexOf(separator);
        if (sep == -1) {
            JXPathDecorator.Context<O>[] result = DecoratorUtils.newInstance(1);
            result[0] = DecoratorUtils.createJXPathContext(expression);
            return result;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(expression, separator);
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        int nbTokens = tokens.size();
        JXPathDecorator.Context<O>[] contexts = DecoratorUtils.newInstance(nbTokens);
        for (int i = 0; i < nbTokens; ++i) {
            StringBuilder buffer = new StringBuilder(expression.length());
            for (int j = 0; j < nbTokens; ++j) {
                int index = (i + j) % nbTokens;
                String str = (String)tokens.get(index);
                buffer.append(separatorReplacement).append(str);
            }
            contexts[i] = DecoratorUtils.createJXPathContext(buffer.substring(separatorReplacement.length()));
        }
        return contexts;
    }

    protected static <O> JXPathDecorator.Context<O>[] newInstance(int size) {
        return new JXPathDecorator.Context[size];
    }
}

