/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.action;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUIModel;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.validator.swing.SwingValidator;

public class ApplicationActionUIHandler
extends AbstractApplicationUIHandler<ApplicationActionUIModel, ApplicationActionUI> {
    private static final Log log = LogFactory.getLog(ApplicationActionUIHandler.class);
    protected final PropertyChangeListener progressionListener = evt -> {
        String propertyName = evt.getPropertyName();
        if ("message".equals(propertyName)) {
            String newMessage = (String)evt.getNewValue();
            ((ApplicationActionUI)this.ui).getTaskActionLabel().setText("<html><body>" + newMessage + "</body></html>");
            ((ApplicationActionUI)this.ui).pack();
        } else if ("total".equals(propertyName)) {
            ((ApplicationActionUI)this.ui).getTaskProgressBar().setMaximum((Integer)evt.getNewValue());
        } else if ("current".equals(propertyName)) {
            ((ApplicationActionUI)this.ui).getTaskProgressBar().setValue((Integer)evt.getNewValue());
        }
    };
    protected final ComponentListener listener = new ComponentAdapter(){
        boolean moving;
        boolean resizing;

        @Override
        public void componentMoved(ComponentEvent e) {
            Component mainUI = (Component)e.getSource();
            if (!this.moving && mainUI.isShowing()) {
                this.moving = true;
                try {
                    ApplicationActionUIHandler.this.setLocation(mainUI);
                }
                finally {
                    this.moving = false;
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Component mainUI = (Component)e.getSource();
            if (!this.resizing && mainUI.isShowing()) {
                this.resizing = true;
                try {
                    ApplicationActionUIHandler.this.setSize(mainUI);
                }
                finally {
                    this.resizing = false;
                }
            }
        }
    };

    @Override
    public void beforeInit(ApplicationActionUI ui) {
        this.ui = ui;
        ApplicationActionUIModel model = new ApplicationActionUIModel();
        ui.setContextValue(model);
        model.addPropertyChangeListener("action", evt -> {
            AbstractApplicationAction action = (AbstractApplicationAction)((Object)((Object)evt.getNewValue()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Action to use: " + (Object)((Object)action)));
            }
            if (action == null) {
                this.hideAction();
            } else {
                this.showAction(action);
            }
        });
        model.addPropertyChangeListener("progressionModel", evt -> {
            ApplicationProgressionModel oldValue = (ApplicationProgressionModel)evt.getOldValue();
            ApplicationProgressionModel newValue = (ApplicationProgressionModel)evt.getNewValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("progression model: " + newValue));
            }
            if (oldValue != null) {
                oldValue.removePropertyChangeListener(this.progressionListener);
            }
            if (newValue == null) {
                ((ApplicationActionUI)this.ui).getTaskPanel().setVisible(false);
            } else {
                ((ApplicationActionUI)this.ui).getTaskPanel().setVisible(true);
                newValue.addPropertyChangeListener(this.progressionListener);
            }
        });
    }

    public void afterInit(ApplicationActionUI ui) {
        this.initUI(this.ui);
        SwingUtil.setLayerUI((JComponent)((ApplicationActionUI)this.ui).getRootPanel(), (LayerUI)((ApplicationActionUI)this.ui).getBusyBlockLayerUI());
        ((ApplicationActionUI)this.ui).setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<ApplicationActionUIModel> getValidator() {
        return null;
    }

    @Override
    public Component getTopestUI() {
        return null;
    }

    @Override
    public <E> Decorator<E> getDecorator(Class<E> beanType, String decoratorContext) {
        return null;
    }

    protected void hideAction() {
        ((ApplicationActionUI)this.ui).setVisible(false);
    }

    protected void showAction(AbstractApplicationAction action) {
        ((ApplicationActionUI)this.ui).setTitle(I18n.t((String)"jaxx.application.title.actionUI", (Object[])new Object[]{this.getContext().getConfiguration().getApplicationName(), this.getContext().getConfiguration().getVersion(), action.getActionDescription()}));
        ((ApplicationActionUI)this.ui).getGlobalActionLabel().setText(I18n.t((String)"jaxx.application.message.action.running", (Object[])new Object[]{action.getActionDescription()}));
        ((ApplicationActionUI)this.ui).pack();
        Component mainUI = this.getContext().getMainUI();
        if (mainUI != null) {
            mainUI.addComponentListener(this.listener);
            this.setLocation(mainUI);
            this.setSize(mainUI);
        }
        try {
            ((ApplicationActionUI)this.ui).setVisible(true);
        }
        finally {
            if (mainUI != null) {
                mainUI.removeComponentListener(this.listener);
            }
        }
    }

    protected void setLocation(Component mainUI) {
        int y;
        int x;
        int height;
        Component component = this.getContext().getBodyUI();
        Component status = this.getContext().getStatusUI();
        int width = component == null ? 0 : component.getWidth();
        int n = height = component == null ? 0 : component.getHeight() + status.getHeight();
        if (height == 0) {
            x = mainUI.getX() + 5;
            y = mainUI.getY() + 15;
        } else {
            x = mainUI.getX() + (mainUI.getWidth() - width);
            y = mainUI.getY() + (mainUI.getHeight() - height);
        }
        ((ApplicationActionUI)this.ui).setLocation(x, y);
    }

    protected void setSize(Component mainUI) {
        ((ApplicationActionUI)this.ui).pack();
    }
}

