/* 
* *##% Plugin maven pour i18n
 * Copyright (C) 2007 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */
package org.nuiton.i18n.plugin.parser.impl;

import org.nuiton.i18n.plugin.parser.ParserEvent;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Un parseur java pour scanner les annotations ActionConfig
 *
 * @author chemit
 * @goal parserJavaActionConfig
 * @phase generate-resources
 */
public class ParserJavaActionConfig extends ParserJava {

    protected static final Pattern MATCH_PATTERN = Pattern.compile("(name|shortDescription|longDescription|name2|shortDescription2|longDescription2)\\s*=\\s*\"([\\w|\\.]+)\"(|\\s*|\\s*,\\s*$)");

    @Override
    protected String getKeyModifierStart() {
        return "[\\w|\\.]+\\s*=\\s*\"";
    }

    @Override
    protected String getKeyModifierEnd() {
        return "\"\\s*(\\)|,|\\+|$)";
    }

    @Override
    protected String getOutGetter() {
        return "java-action-config.getter";
    }

    /*
    * (non-Javadoc)
    * @see org.codelutin.i18n.plugin.extension.XmlParser#extract(java.lang.String)
    */

    public String extract(String i18nString) {
        Matcher matcher = MATCH_PATTERN.matcher(i18nString.trim());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    /*
    * (non-Javadoc)
    * @see org.codelutin.i18n.plugin.core.Parser#parseLine(java.io.File, java.lang.String)
    */
    @Override
    public void parseLine(File srcFile, String line) {
        String key = extract(line);
        if (key != null) {
            touchFile = true;
            String keyModified = key;
            for (ParserEvent event : events) {
                event.eventChangeKey(key, !oldLanguage.containsKey(key));
                keyModified = event.eventGetRealKey();
            }
            if (oldParser.containsKey(key)) {
                result.put(keyModified, oldParser.get(key));
            } else {
                result.put(keyModified, key);
            }
        }
    }

}
