/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle.csv;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.plugin.I18nUtil;
import org.nuiton.i18n.plugin.bundle.csv.AbstractCsvBundleMojo;
import org.nuiton.i18n.plugin.bundle.csv.I18nBundleModel;
import org.nuiton.i18n.plugin.bundle.csv.I18nBundleModelRow;
import org.nuiton.io.SortedProperties;

@Mojo(name="generate-csv-bundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateCsvBundleMojo
extends AbstractCsvBundleMojo {
    @Parameter(property="i18n.bundleOutputName", defaultValue="${project.artifactId}-i18n", required=true)
    protected String bundleOutputName;
    @Parameter(property="i18n.bundleInputEncoding")
    protected String bundleInputEncoding;
    @Parameter(property="i18n.bundleOutputEncoding")
    protected String bundleOutputEncoding;
    @Parameter(property="i18n.bundleOutputDir", defaultValue="${project.build.directory}/generated-sources/resources", required=true)
    protected File bundleOutputDir;
    @Parameter(property="i18n.bundleOutputPackage", defaultValue="META-INF", required=true)
    protected String bundleOutputPackage;
    @Parameter(property="i18n.addInClassPath", defaultValue="true")
    protected boolean addInClassPath;
    @Parameter(property="i18n.bundleCsvFile", defaultValue="${i18n.bundleOutputName}-i18n.csv", required=true)
    protected String bundleCsvFileName;
    @Parameter(property="i18n.bundleCsvDirectory")
    protected File bundleCsvDirectory;
    protected File outputFolder;
    protected File bundleCsvFile;

    @Override
    public void init() throws Exception {
        super.init();
        this.outputFolder = this.getBundleOutputFolder();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will load bundles from " + this.outputFolder));
        }
        this.createDirectoryIfNecessary(this.outputFolder);
        if (StringUtils.isEmpty((CharSequence)this.bundleInputEncoding)) {
            this.bundleInputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Use as input encoding the default one : " + this.bundleInputEncoding));
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.bundleOutputEncoding)) {
            this.bundleOutputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Use as output encoding the default one : " + this.bundleOutputEncoding));
            }
        }
        if (this.bundleCsvDirectory == null) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will generate csv bundle in bundle directory " + this.outputFolder));
            }
            this.bundleCsvDirectory = this.outputFolder;
            if (this.addInClassPath) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Will add " + this.bundleCsvFileName + " in classpath"));
                }
                this.addResourceDir(this.bundleOutputDir, new String[]{"**/" + this.bundleCsvFileName});
            }
        } else {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will generate csv bundle in given directory " + this.bundleCsvDirectory));
            }
            if (this.addInClassPath) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Will add " + this.bundleCsvFileName + " in classpath"));
                }
                this.addResourceDir(this.bundleCsvDirectory, new String[]{this.bundleCsvFileName});
            }
        }
        this.createDirectoryIfNecessary(this.outputFolder);
        this.bundleCsvFile = new File(this.bundleCsvDirectory, this.bundleCsvFileName);
        if (!this.bundleCsvFile.exists()) {
            this.createNewFile(this.bundleCsvFile);
        }
    }

    protected void doAction() throws Exception {
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)("config - locales         : " + Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)("config - bundle dir      : " + this.outputFolder));
            this.getLog().info((CharSequence)("config - bundle name     : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - csv separator   : " + this.bundleCsvSeparator));
            this.getLog().info((CharSequence)("config - csv file name   : " + this.bundleCsvFileName));
            this.getLog().info((CharSequence)("config - input encoding  : " + this.bundleInputEncoding));
            this.getLog().info((CharSequence)("config - output encoding : " + this.bundleOutputEncoding));
        }
        TreeMap<String, I18nBundleModelRow> rowsByKey = new TreeMap<String, I18nBundleModelRow>();
        for (Locale locale : this.locales) {
            File bundleFile = I18nUtil.getI18nFile(this.outputFolder, this.bundleOutputName, locale, false);
            SortedProperties properties = new SortedProperties(this.bundleOutputEncoding);
            properties.load(bundleFile);
            for (Object o : properties.keySet()) {
                String key = (String)o;
                I18nBundleModelRow row = (I18nBundleModelRow)rowsByKey.get(key);
                if (row == null) {
                    row = new I18nBundleModelRow();
                    row.setKey(key);
                    rowsByKey.put(key, row);
                }
                row.setLocaleValue(locale, (String)properties.get(o));
            }
        }
        LinkedList rows = new LinkedList(rowsByKey.values());
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)String.format("Found %d translations to export.", rows.size()));
        }
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)("Generate csv bundle file at " + this.bundleCsvFile));
        }
        I18nBundleModel exportModel = new I18nBundleModel(this.bundleCsvSeparator, this.locales);
        Export.exportToFile((ExportModel)exportModel, rows, (File)this.bundleCsvFile, (Charset)Charset.forName(this.encoding));
    }

    protected File getBundleOutputFolder() {
        File result = this.bundleOutputDir;
        if (StringUtils.isNotEmpty((CharSequence)this.bundleOutputPackage)) {
            String[] paths;
            for (String path : paths = this.bundleOutputPackage.split("\\.")) {
                result = new File(result, path);
            }
        }
        return result;
    }
}

