/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.nuiton.plugin.PluginHelper;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = -1147150444452577558L;
    public static final String ENCODING_DEFAULT = "8859_1";
    public static final String ENCODING_LATIN1 = "iso-8859-1";
    public static final String ENCODING_ASCII = "us-ascii";
    private static final char[] hexDigitUpper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] hexDigitLower = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected String defaultEncoding;
    protected boolean removeHeader;
    protected final boolean unicodeLower;
    protected final char[] hexDigit;

    public SortedProperties() {
        this(ENCODING_DEFAULT);
    }

    public SortedProperties(String defaultEncoding) {
        this(defaultEncoding, true, false);
    }

    public SortedProperties(String defaultEncoding, boolean removeHeader) {
        this(defaultEncoding, removeHeader, false);
    }

    public SortedProperties(String defaultEncoding, boolean removeHeader, boolean unicodeLower) {
        this.defaultEncoding = defaultEncoding;
        this.removeHeader = removeHeader;
        this.unicodeLower = unicodeLower;
        this.hexDigit = unicodeLower ? hexDigitLower : hexDigitUpper;
    }

    public SortedProperties(Properties defaults) {
        super(defaults);
        this.defaultEncoding = ENCODING_DEFAULT;
        this.unicodeLower = false;
        this.hexDigit = hexDigitUpper;
    }

    @Override
    public Enumeration<Object> keys() {
        Vector<Object> result;
        ArrayList<Object> objects = Collections.list(super.keys());
        try {
            List<String> list = PluginHelper.toGenericList(objects, String.class);
            Collections.sort(list);
            result = new Vector<String>(list);
        }
        catch (IllegalArgumentException e) {
            result = new Vector<Object>(objects);
        }
        return result.elements();
    }

    public SortedProperties load(File src) throws IOException {
        return this.load(src, this.defaultEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedProperties load(File src, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(src), encoding);
        try {
            this.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
        return this;
    }

    public void store(File dst) throws IOException {
        this.store(dst, this.defaultEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File dst, String encoding) throws IOException {
        FileOutputStream stream = new FileOutputStream(dst);
        try {
            this.storeEncode(stream, encoding);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEncode(OutputStream stream, String encoding) throws IOException {
        if (!(ENCODING_LATIN1.equalsIgnoreCase(encoding) || ENCODING_DEFAULT.equals(encoding) || ENCODING_ASCII.equalsIgnoreCase(encoding))) {
            OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
            try {
                this.store(writer, null);
            }
            finally {
                ((Writer)writer).close();
            }
        } else {
            this.store(stream, null);
        }
    }

    public void store(OutputStream dst) throws IOException {
        this.store(dst, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(OutputStream out, String comments) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, ENCODING_DEFAULT));
        try {
            this.store0(writer, comments, true);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Writer writer, String comments) throws IOException {
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        try {
            this.store0(bufferedWriter, comments, false);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store0(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            this.writeComments(bw, comments);
        }
        if (!this.removeHeader) {
            bw.write("#" + new Date().toString());
            bw.newLine();
        }
        SortedProperties sortedProperties = this;
        synchronized (sortedProperties) {
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)this.get(key);
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    protected String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(this.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(this.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(this.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(this.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = this.toHex(c >> 12 & 0xF);
                uu[3] = this.toHex(c >> 8 & 0xF);
                uu[4] = this.toHex(c >> 4 & 0xF);
                uu[5] = this.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    protected char toHex(int nibble) {
        return this.hexDigit[nibble & 0xF];
    }
}

