package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: JavaTemplatesStereoTypes.java 1359 2014-06-01 10:52:18Z tchemit $
 * $HeadURL: https://svn.nuiton.org/eugene/tags/eugene-2.11/eugene-java-templates/src/main/java/org/nuiton/eugene/java/JavaTemplatesStereoTypes.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.stereotype.StereotypeDefinition;
import org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider;

/**
 * Defines all stereotypes managed by Java templates.
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider" role-hint="eugene-java-templates"
 * @since 2.5.6
 */
public class JavaTemplatesStereoTypes extends StereotypeDefinitionProvider {

    /**
     * Stereotype for JavaBean objects to place on a classifier.
     *
     * @see #hasBeanStereotype(ObjectModelClassifier)
     * @since 2.5.6
     */
    @StereotypeDefinition(
            target = ObjectModelClassifier.class,
            documentation = "To specify that a class is a JavaBean")
    public static final String STEREOTYPE_BEAN = "bean";

    /**
     * Check if the given classifier has the {@link #STEREOTYPE_BEAN} stereotype.
     *
     * @param classifier classifier to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see #STEREOTYPE_BEAN
     */
    public static boolean hasBeanStereotype(ObjectModelClassifier classifier) {
        return classifier.hasStereotype(JavaTemplatesStereoTypes.STEREOTYPE_BEAN);
    }

}
