/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.config.templates;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class ApplicationConfigTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(ApplicationConfigTransformer.class);
    public static final String PROP_OPTION_CLASS_NAME = "optionClassName";
    public static final String PROP_ACTION_CLASS_NAME = "actionClassName";
    private static final Set<String> KNOWN_TYPES = ImmutableSet.of((Object)"File", (Object)"Color", (Object)"KeyStroke", (Object)"URL", (Object)"Class", (Object)"Date", (Object[])new String[]{"Time", "Timestamp", "Locale", "Version", "String", "int", "Integer", "long", "Long", "float", "Float", "boolean", "Boolean", "byte", "Byte", "char", "Character", "double", "Double"});

    public void transformFromClass(ObjectModelClass clazz) {
        String packageName = clazz.getPackageName();
        String abstractClassName = "Generated" + clazz.getName();
        if (this.canGenerate(packageName + "." + abstractClassName)) {
            this.generateAbstractClass(packageName, abstractClassName, clazz);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Skip generation for " + abstractClassName));
        }
        String className = clazz.getName();
        if (this.canGenerate(packageName + "." + className)) {
            this.generateClass(packageName, className, abstractClassName);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Skip generation for " + className));
        }
    }

    protected void generateAbstractClass(String packageName, String abstractClassName, ObjectModelClass input) {
        String optionClassName = this.getProperty(PROP_OPTION_CLASS_NAME);
        String optionClassSimpleName = GeneratorUtil.getSimpleName((String)optionClassName);
        String actionClassName = this.getProperty(PROP_ACTION_CLASS_NAME);
        ObjectModelClass output = this.createAbstractClass(abstractClassName, packageName);
        this.addInterface((ObjectModelClassifier)output, "java.util.function.Supplier<ApplicationConfig>");
        this.addImport((ObjectModelClassifier)output, "java.util.function.Supplier");
        this.addImport((ObjectModelClassifier)output, optionClassName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
        this.addAttribute((ObjectModelClassifier)output, "applicationConfig", ApplicationConfig.class, "", new ObjectModelModifier[]{ObjectModelJavaModifier.PRIVATE});
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PROTECTED);
        StringBuilder builder = new StringBuilder();
        builder.append("\n        this.applicationConfig = new ApplicationConfig();\n        this.applicationConfig.loadDefaultOptions(" + optionClassSimpleName + ".values());\n    ");
        if (actionClassName != null) {
            this.addImport((ObjectModelClassifier)output, actionClassName);
            String actionClassSimpleName = GeneratorUtil.getSimpleName((String)actionClassName);
            builder.append("\n        for (" + actionClassSimpleName + " a : " + actionClassSimpleName + ".values()) {\n\n            for (String alias : a.getAliases()) {\n                applicationConfig.addActionAlias(alias, a.getAction());\n            }\n        }\n    ");
        }
        this.setOperationBody(constructor, builder.toString());
        ObjectModelOperation getApplicationConfig = this.addOperation((ObjectModelClassifier)output, "get", ApplicationConfig.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getApplicationConfig, Override.class);
        this.setOperationBody(getApplicationConfig, "\n        return applicationConfig;\n    ");
        ObjectModelOperation setOption = this.addOperation((ObjectModelClassifier)output, "setOption", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(setOption, String.class, "key");
        this.addParameter(setOption, Object.class, "attrName");
        this.setOperationBody(setOption, "\n        applicationConfig.setOption(key, String.valueOf(attrName));\n    ");
        for (ObjectModelAttribute attribute : input.getAttributes()) {
            String attrName = attribute.getName();
            String attrType = attribute.getType();
            String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
            String constantName = JavaGeneratorUtil.getSimpleName((String)optionClassName) + "." + JavaGeneratorUtil.convertVariableNameToConstantName((String)attrName);
            this.addImport((ObjectModelClassifier)output, attrType);
            this.createGetMethod(output, attrName, simpleType, constantName);
            this.createSetMethod(output, attrName, simpleType, constantName);
        }
    }

    protected void generateClass(String packageName, String className, String abstractClassName) {
        ObjectModelClass output = this.createClass(className, packageName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Generate " + output.getQualifiedName()));
        }
        this.setSuperClass(output, abstractClassName);
    }

    protected boolean canGenerate(String input) {
        return !this.getResourcesHelper().isJavaFileInClassPath(input);
    }

    protected void createGetMethod(ObjectModelClass output, String attrName, String simpleType, String constantName) {
        boolean booleanProperty = GeneratorUtil.isBooleanPrimitive((String)simpleType);
        String methodPrefix = booleanProperty ? "is" : "get";
        String methodName = "getOptionAs" + StringUtils.capitalise((String)simpleType);
        if (simpleType.equals("String")) {
            methodName = "getOption";
        } else if (simpleType.equals("Integer")) {
            methodName = "getOptionAsInt";
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName(methodPrefix, attrName), simpleType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        if (!KNOWN_TYPES.contains(simpleType)) {
            methodName = "getOptionAsObject";
            this.setOperationBody(operation, "\n        return (" + simpleType + ") applicationConfig." + methodName + "(" + simpleType + ".class, " + constantName + ".getKey());\n    ");
        } else {
            this.setOperationBody(operation, "\n        return applicationConfig." + methodName + "(" + constantName + ".getKey());\n    ");
            if ("Boolean".equals(simpleType)) {
                operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("is", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
                this.setOperationBody(operation, "\n        return applicationConfig." + methodName + "(" + constantName + ".getKey());\n    ");
            }
        }
    }

    protected void createSetMethod(ObjectModelClass output, String attrName, String simpleType, String constantName) {
        boolean booleanProperty = GeneratorUtil.isBooleanPrimitive((String)simpleType);
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("set", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, simpleType, attrName);
        String methodPrefix = booleanProperty ? "is" : "get";
        String methodName = this.getJavaBeanMethodName(methodPrefix, attrName);
        this.setOperationBody(operation, "\n        setOption(" + constantName + ".getKey(), " + attrName + ");\n    ");
        if ("Boolean".equals(simpleType)) {
            operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("set", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "boolean", attrName);
            this.setOperationBody(operation, "\n        setOption(" + constantName + ".getKey(), " + attrName + ");\n    ");
        }
    }
}

