/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.pool;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;

public class MarshlandPool<T>
implements Pool<T> {
    private final Pool<T> pool;
    private final ThreadLocal<LocalSlot<T>> puddle = new ThreadLocal<LocalSlot<T>>(){

        @Override
        protected LocalSlot<T> initialValue() {
            LocalSlot localSlot = new LocalSlot(MarshlandPool.this.objectsFromDeadThreads);
            MarshlandPool.this.slotReferences.add(localSlot.phantomReference);
            return localSlot;
        }
    };
    private final Set<LocalSlotReference> slotReferences = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<LocalSlot<T>> objectsFromDeadThreads = new ReferenceQueue();

    public MarshlandPool(Factory<T> objectFactory) {
        this(new LinkedQueuePool<T>(4, objectFactory));
    }

    public MarshlandPool(Pool<T> delegatePool) {
        this.pool = delegatePool;
    }

    @Override
    public T acquire() {
        LocalSlot<Object> localSlot = this.puddle.get();
        Object object = ((LocalSlot)localSlot).object;
        if (object != null) {
            localSlot.set(null);
            return (T)object;
        }
        LocalSlotReference slotReference = (LocalSlotReference)this.objectsFromDeadThreads.poll();
        if (slotReference != null && slotReference.object != null) {
            this.slotReferences.remove(slotReference);
            return (T)slotReference.object;
        }
        return this.pool.acquire();
    }

    @Override
    public void release(T obj) {
        LocalSlot<T> localSlot = this.puddle.get();
        if (((LocalSlot)localSlot).object == null) {
            localSlot.set(obj);
        } else {
            this.pool.release(obj);
        }
    }

    public void disposeAll() {
        for (LocalSlotReference slotReference : this.slotReferences) {
            Object obj;
            LocalSlot slot = (LocalSlot)slotReference.get();
            if (slot == null || (obj = slot.object) == null) continue;
            slot.set(null);
            this.pool.release(obj);
        }
        LocalSlotReference reference = (LocalSlotReference)this.objectsFromDeadThreads.poll();
        while (reference != null) {
            Object instance = reference.object;
            if (instance != null) {
                this.pool.release(instance);
            }
            reference = (LocalSlotReference)this.objectsFromDeadThreads.poll();
        }
    }

    public void close() {
        this.disposeAll();
    }

    private static class LocalSlot<T> {
        private T object;
        private final LocalSlotReference phantomReference;

        LocalSlot(ReferenceQueue<LocalSlot<T>> referenceQueue) {
            this.phantomReference = new LocalSlotReference(this, referenceQueue);
        }

        public void set(T obj) {
            this.phantomReference.object = obj;
            this.object = obj;
        }
    }

    private static class LocalSlotReference<T>
    extends WeakReference<LocalSlot> {
        private T object;

        private LocalSlotReference(LocalSlot referent, ReferenceQueue<? super LocalSlot> q) {
            super(referent, q);
        }
    }
}

