/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final int NO_PROGRESS_INFO = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_INFO", 100);
    private static final int NO_PROGRESS_CLOSE = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_CLOSE", 200);
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private int _total_no_progress;
    private final AsyncEndPoint _asyncEndp;

    public AsyncHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
        this._asyncEndp = (AsyncEndPoint)endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connection handle() throws IOException {
        Connection connection = this;
        boolean some_progress = false;
        boolean progress = true;
        try {
            AsyncHttpConnection.setCurrentConnection(this);
            this._asyncEndp.setCheckForIdle(false);
            while (progress && connection == this) {
                block25: {
                    Connection switched;
                    progress = false;
                    try {
                        if (this._request._async.isAsync()) {
                            if (this._request._async.isDispatchable()) {
                                this.handleRequest();
                            }
                        } else if (!this._parser.isComplete() && this._parser.parseAvailable()) {
                            progress = true;
                        }
                        if (this._generator.isCommitted() && !this._generator.isComplete() && !this._endp.isOutputShutdown() && this._generator.flushBuffer() > 0) {
                            progress = true;
                        }
                        this._endp.flush();
                        if (this._asyncEndp.hasProgressed()) {
                            progress = true;
                        }
                        some_progress |= progress;
                        if (!this._parser.isComplete() || !this._generator.isComplete()) break block25;
                        progress = true;
                    }
                    catch (HttpException e) {
                        block26: {
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("uri=" + this._uri, new Object[0]);
                                    LOG.debug("fields=" + this._requestFields, new Object[0]);
                                    LOG.debug(e);
                                }
                                progress = true;
                                this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                                some_progress |= progress;
                                if (!this._parser.isComplete() || !this._generator.isComplete()) break block26;
                                progress = true;
                            }
                            catch (Throwable throwable) {
                                Connection switched2;
                                some_progress |= progress;
                                if (!this._parser.isComplete() || !this._generator.isComplete()) {
                                    if (!this._request.getAsyncContinuation().isAsyncStarted()) throw throwable;
                                    LOG.debug("suspended {}", this);
                                    return connection;
                                }
                                progress = true;
                                if (this._response.getStatus() == 101 && (switched2 = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                    connection = switched2;
                                }
                                this.reset();
                                if (this._generator.isPersistent() || this._endp.isOutputShutdown()) throw throwable;
                                LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                                this._endp.shutdownOutput();
                                throw throwable;
                                return connection;
                            }
                            if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                                connection = switched;
                            }
                            this.reset();
                            if (this._generator.isPersistent() || this._endp.isOutputShutdown()) continue;
                            LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                            this._endp.shutdownOutput();
                            continue;
                        }
                        if (!this._request.getAsyncContinuation().isAsyncStarted()) continue;
                        LOG.debug("suspended {}", this);
                        return connection;
                    }
                    if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection")) != null) {
                        connection = switched;
                    }
                    this.reset();
                    if (this._generator.isPersistent() || this._endp.isOutputShutdown()) continue;
                    LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                    this._endp.shutdownOutput();
                    continue;
                }
                if (!this._request.getAsyncContinuation().isAsyncStarted()) continue;
                LOG.debug("suspended {}", this);
                return connection;
            }
        }
        finally {
            AsyncHttpConnection.setCurrentConnection(null);
            if (!this._request.isAsyncStarted()) {
                this._parser.returnBuffers();
                this._generator.returnBuffers();
                this._asyncEndp.setCheckForIdle(true);
            }
            if (some_progress) {
                this._total_no_progress = 0;
            } else {
                ++this._total_no_progress;
                if (NO_PROGRESS_INFO > 0 && this._total_no_progress % NO_PROGRESS_INFO == 0 && (NO_PROGRESS_CLOSE <= 0 || this._total_no_progress < NO_PROGRESS_CLOSE)) {
                    LOG.info("EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
                }
                if (NO_PROGRESS_CLOSE > 0 && this._total_no_progress == NO_PROGRESS_CLOSE) {
                    LOG.warn("Closing EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
                    if (this._endp instanceof SelectChannelEndPoint) {
                        ((SelectChannelEndPoint)this._endp).getChannel().close();
                    }
                }
            }
        }
    }

    @Override
    public void onInputShutdown() throws IOException {
        if (this._generator.isIdle() && !this._request.getAsyncContinuation().isSuspended()) {
            this._endp.close();
        }
    }
}

