/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateLifeCycle
extends AbstractLifeCycle
implements Destroyable,
Dumpable {
    private final Queue<Object> _dependentBeans = new ConcurrentLinkedQueue<Object>();

    @Override
    public void destroy() {
        for (Object e : this._dependentBeans) {
            if (!(e instanceof Destroyable)) continue;
            ((Destroyable)e).destroy();
        }
        this._dependentBeans.clear();
    }

    @Override
    protected void doStart() throws Exception {
        for (Object e : this._dependentBeans) {
            if (!(e instanceof LifeCycle)) continue;
            ((LifeCycle)e).start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (Object e : this._dependentBeans) {
            if (!(e instanceof LifeCycle)) continue;
            ((LifeCycle)e).stop();
        }
    }

    public boolean addBean(Object o) {
        if (o == null) {
            return false;
        }
        boolean added = false;
        if (!this._dependentBeans.contains(o)) {
            this._dependentBeans.add(o);
            added = true;
        }
        try {
            if (this.isStarted() && o instanceof LifeCycle) {
                ((LifeCycle)o).start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return added;
    }

    public Collection<Object> getBeans() {
        return this._dependentBeans;
    }

    public <T> List<T> getBeans(Class<T> clazz) {
        ArrayList beans = new ArrayList();
        for (Object e : this._dependentBeans) {
            if (!clazz.isInstance(e)) continue;
            beans.add(e);
        }
        return beans;
    }

    public <T> T getBean(Class<T> clazz) {
        Iterator iter = this._dependentBeans.iterator();
        T t = null;
        int count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!clazz.isInstance(o)) continue;
            ++count;
            if (t != null) continue;
            t = (T)o;
        }
        if (count > 1) {
            Log.debug("getBean({}) 1 of {}", clazz.getName(), count);
        }
        return t;
    }

    public void removeBeans() {
        this._dependentBeans.clear();
    }

    public boolean removeBean(Object o) {
        if (o == null) {
            return false;
        }
        return this._dependentBeans.remove(o);
    }

    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
        }
        catch (IOException e) {
            Log.warn(e);
        }
    }

    @Override
    public String dump() {
        return AggregateLifeCycle.dump(this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder b = new StringBuilder();
        try {
            dumpable.dump(b, "");
        }
        catch (IOException e) {
            Log.warn(e);
        }
        return b.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append("\n");
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        AggregateLifeCycle.dump(out, indent, this._dependentBeans);
    }

    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        for (Collection<?> c : collections) {
            size += c.size();
        }
        if (size == 0) {
            return;
        }
        int i = 0;
        for (Collection<?> c : collections) {
            for (Object o : c) {
                ++i;
                out.append(indent).append(" +- ");
                if (o instanceof Dumpable) {
                    ((Dumpable)o).dump(out, indent + (i == size ? "    " : " |  "));
                    continue;
                }
                out.append(String.valueOf(o)).append("\n");
            }
            if (i == size) continue;
            out.append(indent).append(" |\n");
        }
    }
}

