/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.EventListener;
import java.util.Iterator;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;
import org.eclipse.jetty.xml.XmlParser;

public abstract class AbstractConfiguration
implements Configuration {
    public abstract void bindEnvEntry(WebAppContext var1, String var2, Object var3) throws Exception;

    public abstract void bindResourceRef(WebAppContext var1, String var2, Class var3) throws Exception;

    public abstract void bindResourceEnvRef(WebAppContext var1, String var2, Class var3) throws Exception;

    public abstract void bindUserTransaction(WebAppContext var1) throws Exception;

    public abstract void bindMessageDestinationRef(WebAppContext var1, String var2, Class var3) throws Exception;

    public void preConfigure(WebAppContext context) throws Exception {
        org.eclipse.jetty.plus.servlet.ServletHandler servletHandler = new org.eclipse.jetty.plus.servlet.ServletHandler();
        SecurityHandler securityHandler = context.getSecurityHandler();
        ServletHandler existingHandler = context.getServletHandler();
        servletHandler.setFilters(existingHandler.getFilters());
        servletHandler.setFilterMappings(existingHandler.getFilterMappings());
        servletHandler.setServlets(existingHandler.getServlets());
        servletHandler.setServletMappings(existingHandler.getServletMappings());
        context.setServletHandler(servletHandler);
        securityHandler.setHandler(servletHandler);
        LifeCycleCallbackCollection callbacks = new LifeCycleCallbackCollection();
        context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", callbacks);
        InjectionCollection injections = new InjectionCollection();
        context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
        RunAsCollection runAsCollection = new RunAsCollection();
        context.setAttribute("org.eclipse.jetty.runAsCollection", runAsCollection);
    }

    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", null);
        context.setAttribute("org.eclipse.jetty.injectionCollection", null);
        context.setAttribute("org.eclipse.jetty.runAsCollection", null);
    }

    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        WebXmlProcessor webXmlProcessor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (webXmlProcessor == null) {
            throw new IllegalStateException("No processor for web xml");
        }
        PlusWebXmlProcessor plusProcessor = new PlusWebXmlProcessor(context);
        plusProcessor.process(webXmlProcessor.getWebDefault());
        plusProcessor.process(webXmlProcessor.getWebXml());
        for (WebXmlProcessor.Descriptor frag : webXmlProcessor.getFragments()) {
            plusProcessor.process(frag);
        }
        plusProcessor.process(webXmlProcessor.getOverrideWeb());
        ((org.eclipse.jetty.plus.servlet.ServletHandler)context.getServletHandler()).setInjections((InjectionCollection)context.getAttribute("org.eclipse.jetty.injectionCollection"));
        ((org.eclipse.jetty.plus.servlet.ServletHandler)context.getServletHandler()).setCallbacks((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection"));
        this.injectAndCallPostConstructCallbacks(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        this.callPreDestroyCallbacks(context);
    }

    protected void injectAndCallPostConstructCallbacks(WebAppContext context) throws Exception {
        int i;
        InjectionCollection injections = (InjectionCollection)context.getAttribute("org.eclipse.jetty.injectionCollection");
        RunAsCollection runAsCollection = (RunAsCollection)context.getAttribute("org.eclipse.jetty.runAsCollection");
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (runAsCollection != null) {
            ServletHolder[] holders = context.getServletHandler().getServlets();
            for (i = 0; holders != null && i < holders.length; ++i) {
                runAsCollection.setRunAs(holders[i], securityHandler);
            }
        }
        EventListener[] listeners = context.getEventListeners();
        for (i = 0; listeners != null && i < listeners.length; ++i) {
            if (injections != null) {
                injections.inject(listeners[i]);
            }
            if (callbacks == null) continue;
            callbacks.callPostConstructCallback(listeners[i]);
        }
    }

    protected void callPreDestroyCallbacks(WebAppContext context) throws Exception {
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        if (callbacks != null) {
            EventListener[] listeners = context.getEventListeners();
            for (int i = 0; listeners != null && i < listeners.length; ++i) {
                callbacks.callPreDestroyCallback(listeners[i]);
            }
        }
    }

    public class PlusWebXmlProcessor {
        WebAppContext _context;

        public PlusWebXmlProcessor(WebAppContext context) {
            this._context = context;
        }

        public void process(WebXmlProcessor.Descriptor d) throws Exception {
            if (d != null) {
                this.process(d.getRoot());
            }
        }

        public void process(XmlParser.Node root) throws Exception {
            if (root == null) {
                return;
            }
            Iterator iter = root.iterator();
            XmlParser.Node node = null;
            while (iter.hasNext()) {
                try {
                    Object o = iter.next();
                    if (!(o instanceof XmlParser.Node)) continue;
                    node = (XmlParser.Node)o;
                    String name = node.getTag();
                    this.initWebXmlElement(name, node);
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("Configuration problem at " + node, e);
                    throw new UnavailableException("Configuration problem");
                }
            }
        }

        protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
            if ("env-entry".equals(element)) {
                this.initEnvEntry(node);
            } else if ("resource-ref".equals(element)) {
                this.initResourceRef(node);
            } else if ("resource-env-ref".equals(element)) {
                this.initResourceEnvRef(node);
            } else if ("message-destination-ref".equals(element)) {
                this.initMessageDestinationRef(node);
            } else if ("post-construct".equals(element)) {
                this.initPostConstruct(node);
            } else if ("pre-destroy".equals(element)) {
                this.initPreDestroy(node);
            }
        }

        protected void initEnvEntry(XmlParser.Node node) throws Exception {
            String name = node.getString("env-entry-name", false, true);
            String type = node.getString("env-entry-type", false, true);
            String valueStr = node.getString("env-entry-value", false, true);
            if (valueStr == null || valueStr.equals("")) {
                Log.warn("No value for env-entry-name " + name);
                return;
            }
            this.initInjection(node, name, TypeUtil.fromName(type));
            Object value = TypeUtil.valueOf(type, valueStr);
            AbstractConfiguration.this.bindEnvEntry(this._context, name, value);
        }

        protected void initResourceRef(XmlParser.Node node) throws Exception {
            String jndiName = node.getString("res-ref-name", false, true);
            String type = node.getString("res-type", false, true);
            String auth = node.getString("res-auth", false, true);
            String shared = node.getString("res-sharing-scope", false, true);
            Class<?> typeClass = TypeUtil.fromName(type);
            if (typeClass == null) {
                typeClass = this._context.loadClass(type);
            }
            this.initInjection(node, jndiName, typeClass);
            AbstractConfiguration.this.bindResourceRef(this._context, jndiName, typeClass);
        }

        protected void initResourceEnvRef(XmlParser.Node node) throws Exception {
            String jndiName = node.getString("resource-env-ref-name", false, true);
            String type = node.getString("resource-env-ref-type", false, true);
            Class<?> typeClass = TypeUtil.fromName(type);
            if (typeClass == null) {
                typeClass = this._context.loadClass(type);
            }
            this.initInjection(node, jndiName, typeClass);
            AbstractConfiguration.this.bindResourceEnvRef(this._context, jndiName, typeClass);
        }

        protected void initMessageDestinationRef(XmlParser.Node node) throws Exception {
            String jndiName = node.getString("message-destination-ref-name", false, true);
            String type = node.getString("message-destination-type", false, true);
            String usage = node.getString("message-destination-usage", false, true);
            Class<?> typeClass = TypeUtil.fromName(type);
            if (typeClass == null) {
                typeClass = this._context.loadClass(type);
            }
            this.initInjection(node, jndiName, typeClass);
            AbstractConfiguration.this.bindMessageDestinationRef(this._context, jndiName, typeClass);
        }

        protected void initPostConstruct(XmlParser.Node node) {
            String className = node.getString("lifecycle-callback-class", false, true);
            String methodName = node.getString("lifecycle-callback-method", false, true);
            if (className == null || className.equals("")) {
                Log.warn("No lifecycle-callback-class specified");
                return;
            }
            if (methodName == null || methodName.equals("")) {
                Log.warn("No lifecycle-callback-method specified for class " + className);
                return;
            }
            LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
            try {
                Class<?> clazz = this._context.loadClass(className);
                PostConstructCallback callback = new PostConstructCallback();
                callback.setTarget(clazz, methodName);
                callbacks.add(callback);
            }
            catch (ClassNotFoundException e) {
                Log.warn("Couldn't load post-construct target class " + className);
            }
        }

        protected void initPreDestroy(XmlParser.Node node) {
            String className = node.getString("lifecycle-callback-class", false, true);
            String methodName = node.getString("lifecycle-callback-method", false, true);
            if (className == null || className.equals("")) {
                Log.warn("No lifecycle-callback-class specified for pre-destroy");
                return;
            }
            if (methodName == null || methodName.equals("")) {
                Log.warn("No lifecycle-callback-method specified for pre-destroy class " + className);
                return;
            }
            LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
            try {
                Class<?> clazz = this._context.loadClass(className);
                PreDestroyCallback callback = new PreDestroyCallback();
                callback.setTarget(clazz, methodName);
                callbacks.add(callback);
            }
            catch (ClassNotFoundException e) {
                Log.warn("Couldn't load pre-destory target class " + className);
            }
        }

        protected void initInjection(XmlParser.Node node, String jndiName, Class valueClass) {
            Iterator itor = node.iterator("injection-target");
            while (itor.hasNext()) {
                XmlParser.Node injectionNode = (XmlParser.Node)itor.next();
                String targetClassName = injectionNode.getString("injection-target-class", false, true);
                String targetName = injectionNode.getString("injection-target-name", false, true);
                if (targetClassName == null || targetClassName.equals("")) {
                    Log.warn("No classname found in injection-target");
                    continue;
                }
                if (targetName == null || targetName.equals("")) {
                    Log.warn("No field or method name in injection-target");
                    continue;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                try {
                    Class<?> clazz = this._context.loadClass(targetClassName);
                    Injection injection = new Injection();
                    injection.setJndiName(jndiName);
                    injection.setTarget(clazz, targetName, valueClass);
                    injections.add(injection);
                }
                catch (ClassNotFoundException e) {
                    Log.warn("Couldn't load injection target class " + targetClassName);
                }
            }
        }
    }
}

