/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas.spi;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.mortbay.jetty.plus.jaas.spi.AbstractLoginModule;
import org.mortbay.jetty.plus.jaas.spi.UserInfo;
import org.mortbay.jetty.security.Credential;
import org.mortbay.log.Log;

public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    public static final Map fileMap = new HashMap();
    private String propertyFileName;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.loadProperties((String)options.get("file"));
    }

    public void loadProperties(String filename) {
        File propsFile;
        if (filename == null) {
            propsFile = new File(System.getProperty("user.dir"), DEFAULT_FILENAME);
            if (!propsFile.exists()) {
                propsFile = new File(System.getProperty("jetty.home"), DEFAULT_FILENAME);
            }
        } else {
            propsFile = new File(filename);
        }
        if (!propsFile.exists()) {
            Log.warn((String)"No property file found");
            throw new IllegalStateException("No property file specified in login module configuration file");
        }
        try {
            this.propertyFileName = propsFile.getCanonicalPath();
            if (fileMap.get(this.propertyFileName) != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Properties file " + this.propertyFileName + " already in cache, skipping load"));
                }
                return;
            }
            HashMap<String, UserInfo> userInfoMap = new HashMap<String, UserInfo>();
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                String username = entry.getKey().toString().trim();
                String credentials = entry.getValue().toString().trim();
                String roles = null;
                int c = credentials.indexOf(44);
                if (c > 0) {
                    roles = credentials.substring(c + 1).trim();
                    credentials = credentials.substring(0, c).trim();
                }
                if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
                ArrayList<String> roleList = new ArrayList<String>();
                if (roles != null && roles.length() > 0) {
                    StringTokenizer tok = new StringTokenizer(roles, ", ");
                    while (tok.hasMoreTokens()) {
                        roleList.add(tok.nextToken());
                    }
                }
                userInfoMap.put(username, new UserInfo(username, Credential.getCredential((String)credentials.toString()), roleList));
            }
            fileMap.put(this.propertyFileName, userInfoMap);
        }
        catch (Exception e) {
            Log.warn((String)"Error loading properties from file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public UserInfo getUserInfo(String username) throws Exception {
        Map userInfoMap = (Map)fileMap.get(this.propertyFileName);
        if (userInfoMap == null) {
            return null;
        }
        return (UserInfo)userInfoMap.get(username);
    }
}

