// ========================================================================
// Copyright 2007 Dojo Foundation
// ------------------------------------------------------------------------
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at 
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//========================================================================

package dojox.cometd;


/* ------------------------------------------------------------ */
/** Bayeux Interface.
 * This interface represents the server side API for the  Bayeux messaging protocol.
 *
 */
public interface Bayeux
{
    /** ServletContext attribute name used to obtain the Bayeux object */
    public static final String DOJOX_COMETD_BAYEUX="dojox.cometd.bayeux";
    
    /* ------------------------------------------------------------ */
    /**
     * @param idprefix
     * @param listener
     * @return
     */
    public Client newClient(String idprefix, Listener listener);

    /* ------------------------------------------------------------ */
    /**
     * @param client_id
     * @return
     */
    public Client getClient(String client_id);
    
    /* ------------------------------------------------------------ */
    public Channel getChannel(String channelId,boolean create);

    /* ------------------------------------------------------------ */
    /** Deliver data to a channel.
     * @param fromClient The client sending the data
     * @param data The data itself which must be an Object that can be encoded with {@link JSON}.
     * @param toChannel The Channel ID to which the data is targetted
     * @param msgId optional message ID or null for automatic generation of a message ID.
     */
    public void publish(Client fromClient, String toChannel, Object data, String msgId);

    /* ------------------------------------------------------------ */
    /** Subscribe to a channel.
     * Equivalent to getChannel(toChannel).subscribe(subscriber).
     * @param toChannel
     * @param subscriber
     * @param createChannel. Create the channel if it does not exist
     */
    public void subscribe(String toChannel, Client subscriber);

    /* ------------------------------------------------------------ */
    /** Unsubscribe to a channel
     * @param toChannel
     * @param subscriber
     */
    public void unsubscribe(String toChannel, Client subscriber);
    
    /* ------------------------------------------------------------ */
    public boolean hasChannel(String channel);

    /* ------------------------------------------------------------ */
    public void addFilter(String channels, DataFilter filter);
    
    /* ------------------------------------------------------------ */
    public void removeFilter(String channels, DataFilter filter);
    
    
}