/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.vault;

import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.Crypts;
import com.mongodb.reactivestreams.client.vault.ClientEncryption;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = MongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(this.keyVaultClient, options);
        this.options = options;
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        return this.crypt.createDataKey(kmsProvider, dataKeyOptions).flatMap(dataKeyDocument -> {
            MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
            return Mono.from(this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne((BsonDocument)dataKeyDocument)).map(i -> dataKeyDocument.getBinary((Object)"_id"));
        });
    }

    @Override
    public Publisher<BsonBinary> encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public Publisher<BsonValue> decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public void close() {
        this.keyVaultClient.close();
        this.crypt.close();
    }
}

