/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;

public class SelectionContext {
    private final Type sourceType;
    private final SelectionCriteria selectionCriteria;
    private final Method mappingMethod;
    private final Type mappingTargetType;
    private final Type returnType;
    private final Supplier<List<ParameterBinding>> parameterBindingsProvider;
    private List<ParameterBinding> parameterBindings;

    private SelectionContext(Type sourceType, SelectionCriteria selectionCriteria, Method mappingMethod, Type mappingTargetType, Type returnType, Supplier<List<ParameterBinding>> parameterBindingsProvider) {
        this.sourceType = sourceType;
        this.selectionCriteria = selectionCriteria;
        this.mappingMethod = mappingMethod;
        this.mappingTargetType = mappingTargetType;
        this.returnType = returnType;
        this.parameterBindingsProvider = parameterBindingsProvider;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public SelectionCriteria getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public Type getMappingTargetType() {
        return this.mappingTargetType;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<ParameterBinding> getAvailableParameterBindings() {
        if (this.parameterBindings == null) {
            this.parameterBindings = this.parameterBindingsProvider.get();
        }
        return this.parameterBindings;
    }

    public Method getMappingMethod() {
        return this.mappingMethod;
    }

    public static SelectionContext forMappingMethods(Method mappingMethod, Type source, Type target, SelectionCriteria criteria, TypeFactory typeFactory) {
        return new SelectionContext(source, criteria, mappingMethod, target, target, () -> SelectionContext.getAvailableParameterBindingsFromSourceType(source, target, mappingMethod, typeFactory));
    }

    public static SelectionContext forLifecycleMethods(Method mappingMethod, Type targetType, SelectionParameters selectionParameters, TypeFactory typeFactory) {
        SelectionCriteria criteria = SelectionCriteria.forLifecycleMethods(selectionParameters);
        return new SelectionContext(null, criteria, mappingMethod, targetType, mappingMethod.getResultType(), () -> SelectionContext.getAvailableParameterBindingsFromMethod(mappingMethod, targetType, criteria.getSourceRHS(), typeFactory));
    }

    public static SelectionContext forFactoryMethods(Method mappingMethod, Type alternativeTarget, SelectionParameters selectionParameters, TypeFactory typeFactory) {
        SelectionCriteria criteria = SelectionCriteria.forFactoryMethods(selectionParameters);
        return new SelectionContext(null, criteria, mappingMethod, alternativeTarget, alternativeTarget, () -> SelectionContext.getAvailableParameterBindingsFromMethod(mappingMethod, alternativeTarget, criteria.getSourceRHS(), typeFactory));
    }

    public static SelectionContext forPresenceCheckMethods(Method mappingMethod, SelectionParameters selectionParameters, TypeFactory typeFactory) {
        SelectionCriteria criteria = SelectionCriteria.forPresenceCheckMethods(selectionParameters);
        Type booleanType = typeFactory.getType(Boolean.class);
        return new SelectionContext(null, criteria, mappingMethod, booleanType, booleanType, () -> SelectionContext.getAvailableParameterBindingsFromMethod(mappingMethod, booleanType, criteria.getSourceRHS(), typeFactory));
    }

    public static SelectionContext forSourceParameterPresenceCheckMethods(Method mappingMethod, SelectionParameters selectionParameters, Parameter sourceParameter, TypeFactory typeFactory) {
        SelectionCriteria criteria = SelectionCriteria.forSourceParameterCheckMethods(selectionParameters);
        Type booleanType = typeFactory.getType(Boolean.class);
        return new SelectionContext(null, criteria, mappingMethod, booleanType, booleanType, () -> SelectionContext.getParameterBindingsForSourceParameterPresenceCheck(mappingMethod, booleanType, sourceParameter, typeFactory));
    }

    private static List<ParameterBinding> getParameterBindingsForSourceParameterPresenceCheck(Method method, Type targetType, Parameter sourceParameter, TypeFactory typeFactory) {
        ArrayList<ParameterBinding> availableParams = new ArrayList<ParameterBinding>(method.getParameters().size() + 3);
        availableParams.add(ParameterBinding.fromParameter(sourceParameter));
        availableParams.add(ParameterBinding.forTargetTypeBinding(typeFactory.classTypeOf(targetType)));
        for (Parameter parameter : method.getParameters()) {
            if (parameter.isSourceParameter()) continue;
            availableParams.add(ParameterBinding.fromParameter(parameter));
        }
        return availableParams;
    }

    private static List<ParameterBinding> getAvailableParameterBindingsFromMethod(Method method, Type targetType, SourceRHS sourceRHS, TypeFactory typeFactory) {
        ArrayList<ParameterBinding> availableParams = new ArrayList<ParameterBinding>(method.getParameters().size() + 3);
        if (sourceRHS != null) {
            availableParams.addAll(ParameterBinding.fromParameters(method.getParameters()));
            availableParams.add(ParameterBinding.fromSourceRHS(sourceRHS));
            SelectionContext.addSourcePropertyNameBindings(availableParams, sourceRHS.getSourceType(), typeFactory);
        } else {
            availableParams.addAll(ParameterBinding.fromParameters(method.getParameters()));
        }
        SelectionContext.addTargetRelevantBindings(availableParams, targetType, typeFactory);
        return availableParams;
    }

    private static List<ParameterBinding> getAvailableParameterBindingsFromSourceType(Type sourceType, Type targetType, Method mappingMethod, TypeFactory typeFactory) {
        ArrayList<ParameterBinding> availableParams = new ArrayList<ParameterBinding>();
        availableParams.add(ParameterBinding.forSourceTypeBinding(sourceType));
        SelectionContext.addSourcePropertyNameBindings(availableParams, sourceType, typeFactory);
        for (Parameter param : mappingMethod.getParameters()) {
            if (!param.isMappingContext()) continue;
            availableParams.add(ParameterBinding.fromParameter(param));
        }
        SelectionContext.addTargetRelevantBindings(availableParams, targetType, typeFactory);
        return availableParams;
    }

    private static void addSourcePropertyNameBindings(List<ParameterBinding> availableParams, Type sourceType, TypeFactory typeFactory) {
        boolean sourcePropertyNameAvailable = false;
        for (ParameterBinding pb : availableParams) {
            if (!pb.isSourcePropertyName()) continue;
            sourcePropertyNameAvailable = true;
            break;
        }
        if (!sourcePropertyNameAvailable) {
            availableParams.add(ParameterBinding.forSourcePropertyNameBinding(typeFactory.getType(String.class)));
        }
    }

    private static void addTargetRelevantBindings(List<ParameterBinding> availableParams, Type targetType, TypeFactory typeFactory) {
        boolean mappingTargetAvailable = false;
        boolean targetTypeAvailable = false;
        boolean targetPropertyNameAvailable = false;
        for (ParameterBinding pb : availableParams) {
            if (pb.isMappingTarget()) {
                mappingTargetAvailable = true;
                continue;
            }
            if (pb.isTargetType()) {
                targetTypeAvailable = true;
                continue;
            }
            if (!pb.isTargetPropertyName()) continue;
            targetPropertyNameAvailable = true;
        }
        if (!mappingTargetAvailable) {
            availableParams.add(ParameterBinding.forMappingTargetBinding(targetType));
        }
        if (!targetTypeAvailable) {
            availableParams.add(ParameterBinding.forTargetTypeBinding(typeFactory.classTypeOf(targetType)));
        }
        if (!targetPropertyNameAvailable) {
            availableParams.add(ParameterBinding.forTargetPropertyNameBinding(typeFactory.getType(String.class)));
        }
    }
}

