/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import org.mapstruct.ap.internal.conversion.AbstractNumberToStringConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;

public class WrapperToStringConversion
extends AbstractNumberToStringConversion {
    private final Class<?> sourceType;
    private final Class<?> primitiveType;

    public WrapperToStringConversion(Class<?> sourceType) {
        super(NativeTypes.isNumber(sourceType));
        if (sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no wrapper type.");
        }
        this.sourceType = sourceType;
        this.primitiveType = NativeTypes.getPrimitiveType(sourceType);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".format( <SOURCE> )");
            return sb.toString();
        }
        return "String.valueOf( <SOURCE> )";
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".parse( <SOURCE> ).");
            sb.append(this.primitiveType.getSimpleName());
            sb.append("Value()");
            return sb.toString();
        }
        return this.sourceType.getSimpleName() + ".parse" + Strings.capitalize(this.primitiveType.getSimpleName()) + "( <SOURCE> )";
    }

    private void appendDecimalFormatter(StringBuilder sb, ConversionContext conversionContext) {
        sb.append("new DecimalFormat( ");
        if (conversionContext.getNumberFormat() != null) {
            sb.append("\"");
            sb.append(conversionContext.getNumberFormat());
            sb.append("\"");
        }
        sb.append(" )");
    }
}

