/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.annotations.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.kubek2k.springockito.annotations.ReplaceWithMock;
import org.kubek2k.springockito.annotations.WrapWithSpy;
import org.kubek2k.springockito.annotations.internal.naming.BeanNameResolver;
import org.kubek2k.springockito.annotations.internal.naming.BeanNameResolverChainOfResponsibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesiredMockitoBeansFinder {
    private final BeanNameResolver beanNameResolver = new BeanNameResolverChainOfResponsibility();

    public Map<String, MockProperties<ReplaceWithMock>> findMockedBeans(Class<?> clazz) {
        LinkedHashMap<String, MockProperties<ReplaceWithMock>> mockedBeans = new LinkedHashMap<String, MockProperties<ReplaceWithMock>>();
        for (Field field : clazz.getDeclaredFields()) {
            ReplaceWithMock annotationInstance = field.getAnnotation(ReplaceWithMock.class);
            if (annotationInstance == null) continue;
            String beanName = this.getBeanName(field);
            MockProperties<ReplaceWithMock> mockProperties = new MockProperties<ReplaceWithMock>(annotationInstance, field.getType());
            mockedBeans.put(beanName, mockProperties);
        }
        return mockedBeans;
    }

    public Set<String> findSpiedBeans(Class<?> clazz) {
        HashSet<String> mockedBeans = new HashSet<String>();
        for (Field field : clazz.getDeclaredFields()) {
            WrapWithSpy replaceWithMockAnnotation = field.getAnnotation(WrapWithSpy.class);
            if (replaceWithMockAnnotation == null) continue;
            String beanName = this.getBeanName(field);
            mockedBeans.add(beanName);
        }
        return mockedBeans;
    }

    private String getBeanName(Field field) {
        return this.beanNameResolver.retrieveBeanName(field);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockProperties<T extends Annotation> {
        private T annotationInstance;
        private Class<?> mockClass;

        public MockProperties(T annotationInstance, Class<?> mockClass) {
            this.annotationInstance = annotationInstance;
            this.mockClass = mockClass;
        }

        public T getAnnotationInstance() {
            return this.annotationInstance;
        }

        public Class<?> getMockClass() {
            return this.mockClass;
        }
    }
}

