/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.util.Properties;
import rpc.BasicConnectionContext;
import rpc.ConnectionOrientedPdu;
import rpc.core.PresentationContext;
import rpc.core.PresentationResult;
import rpc.core.PresentationSyntax;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindPdu;

public final class JIComRuntimeConnectionContext
extends BasicConnectionContext {
    private static final String IID = "IID";
    private boolean established = false;
    private Properties properties = null;

    public ConnectionOrientedPdu init(PresentationContext context, Properties properties) throws IOException {
        super.init(context, properties);
        this.properties = properties;
        return null;
    }

    public ConnectionOrientedPdu accept(ConnectionOrientedPdu pdu) throws IOException {
        ConnectionOrientedPdu reply = null;
        switch (pdu.getType()) {
            case 11: {
                this.established = true;
                PresentationContext[] presentationContexts = ((BindPdu)pdu).getContextList();
                reply = new BindAcknowledgePdu();
                PresentationResult[] result = new PresentationResult[1];
                for (int i = 0; i < presentationContexts.length; ++i) {
                    PresentationContext presentationContext = presentationContexts[i];
                    if (presentationContext.abstractSyntax.toString().toUpperCase().equalsIgnoreCase(this.properties.getProperty(IID))) continue;
                    result[0] = new PresentationResult(2, 1, new PresentationSyntax("00000000-0000-0000-0000-000000000000:0.0"));
                    ((BindAcknowledgePdu)reply).setResultList(result);
                    break;
                }
                if (((BindAcknowledgePdu)reply).getResultList() == null) {
                    result[0] = new PresentationResult();
                    ((BindAcknowledgePdu)reply).setAssociationGroupId(new Object().hashCode());
                    ((BindAcknowledgePdu)reply).setResultList(result);
                }
                ((BindAcknowledgePdu)reply).setCallId(pdu.getCallId());
                break;
            }
            case 14: {
                this.established = true;
                PresentationContext[] presentationContexts = ((AlterContextPdu)pdu).getContextList();
                reply = new AlterContextResponsePdu();
                PresentationResult[] result = new PresentationResult[1];
                for (int i = 0; i < presentationContexts.length; ++i) {
                    PresentationContext presentationContext = presentationContexts[i];
                    if (presentationContext.abstractSyntax.toString().toUpperCase().equalsIgnoreCase(this.properties.getProperty(IID))) continue;
                    result[0] = new PresentationResult(2, 1, new PresentationSyntax("00000000-0000-0000-0000-000000000000:0.0"));
                    ((AlterContextResponsePdu)reply).setResultList(result);
                    break;
                }
                if (((AlterContextResponsePdu)reply).getResultList() == null) {
                    result[0] = new PresentationResult();
                    ((AlterContextResponsePdu)reply).setAssociationGroupId(new Object().hashCode());
                    ((AlterContextResponsePdu)reply).setResultList(result);
                }
                ((AlterContextResponsePdu)reply).setCallId(pdu.getCallId());
                break;
            }
            default: {
                reply = super.accept(reply);
            }
        }
        return reply;
    }

    public boolean isEstablished() {
        return super.isEstablished() | this.established;
    }
}

