/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.test;

import java.io.IOException;
import java.util.logging.Level;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class TestJIThreading {
    static final String domain = "fdgnt";
    static final String user = "roopchand";
    static final String password = "QweQwe007";
    static final String host = "estroopchandnb";
    static final String comServerName = "WbemScripting.SWbemLocator";
    static final String comObjectId = "76A6415B-CB41-11d1-8B02-00600806D9B6";
    static final int totalLoops = 500;
    static final int numThreads = 25;
    static int loopsPerThread = 20;
    static final int waitForThreadssleepTime = 1000;

    public void setUp() {
        try {
            JISystem.setInBuiltLogHandler(false);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JISystem.setAutoRegisteration(true);
        JISystem.getLogger().setLevel(Level.ALL);
    }

    public void testThreading() {
        int i;
        ThreadGroup group = new ThreadGroup("JIThreading Group");
        Thread[] threads = new Thread[25];
        for (i = 0; i < 25; ++i) {
            threads[i] = new TestThread(group, "TestThread: " + i);
        }
        for (i = 0; i < 25; ++i) {
            threads[i].start();
        }
        boolean keepSleeping = true;
        if (keepSleeping) {
            try {
                for (int i2 = 0; i2 < threads.length; ++i2) {
                    Thread thread = threads[i2];
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                JISystem.getLogger().log(Level.SEVERE, "InterruptedException caught", e);
            }
        }
    }

    public static void main(String[] args) {
        TestJIThreading testJIThreading = new TestJIThreading();
        testJIThreading.setUp();
        testJIThreading.testThreading();
    }

    public static class TestThread
    extends Thread {
        public TestThread(ThreadGroup group, String name) {
            super(group, name);
        }

        public void run() {
            for (int i = 0; i < loopsPerThread; ++i) {
                this.doStuff();
            }
        }

        public void doStuff() {
            try {
                JISession session = JISession.createSession(TestJIThreading.domain, TestJIThreading.user, TestJIThreading.password);
                JIProgId progId = JIProgId.valueOf(TestJIThreading.comServerName);
                JIComServer baseComServer = new JIComServer(progId, TestJIThreading.host, session);
                IJIComObject unknown = baseComServer.createInstance();
                IJIComObject baseComObject = unknown.queryInterface(TestJIThreading.comObjectId);
                IJIDispatch baseDispatch = (IJIDispatch)JIObjectFactory.narrowObject(baseComObject.queryInterface("00020400-0000-0000-c000-000000000046"));
                JIVariant connectServer = baseDispatch.callMethodA("ConnectServer", new Object[]{new JIString(TestJIThreading.host), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), new Integer(0), JIVariant.OPTIONAL_PARAM()})[0];
                JISession.destroySession(session);
                System.out.println("doStuff() run complete");
            }
            catch (Exception e) {
                JISystem.getLogger().log(Level.SEVERE, "Caught exception: ", e);
            }
        }
    }
}

