/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHQueryBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.RateLimitTarget;
import org.kohsuke.github.SearchResult;

public abstract class GHSearchBuilder<T>
extends GHQueryBuilder<T> {
    protected final List<String> terms = new ArrayList<String>();
    private final Class<? extends SearchResult<T>> receiverType;

    GHSearchBuilder(GitHub root, Class<? extends SearchResult<T>> receiverType) {
        super(root);
        this.receiverType = receiverType;
        this.req.withUrlPath(this.getApiUrl(), new String[0]);
        this.req.rateLimit(RateLimitTarget.SEARCH);
    }

    public GHQueryBuilder<T> q(String term) {
        this.terms.add(term);
        return this;
    }

    @Override
    public PagedSearchIterable<T> list() {
        this.req.set("q", StringUtils.join(this.terms, (String)" "));
        return new PagedSearchIterable(this.root(), this.req.build(), this.receiverType);
    }

    protected abstract String getApiUrl();
}

