/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.locale;

import java.util.Arrays;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.keycloak.locale.DefaultLocaleSelectorProvider;

public class DefaultLocaleSelectorProviderTest {
    private static final Locale LOCALE_DE_CH = Locale.forLanguageTag("de-CH");
    private static final Locale LOCALE_DE_CH_1996 = Locale.forLanguageTag("de-CH-1996");
    private static final Locale LOCALE_DE_AT = Locale.forLanguageTag("de-AT");

    @Test
    public void findBestMatchingLocaleReturnsExactLocaleInCaseOfExactMatch() {
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, Locale.GERMAN), (String[])new String[]{"de-CH-1996", "de-CH", "de"}), (Matcher)CoreMatchers.equalTo((Object)Locale.GERMAN));
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_CH), (String[])new String[]{"de-CH-1996", "de-CH", "de"}), (Matcher)CoreMatchers.equalTo((Object)LOCALE_DE_CH));
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_CH_1996), (String[])new String[]{"de-CH-1996", "de-CH", "de"}), (Matcher)CoreMatchers.equalTo((Object)LOCALE_DE_CH_1996));
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_CH_1996, LOCALE_DE_CH, Locale.GERMAN), (String[])new String[]{"de"}), (Matcher)CoreMatchers.equalTo((Object)Locale.GERMAN));
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_CH_1996, LOCALE_DE_CH, Locale.GERMAN), (String[])new String[]{"de-CH"}), (Matcher)CoreMatchers.equalTo((Object)LOCALE_DE_CH));
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_CH_1996, LOCALE_DE_CH, Locale.GERMAN), (String[])new String[]{"de-CH-1996"}), (Matcher)CoreMatchers.equalTo((Object)LOCALE_DE_CH_1996));
    }

    @Test
    public void findBestMatchingLocaleForRegionReturnsLanguageWhenNoLocaleForRegionDefined() {
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, Locale.GERMAN), (String[])new String[]{"de-CH"}), (Matcher)CoreMatchers.equalTo((Object)Locale.GERMAN));
    }

    @Test
    public void findBestMatchingLocaleForLanguageReturnsLanguageWhenLocalesForBothLanguageAndRegionDefined() {
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_CH, Locale.GERMAN), (String[])new String[]{"de"}), (Matcher)CoreMatchers.equalTo((Object)Locale.GERMAN));
    }

    @Test
    public void findBestMatchingLocaleForLanguageReturnsRegionWhenNoLocaleForLanguageDefined() {
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_CH), (String[])new String[]{"de"}), (Matcher)CoreMatchers.equalTo((Object)LOCALE_DE_CH));
    }

    @Test
    public void findBestMatchingLocaleReturnsNullWhenNoMatchingLanguageIsFound() {
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, Locale.GERMAN), (String[])new String[]{"cs"}), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void findBestMatchingLocaleForRegionReturnsNullInCaseOfDifferentRegionsForSameLanguage() {
        MatcherAssert.assertThat((Object)DefaultLocaleSelectorProvider.findBestMatchingLocale(Arrays.asList(Locale.FRENCH, LOCALE_DE_AT), (String[])new String[]{"de-CH"}), (Matcher)CoreMatchers.nullValue());
    }
}

