/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.Provider;
import org.keycloak.services.DefaultKeycloakContext;
import org.keycloak.services.DefaultKeycloakSession;

public class ExportImportManagerTest {
    @After
    public void reset() {
        ExportImportConfig.reset();
    }

    @Test
    public void testImportOnStartup() {
        ExportImportConfig.setDir((String)"/some/dir");
        new ExportImportManager((KeycloakSession)new DefaultKeycloakSession(null){

            protected DefaultKeycloakContext createKeycloakContext(KeycloakSession session) {
                return null;
            }
        });
        Assert.assertEquals((Object)"import", (Object)ExportImportConfig.getAction());
        Assert.assertEquals((Object)Strategy.IGNORE_EXISTING.toString(), (Object)ExportImportConfig.getStrategy());
        Assert.assertTrue((boolean)ExportImportConfig.isReplacePlaceholders());
    }

    @Test
    public void testImport() {
        ExportImportConfig.setAction((String)"import");
        new ExportImportManager((KeycloakSession)new DefaultKeycloakSession(null){

            protected DefaultKeycloakContext createKeycloakContext(KeycloakSession session) {
                return null;
            }

            public <T extends Provider> T getProvider(Class<T> clazz, String id) {
                return (T)new ImportProvider(){

                    public void close() {
                    }

                    public boolean isMasterRealmExported() throws IOException {
                        return false;
                    }

                    public void importModel() throws IOException {
                    }
                };
            }
        });
        Assert.assertEquals((Object)"import", (Object)ExportImportConfig.getAction());
        Assert.assertNull((Object)ExportImportConfig.getStrategy());
        Assert.assertFalse((boolean)ExportImportConfig.isReplacePlaceholders());
    }
}

