/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.profile.ProfileConfigResolver;
import org.keycloak.common.profile.ProfileException;
import org.keycloak.common.util.KerberosJdkProvider;

public class Profile {
    private static volatile Map<String, TreeSet<Feature>> FEATURES;
    private static final Set<String> ESSENTIAL_FEATURES;
    private static final Logger logger;
    private static volatile Profile CURRENT;
    private final ProfileName profileName;
    private final Map<Feature, Boolean> features;

    public static Profile defaults() {
        return Profile.configure(new ProfileConfigResolver[0]);
    }

    public static Profile configure(ProfileConfigResolver ... resolvers) {
        ProfileName profile = Arrays.stream(resolvers).map(ProfileConfigResolver::getProfileName).filter(Objects::nonNull).findFirst().orElse(ProfileName.DEFAULT);
        LinkedHashMap<Feature, Boolean> features = new LinkedHashMap<Feature, Boolean>();
        for (Map.Entry<String, TreeSet<Feature>> entry : Profile.getOrderedFeatures().entrySet()) {
            String unversionedFeature = entry.getKey();
            ProfileConfigResolver.FeatureConfig unversionedConfig = Profile.getFeatureConfig(unversionedFeature, resolvers);
            Feature enabledFeature = null;
            if (unversionedConfig == ProfileConfigResolver.FeatureConfig.ENABLED) {
                enabledFeature = entry.getValue().iterator().next();
                if (!enabledFeature.isAvailable()) {
                    throw new ProfileException(String.format("Feature %s cannot be enabled as it is not available.", unversionedFeature));
                }
            } else if (unversionedConfig == ProfileConfigResolver.FeatureConfig.DISABLED && ESSENTIAL_FEATURES.contains(unversionedFeature)) {
                throw new ProfileException(String.format("Feature %s cannot be disabled.", unversionedFeature));
            }
            boolean isExplicitlyEnabledFeature = false;
            block5: for (Feature f : entry.getValue()) {
                ProfileConfigResolver.FeatureConfig configuration = Profile.getFeatureConfig(f.getVersionedKey(), resolvers);
                if (configuration != ProfileConfigResolver.FeatureConfig.UNCONFIGURED && unversionedConfig != ProfileConfigResolver.FeatureConfig.UNCONFIGURED) {
                    throw new ProfileException("Versioned feature " + f.getVersionedKey() + " is not expected as " + unversionedFeature + " is already " + unversionedConfig.name().toLowerCase());
                }
                switch (configuration) {
                    case ENABLED: {
                        if (isExplicitlyEnabledFeature) {
                            throw new ProfileException(String.format("Multiple versions of the same feature %s, %s should not be enabled.", enabledFeature.getVersionedKey(), f.getVersionedKey()));
                        }
                        if (!f.isAvailable()) {
                            throw new ProfileException(String.format("Feature %s cannot be enabled as it is not available.", f.getVersionedKey()));
                        }
                        enabledFeature = f;
                        isExplicitlyEnabledFeature = true;
                        continue block5;
                    }
                    case DISABLED: {
                        throw new ProfileException("Feature " + f.getVersionedKey() + " should not be disabled using a versioned key.");
                    }
                }
                if (unversionedConfig != ProfileConfigResolver.FeatureConfig.UNCONFIGURED || enabledFeature != null || !Profile.isEnabledByDefault(profile, f) || !f.isAvailable()) continue;
                enabledFeature = f;
            }
            for (Feature f : entry.getValue()) {
                features.put(f, f == enabledFeature);
            }
        }
        Profile.verifyConfig(features);
        CURRENT = new Profile(profile, features);
        return CURRENT;
    }

    private static boolean isEnabledByDefault(ProfileName profile, Feature f) {
        switch (f.getType()) {
            case DEFAULT: {
                return true;
            }
            case PREVIEW: {
                return profile.equals((Object)ProfileName.PREVIEW);
            }
        }
        return false;
    }

    private static ProfileConfigResolver.FeatureConfig getFeatureConfig(String feature, ProfileConfigResolver ... resolvers) {
        ProfileConfigResolver.FeatureConfig configuration = Arrays.stream(resolvers).map(r -> r.getFeatureConfig(feature)).filter(r -> !r.equals((Object)ProfileConfigResolver.FeatureConfig.UNCONFIGURED)).findFirst().orElse(ProfileConfigResolver.FeatureConfig.UNCONFIGURED);
        return configuration;
    }

    private static Map<String, TreeSet<Feature>> getOrderedFeatures() {
        if (FEATURES == null) {
            Comparator<Feature> comparator = Comparator.comparing(Feature::getType).thenComparing(Comparator.comparingInt(Feature::getVersion).reversed());
            HashMap<String, TreeSet<Feature>> features = new HashMap<String, TreeSet<Feature>>();
            Stream.of(Feature.values()).forEach(f -> features.compute(f.getUnversionedKey(), (k, v) -> {
                if (v == null) {
                    v = new TreeSet<Feature>(comparator);
                }
                v.add(f);
                return v;
            }));
            FEATURES = features;
        }
        return FEATURES;
    }

    public static Set<String> getAllUnversionedFeatureNames() {
        return Collections.unmodifiableSet(Profile.getOrderedFeatures().keySet());
    }

    public static Set<String> getDisableableUnversionedFeatureNames() {
        return Profile.getOrderedFeatures().keySet().stream().filter(f -> !ESSENTIAL_FEATURES.contains(f)).collect(Collectors.toSet());
    }

    public static Set<Feature> getFeatureVersions(String feature) {
        TreeSet<Feature> versions = Profile.getOrderedFeatures().get(feature);
        if (versions == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(versions);
    }

    public static Profile init(ProfileName profileName, Map<Feature, Boolean> features) {
        CURRENT = new Profile(profileName, features);
        return CURRENT;
    }

    private Profile(ProfileName profileName, Map<Feature, Boolean> features) {
        this.profileName = profileName;
        this.features = Collections.unmodifiableMap(features);
        this.logUnsupportedFeatures();
    }

    public static Profile getInstance() {
        return CURRENT;
    }

    public static void reset() {
        CURRENT = null;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        return Profile.getInstance().features.get((Object)feature);
    }

    public ProfileName getName() {
        return this.profileName;
    }

    public Set<Feature> getAllFeatures() {
        return this.features.keySet();
    }

    public Set<Feature> getDisabledFeatures() {
        return this.features.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<Feature> getPreviewFeatures() {
        return Stream.concat(this.getFeatures(Feature.Type.PREVIEW).stream(), this.getFeatures(Feature.Type.PREVIEW_DISABLED_BY_DEFAULT).stream()).collect(Collectors.toSet());
    }

    public Set<Feature> getExperimentalFeatures() {
        return this.getFeatures(Feature.Type.EXPERIMENTAL);
    }

    public Set<Feature> getDeprecatedFeatures() {
        return this.getFeatures(Feature.Type.DEPRECATED);
    }

    public Set<Feature> getFeatures(Feature.Type type) {
        return this.features.keySet().stream().filter(f -> f.getType().equals((Object)type)).collect(Collectors.toSet());
    }

    public Map<Feature, Boolean> getFeatures() {
        return this.features;
    }

    private static void verifyConfig(Map<Feature, Boolean> features) {
        for (Feature f : features.keySet()) {
            if (!features.get((Object)f).booleanValue() || f.getDependencies() == null) continue;
            for (Feature d : f.getDependencies()) {
                if (features.get((Object)d).booleanValue()) continue;
                throw new ProfileException("Feature " + f.getKey() + " depends on disabled feature " + d.getKey());
            }
        }
    }

    private void logUnsupportedFeatures() {
        this.logUnsupportedFeatures(Feature.Type.PREVIEW, this.getPreviewFeatures(), Logger.Level.INFO);
        this.logUnsupportedFeatures(Feature.Type.EXPERIMENTAL, this.getExperimentalFeatures(), Logger.Level.WARN);
        this.logUnsupportedFeatures(Feature.Type.DEPRECATED, this.getDeprecatedFeatures(), Logger.Level.WARN);
    }

    private void logUnsupportedFeatures(Feature.Type type, Set<Feature> checkedFeatures, Logger.Level level) {
        Set checkedFeatureTypes = checkedFeatures.stream().map(Feature::getType).collect(Collectors.toSet());
        String enabledFeaturesOfType = this.features.entrySet().stream().filter(e -> (Boolean)e.getValue() != false && checkedFeatureTypes.contains((Object)((Feature)((Object)((Object)e.getKey()))).getType())).map(e -> ((Feature)((Object)((Object)e.getKey()))).getVersionedKey()).sorted().collect(Collectors.joining(", "));
        if (!enabledFeaturesOfType.isEmpty()) {
            logger.logv(level, "{0} features enabled: {1}", (Object)type.getLabel(), (Object)enabledFeaturesOfType);
        }
    }

    static {
        ESSENTIAL_FEATURES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Feature.HOSTNAME_V2.getUnversionedKey())));
        logger = Logger.getLogger(Profile.class);
    }

    public static enum ProfileName {
        DEFAULT,
        PREVIEW;

    }

    public static enum Feature {
        AUTHORIZATION("Authorization Service", Type.DEFAULT, new Feature[0]),
        ACCOUNT_API("Account Management REST API", Type.DEFAULT, new Feature[0]),
        ACCOUNT_V3("Account Console version 3", Type.DEFAULT, 3, ACCOUNT_API),
        ADMIN_FINE_GRAINED_AUTHZ("Fine-Grained Admin Permissions", Type.PREVIEW, 1, new Feature[0]),
        ADMIN_FINE_GRAINED_AUTHZ_V2("Fine-Grained Admin Permissions version 2", Type.EXPERIMENTAL, 2, AUTHORIZATION),
        ADMIN_API("Admin API", Type.DEFAULT, new Feature[0]),
        ADMIN_V2("New Admin Console", Type.DEFAULT, 2, ADMIN_API),
        LOGIN_V2("New Login Theme", Type.DEFAULT, 2, new Feature[0]),
        LOGIN_V1("Legacy Login Theme", Type.DEPRECATED, 1, new Feature[0]),
        QUICK_THEME("WYSIWYG theme configuration tool", Type.EXPERIMENTAL, 1, new Feature[0]),
        DOCKER("Docker Registry protocol", Type.DISABLED_BY_DEFAULT, new Feature[0]),
        IMPERSONATION("Ability for admins to impersonate users", Type.DEFAULT, new Feature[0]),
        SCRIPTS("Write custom authenticators using JavaScript", Type.PREVIEW, new Feature[0]),
        TOKEN_EXCHANGE("Token Exchange Service", Type.PREVIEW, new Feature[0]),
        WEB_AUTHN("W3C Web Authentication (WebAuthn)", Type.DEFAULT, new Feature[0]),
        CLIENT_POLICIES("Client configuration policies", Type.DEFAULT, new Feature[0]),
        CIBA("OpenID Connect Client Initiated Backchannel Authentication (CIBA)", Type.DEFAULT, new Feature[0]),
        PAR("OAuth 2.0 Pushed Authorization Requests (PAR)", Type.DEFAULT, new Feature[0]),
        DYNAMIC_SCOPES("Dynamic OAuth 2.0 scopes", Type.EXPERIMENTAL, new Feature[0]),
        CLIENT_SECRET_ROTATION("Client Secret Rotation", Type.PREVIEW, new Feature[0]),
        STEP_UP_AUTHENTICATION("Step-up Authentication", Type.DEFAULT, new Feature[0]),
        KERBEROS("Kerberos", Type.DEFAULT, 1, () -> KerberosJdkProvider.getProvider().isKerberosAvailable(), new Feature[0]),
        RECOVERY_CODES("Recovery codes", Type.PREVIEW, new Feature[0]),
        UPDATE_EMAIL("Update Email Action", Type.PREVIEW, new Feature[0]),
        FIPS("FIPS 140-2 mode", Type.DISABLED_BY_DEFAULT, new Feature[0]),
        DPOP("OAuth 2.0 Demonstrating Proof-of-Possession at the Application Layer", Type.PREVIEW, new Feature[0]),
        DEVICE_FLOW("OAuth 2.0 Device Authorization Grant", Type.DEFAULT, new Feature[0]),
        TRANSIENT_USERS("Transient users for brokering", Type.EXPERIMENTAL, new Feature[0]),
        MULTI_SITE("Multi-site support", Type.DISABLED_BY_DEFAULT, new Feature[0]),
        CLUSTERLESS("Store all session data, work cache and login failure data in an external Infinispan cluster.", Type.EXPERIMENTAL, new Feature[0]),
        CLIENT_TYPES("Client Types", Type.EXPERIMENTAL, new Feature[0]),
        HOSTNAME_V2("Hostname Options V2", Type.DEFAULT, 2, new Feature[0]),
        PERSISTENT_USER_SESSIONS("Persistent online user sessions across restarts and upgrades", Type.DEFAULT, new Feature[0]),
        OID4VC_VCI("Support for the OID4VCI protocol as part of OID4VC.", Type.EXPERIMENTAL, new Feature[0]),
        OPENTELEMETRY("OpenTelemetry Tracing", Type.DEFAULT, new Feature[0]),
        DECLARATIVE_UI("declarative ui spi", Type.EXPERIMENTAL, new Feature[0]),
        ORGANIZATION("Organization support within realms", Type.DEFAULT, new Feature[0]),
        PASSKEYS("Passkeys", Type.PREVIEW, new Feature[0]),
        CACHE_EMBEDDED_REMOTE_STORE("Support for remote-store in embedded Infinispan caches", Type.EXPERIMENTAL, new Feature[0]),
        USER_EVENT_METRICS("Collect metrics based on user events", Type.PREVIEW, new Feature[0]),
        IPA_TUURA_FEDERATION("IPA-Tuura user federation provider", Type.EXPERIMENTAL, new Feature[0]);

        private final Type type;
        private final String label;
        private final String unversionedKey;
        private final String key;
        private final BooleanSupplier isAvailable;
        private Set<Feature> dependencies;
        private int version;

        private Feature(String label, Type type, Feature ... dependencies) {
            this(label, type, 1, (BooleanSupplier)null, dependencies);
        }

        private Feature(String label, Type type, int version, Feature ... dependencies) {
            this(label, type, version, (BooleanSupplier)null, dependencies);
        }

        private Feature(String label, Type type, int version, BooleanSupplier isAvailable, Feature ... dependencies) {
            this.label = label;
            this.type = type;
            this.version = version;
            this.isAvailable = isAvailable;
            this.key = this.name().toLowerCase().replaceAll("_", "-");
            if (this.name().endsWith("_V" + version)) {
                this.unversionedKey = this.key.substring(0, this.key.length() - (String.valueOf(version).length() + 2));
            } else {
                this.unversionedKey = this.key;
                if (this.version > 1) {
                    throw new IllegalStateException("It is expected that the enum name ends with the version");
                }
            }
            this.dependencies = Arrays.stream(dependencies).collect(Collectors.toSet());
        }

        public String getKey() {
            return this.key;
        }

        public String getUnversionedKey() {
            return this.unversionedKey;
        }

        public String getVersionedKey() {
            return this.getUnversionedKey() + ":v" + this.version;
        }

        public String getLabel() {
            return this.label;
        }

        public Type getType() {
            return this.type;
        }

        public Set<Feature> getDependencies() {
            return this.dependencies;
        }

        public int getVersion() {
            return this.version;
        }

        public boolean isAvailable() {
            return this.isAvailable == null || this.isAvailable.getAsBoolean();
        }

        public static enum Type {
            DEFAULT("Default"),
            DISABLED_BY_DEFAULT("Disabled by default"),
            DEPRECATED("Deprecated"),
            PREVIEW("Preview"),
            PREVIEW_DISABLED_BY_DEFAULT("Preview disabled by default"),
            EXPERIMENTAL("Experimental");

            private final String label;

            private Type(String label) {
                this.label = label;
            }

            public String getLabel() {
                return this.label;
            }
        }
    }
}

