/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import com.sun.tools.ws.WsImport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.jvnet.jax_ws_commons.jaxws.AbstractJaxwsMojo;

abstract class WsImportMojo
extends AbstractJaxwsMojo {
    private static final String STALE_FILE_PREFIX = ".";
    private static final String PATTERN = "[^\\s]+\\.wsdl$";
    private String packageName;
    private File catalog;
    private String httpproxy;
    private File wsdlDirectory;
    protected List<String> wsdlFiles;
    private List wsdlUrls;
    protected File bindingDirectory;
    protected List bindingFiles;
    private String wsdlLocation;
    private String target;
    private boolean quiet;
    private String implServiceName = null;
    private String implPortName = null;
    private boolean genJWS;
    private Boolean xadditionalHeaders;
    private boolean xdebug;
    private boolean xnoAddressingDataBinding;
    protected File xauthFile;
    private boolean xdisableSSLHostnameVerification;
    private boolean xuseBaseResourceAndURLToLoadWSDL;
    private boolean xdisableAuthenticator;
    private List<String> xjcArgs;
    private File staleFile;
    private Settings settings;

    WsImportMojo() {
    }

    protected abstract File getImplDestDir();

    public void execute() throws MojoExecutionException {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        String originalSystemClasspath = this.initClassLoader(parent);
        try {
            URL[] wsdls = this.getWSDLFiles();
            if (wsdls.length == 0 && (this.wsdlUrls == null || this.wsdlUrls.isEmpty())) {
                this.getLog().info((CharSequence)"No WSDLs are found to process, Specify atleast one of the following parameters: wsdlFiles, wsdlDirectory or wsdlUrls.");
                return;
            }
            this.processWsdlViaUrls();
            this.processLocalWsdlFiles(wsdls);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parent);
            System.setProperty("java.class.path", originalSystemClasspath);
        }
    }

    private void processLocalWsdlFiles(URL[] wsdls) throws MojoExecutionException, IOException {
        for (URL u : wsdls) {
            String url = u.toExternalForm();
            if (!this.isOutputStale(url)) continue;
            this.getLog().info((CharSequence)("Processing: " + url));
            String relPath = null;
            if ("file".equals(u.getProtocol())) {
                relPath = this.getRelativePath(new File(u.getPath()));
            }
            ArrayList<String> args = this.getWsImportArgs(relPath);
            args.add(url);
            this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
            this.wsImport(args);
            this.touchStaleFile(url);
        }
    }

    private void processWsdlViaUrls() throws MojoExecutionException, IOException {
        for (int i = 0; this.wsdlUrls != null && i < this.wsdlUrls.size(); ++i) {
            String wsdlUrl = this.wsdlUrls.get(i).toString();
            if (!this.isOutputStale(wsdlUrl)) continue;
            this.getLog().info((CharSequence)("Processing: " + wsdlUrl));
            ArrayList<String> args = this.getWsImportArgs(null);
            args.add(wsdlUrl);
            this.getLog().info((CharSequence)("jaxws:wsimport args: " + args));
            this.wsImport(args);
            this.touchStaleFile(wsdlUrl);
        }
    }

    private void wsImport(ArrayList<String> args) throws MojoExecutionException {
        try {
            if (WsImport.doMain((String[])args.toArray(new String[args.size()])) != 0) {
                throw new MojoExecutionException("Error executing: wsimport " + args);
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Error executing: wsimport " + args, t);
        }
    }

    private ArrayList<String> getWsImportArgs(String relativePath) throws MojoExecutionException {
        File[] bindings;
        String proxyString;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCommonArgs());
        if (this.httpproxy != null) {
            args.add("-httpproxy:" + this.httpproxy);
        } else if (this.settings != null && (proxyString = WsImportMojo.getActiveHttpProxy(this.settings)) != null) {
            args.add("-httpproxy:" + proxyString);
        }
        if (this.packageName != null) {
            args.add("-p");
            args.add(this.packageName);
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.wsdlLocation != null) {
            if (relativePath != null) {
                args.add("-wsdllocation");
                args.add(this.wsdlLocation.replaceAll("\\*", relativePath));
            } else if (!this.wsdlLocation.contains("*")) {
                args.add("-wsdllocation");
                args.add(this.wsdlLocation);
            }
        }
        if (this.target != null) {
            args.add("-target");
            args.add(this.target);
        }
        if (this.quiet) {
            args.add("-quiet");
        }
        if (this.genJWS || this.implServiceName != null || this.implPortName != null) {
            args.add("-generateJWS");
            if (this.implServiceName != null) {
                args.add("-implServiceName");
                args.add(this.implServiceName);
            }
            if (this.implPortName != null) {
                args.add("-implPortName");
                args.add(this.implPortName);
            }
            this.getImplDestDir().mkdirs();
            args.add("-implDestDir");
            args.add(this.getImplDestDir().getAbsolutePath());
        }
        if (this.xdebug) {
            args.add("-Xdebug");
        }
        if (this.xnoAddressingDataBinding) {
            args.add("-Xno-addressing-databinding");
        }
        if (this.xadditionalHeaders.booleanValue()) {
            args.add("-XadditionalHeaders");
        }
        if (this.xauthFile != null) {
            args.add("-Xauthfile");
            args.add(this.xauthFile.getAbsolutePath());
        }
        if (this.xdisableSSLHostnameVerification) {
            args.add("-XdisableSSLHostnameVerification");
        }
        if (this.xuseBaseResourceAndURLToLoadWSDL) {
            args.add("-XuseBaseResourceAndURLToLoadWSDL");
        }
        if (this.xdisableAuthenticator) {
            args.add("-XdisableAuthenticator");
        }
        if (this.xjcArgs != null) {
            for (String xjcArg : this.xjcArgs) {
                if (xjcArg.startsWith("-")) {
                    args.add("-B" + xjcArg);
                    continue;
                }
                args.add(xjcArg);
            }
        }
        if ((bindings = this.getBindingFiles()).length > 0 && this.wsdlLocation != null && this.wsdlLocation.contains("*")) {
            throw new MojoExecutionException("External binding file(s) can not be bound to more WSDL files (" + this.wsdlLocation + ")\n" + "Please use either inline binding(s) or multiple execution tags.");
        }
        for (File binding : bindings) {
            args.add("-b");
            args.add(binding.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)("jaxws:wsimport args: " + args));
        return args;
    }

    public final File[] getBindingFiles() {
        File[] bindings;
        if (this.bindingFiles != null) {
            bindings = new File[this.bindingFiles.size()];
            for (int i = 0; i < this.bindingFiles.size(); ++i) {
                String schemaName = (String)this.bindingFiles.get(i);
                File file = new File(schemaName);
                if (!file.isAbsolute()) {
                    file = new File(this.bindingDirectory, schemaName);
                }
                bindings[i] = file;
            }
        } else {
            this.getLog().debug((CharSequence)("The binding Directory is " + this.bindingDirectory));
            bindings = this.bindingDirectory.listFiles(new XMLFile());
            if (bindings == null) {
                bindings = new File[]{};
            }
        }
        return bindings;
    }

    private URL[] getWSDLFiles() {
        URL[] files;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.wsdlFiles != null) {
            files = new URL[this.wsdlFiles.size()];
            for (int i = 0; i < this.wsdlFiles.size(); ++i) {
                String wsdlFileName = this.wsdlFiles.get(i);
                File wsdl = new File(wsdlFileName);
                if (!wsdl.isAbsolute()) {
                    wsdl = new File(this.wsdlDirectory, wsdlFileName);
                }
                if (!wsdl.exists()) {
                    files[i] = loader.getResource(wsdlFileName);
                } else {
                    try {
                        files[i] = wsdl.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(WsImportMojo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.getLog().debug((CharSequence)("The wsdl File is '" + wsdlFileName + "' from '" + files[i] + "'"));
            }
        } else {
            this.getLog().debug((CharSequence)("The wsdl Directory is " + this.wsdlDirectory));
            if (this.wsdlDirectory.exists()) {
                File[] wsdls = this.wsdlDirectory.listFiles(new WSDLFile());
                files = new URL[wsdls != null ? wsdls.length : 0];
                for (int i = 0; i < files.length; ++i) {
                    try {
                        files[i] = wsdls[i].toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(WsImportMojo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                URI rel = this.project.getBasedir().toURI().relativize(this.wsdlDirectory.toURI());
                String dir = rel.getPath();
                URL u = loader.getResource(dir);
                if (u == null) {
                    dir = "WEB-INF/wsdl/";
                    u = loader.getResource(dir);
                }
                if (u == null) {
                    dir = "META-INF/wsdl/";
                    u = loader.getResource(dir);
                }
                if (u == null || !"jar".equalsIgnoreCase(u.getProtocol())) {
                    files = new URL[]{};
                } else {
                    ArrayList<URL> res = new ArrayList<URL>();
                    String path = u.getPath();
                    try {
                        Pattern p = Pattern.compile(dir.replace(File.separatorChar, '/') + PATTERN, 2);
                        Enumeration<JarEntry> jes = new JarFile(path.substring(5, path.indexOf("!/"))).entries();
                        while (jes.hasMoreElements()) {
                            JarEntry je = jes.nextElement();
                            Matcher m = p.matcher(je.getName());
                            if (!m.matches()) continue;
                            String s = "jar:" + path.substring(0, path.indexOf("!/") + 2) + je.getName();
                            res.add(new URL(s));
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(WsImportMojo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    files = res.toArray(new URL[res.size()]);
                }
            }
        }
        return files;
    }

    private String getRelativePath(File f) {
        if (this.wsdlFiles != null) {
            for (String s : this.wsdlFiles) {
                String path = f.getPath().replace(File.separatorChar, '/');
                if (!path.endsWith(s) || path.length() == s.length()) continue;
                return s;
            }
        }
        return null;
    }

    private boolean isOutputStale(String resource) {
        boolean stale;
        File[] sourceBindings = this.getBindingFiles();
        File stFile = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(resource));
        boolean bl = stale = !stFile.exists();
        if (!stale) {
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to wsdls and bindings.");
            long staleMod = stFile.lastModified();
            try {
                URL sourceWsdl = new URL(resource);
                if (sourceWsdl.openConnection().getLastModified() > staleMod) {
                    this.getLog().debug((CharSequence)(resource + " is newer than the stale flag file."));
                    stale = true;
                }
            }
            catch (MalformedURLException mue) {
                File sourceWsdl = new File(resource);
                if (sourceWsdl.lastModified() > staleMod) {
                    this.getLog().debug((CharSequence)(resource + " is newer than the stale flag file."));
                    stale = true;
                }
            }
            catch (IOException ioe) {
                this.getLog().error((Throwable)ioe);
            }
            for (File sourceBinding : sourceBindings) {
                if (sourceBinding.lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceBinding.getName() + " is newer than the stale flag file."));
                stale = true;
            }
        }
        return stale;
    }

    private void touchStaleFile(String resource) throws IOException {
        File stFile = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(resource));
        if (!stFile.exists()) {
            stFile.getParentFile().mkdirs();
            stFile.createNewFile();
            this.getLog().debug((CharSequence)("Stale flag file created.[" + stFile.getAbsolutePath() + "]"));
        } else {
            stFile.setLastModified(System.currentTimeMillis());
        }
    }

    private String getHash(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            Formatter formatter = new Formatter();
            for (byte b : md.digest(s.getBytes("UTF-8"))) {
                formatter.format("%02x", b);
            }
            return formatter.toString();
        }
        catch (UnsupportedEncodingException ex) {
            this.getLog().debug((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.getLog().debug((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        this.getLog().warn((CharSequence)("Could not compute hash for " + s + ". Using fallback method."));
        return s.substring(s.lastIndexOf(47)).replaceAll("\\.", "-");
    }

    static String getActiveHttpProxy(Settings s) {
        String retVal = null;
        for (Proxy p : s.getProxies()) {
            if (!p.isActive() || !"http".equals(p.getProtocol())) continue;
            StringBuilder sb = new StringBuilder();
            String user = p.getUsername();
            String pwd = p.getPassword();
            if (user != null) {
                sb.append(user);
                if (pwd != null) {
                    sb.append(":");
                    sb.append(pwd);
                }
                sb.append("@");
            }
            sb.append(p.getHost());
            sb.append(":");
            sb.append(p.getPort());
            retVal = sb.toString().trim();
            break;
        }
        return retVal;
    }

    private static final class WSDLFile
    implements FileFilter {
        private WSDLFile() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".wsdl");
        }
    }

    private static final class XMLFile
    implements FileFilter {
        private XMLFile() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".xml");
        }
    }
}

