/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.shadow.picocli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.junit.platform.console.shadow.picocli.CommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoComplete {
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_INVALID_INPUT = 1;
    public static final int EXIT_CODE_COMMAND_SCRIPT_EXISTS = 2;
    public static final int EXIT_CODE_COMPLETION_SCRIPT_EXISTS = 3;
    public static final int EXIT_CODE_EXECUTION_ERROR = 4;
    private static final String SCRIPT_HEADER = "#!/usr/bin/env bash\n#\n# %1$s Bash Completion\n# =======================\n#\n# Bash completion support for the `%1$s` command,\n# generated by [picocli](http://picocli.info/) version %2$s.\n#\n# Installation\n# ------------\n#\n# 1. Source all completion scripts in your .bash_profile\n#\n#   cd $YOUR_APP_HOME/bin\n#   for f in $(find . -name \"*_completion\"); do line=\". $(pwd)/$f\"; grep \"$line\" ~/.bash_profile || echo \"$line\" >> ~/.bash_profile; done\n#\n# 2. Open a new bash console, and type `%1$s [TAB][TAB]`\n#\n# 1a. Alternatively, if you have [bash-completion](https://github.com/scop/bash-completion) installed:\n#     Place this file in a `bash-completion.d` folder:\n#\n#   * /etc/bash-completion.d\n#   * /usr/local/etc/bash-completion.d\n#   * ~/bash-completion.d\n#\n# Documentation\n# -------------\n# The script is called by bash whenever [TAB] or [TAB][TAB] is pressed after\n# '%1$s (..)'. By reading entered command line parameters,\n# it determines possible bash completions and writes them to the COMPREPLY variable.\n# Bash then completes the user input if only one entry is listed in the variable or\n# shows the options if more than one is listed in COMPREPLY.\n#\n# References\n# ----------\n# [1] http://stackoverflow.com/a/12495480/1440785\n# [2] http://tiswww.case.edu/php/chet/bash/FAQ\n# [3] https://www.gnu.org/software/bash/manual/html_node/The-Shopt-Builtin.html\n# [4] http://zsh.sourceforge.net/Doc/Release/Options.html#index-COMPLETE_005fALIASES\n# [5] https://stackoverflow.com/questions/17042057/bash-check-element-in-array-for-elements-in-another-array/17042655#17042655\n# [6] https://www.gnu.org/software/bash/manual/html_node/Programmable-Completion.html#Programmable-Completion\n# [7] https://stackoverflow.com/questions/3249432/can-a-bash-tab-completion-script-be-used-in-zsh/27853970#27853970\n#\n\nif [ -n \"$BASH_VERSION\" ]; then\n  # Enable programmable completion facilities when using bash (see [3])\n  shopt -s progcomp\nelif [ -n \"$ZSH_VERSION\" ]; then\n  # Make alias a distinct command for completion purposes when using zsh (see [4])\n  setopt COMPLETE_ALIASES\n  alias compopt=complete\n\n  # Enable bash completion in zsh (see [7])\n  autoload -U +X compinit && compinit\n  autoload -U +X bashcompinit && bashcompinit\nfi\n\n# CompWordsContainsArray takes an array and then checks\n# if all elements of this array are in the global COMP_WORDS array.\n#\n# Returns zero (no error) if all elements of the array are in the COMP_WORDS array,\n# otherwise returns 1 (error).\nfunction CompWordsContainsArray() {\n  declare -a localArray\n  localArray=(\"$@\")\n  local findme\n  for findme in \"${localArray[@]}\"; do\n    if ElementNotInCompWords \"$findme\"; then return 1; fi\n  done\n  return 0\n}\nfunction ElementNotInCompWords() {\n  local findme=\"$1\"\n  local element\n  for element in \"${COMP_WORDS[@]}\"; do\n    if [[ \"$findme\" = \"$element\" ]]; then return 1; fi\n  done\n  return 0\n}\n\n# The `currentPositionalIndex` function calculates the index of the current positional parameter.\n#\n# currentPositionalIndex takes three parameters:\n# the command name,\n# a space-separated string with the names of options that take a parameter, and\n# a space-separated string with the names of boolean options (that don't take any params).\n# When done, this function echos the current positional index to std_out.\n#\n# Example usage:\n# local currIndex=$(currentPositionalIndex \"mysubcommand\" \"$ARG_OPTS\" \"$FLAG_OPTS\")\nfunction currentPositionalIndex() {\n  local commandName=\"$1\"\n  local optionsWithArgs=\"$2\"\n  local booleanOptions=\"$3\"\n  local previousWord\n  local result=0\n\n  for i in $(seq $((COMP_CWORD - 1)) -1 0); do\n    previousWord=${COMP_WORDS[i]}\n    if [ \"${previousWord}\" = \"$commandName\" ]; then\n      break\n    fi\n    if [[ \"${optionsWithArgs}\" =~ ${previousWord} ]]; then\n      ((result-=2)) # Arg option and its value not counted as positional param\n    elif [[ \"${booleanOptions}\" =~ ${previousWord} ]]; then\n      ((result-=1)) # Flag option itself not counted as positional param\n    fi\n    ((result++))\n  done\n  echo \"$result\"\n}\n\n";
    private static final String SCRIPT_FOOTER = "\n# Define a completion specification (a compspec) for the\n# `%1$s`, `%1$s.sh`, and `%1$s.bash` commands.\n# Uses the bash `complete` builtin (see [6]) to specify that shell function\n# `_complete_%1$s` is responsible for generating possible completions for the\n# current word on the command line.\n# The `-o default` option means that if the function generated no matches, the\n# default Bash completions and the Readline default filename completions are performed.\ncomplete -F _complete_%1$s -o default %1$s %1$s.sh %1$s.bash\n";

    private AutoComplete() {
    }

    public static void main(String ... args) {
        CommandLine.IExecutionExceptionHandler errorHandler = new CommandLine.IExecutionExceptionHandler(){

            public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
                ex.printStackTrace();
                commandLine.usage(commandLine.getErr());
                return 4;
            }
        };
        int exitCode = new CommandLine(new App()).setExecutionExceptionHandler(errorHandler).execute(args);
        if (exitCode == 0 && AutoComplete.exitOnSuccess() || exitCode != 0 && AutoComplete.exitOnError()) {
            System.exit(exitCode);
        }
    }

    private static boolean exitOnSuccess() {
        return AutoComplete.syspropDefinedAndNotFalse("org.junit.platform.console.shadow.picocli.autocomplete.systemExitOnSuccess");
    }

    private static boolean exitOnError() {
        return AutoComplete.syspropDefinedAndNotFalse("org.junit.platform.console.shadow.picocli.autocomplete.systemExitOnError");
    }

    private static boolean syspropDefinedAndNotFalse(String key) {
        String value = System.getProperty(key);
        return value != null && !"false".equalsIgnoreCase(value);
    }

    private static String bashify(CharSequence value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (!Character.isSpaceChar(c)) continue;
            builder.append('_');
        }
        return builder.toString();
    }

    private static <T> Predicate<T> negate(final Predicate<T> original) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !original.test(t);
            }
        };
    }

    private static <K, T extends K> List<T> filter(List<T> list, Predicate<K> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : list) {
            if (!filter.test(t)) continue;
            result.add(t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bash(String scriptName, File out, File command, CommandLine commandLine) throws IOException {
        String autoCompleteScript = AutoComplete.bash(scriptName, commandLine);
        FileWriter completionWriter = null;
        Writer scriptWriter = null;
        try {
            completionWriter = new FileWriter(out);
            completionWriter.write(autoCompleteScript);
            if (command != null) {
                scriptWriter = new FileWriter(command);
                scriptWriter.write("#!/usr/bin/env bash\n\nLIBS=path/to/libs\nCP=\"${LIBS}/myApp.jar\"\njava -cp \"${CP}\" '" + commandLine.getCommand().getClass().getName() + "' $@");
            }
        }
        finally {
            if (completionWriter != null) {
                ((Writer)completionWriter).close();
            }
            if (scriptWriter != null) {
                scriptWriter.close();
            }
        }
    }

    public static String bash(String scriptName, CommandLine commandLine) {
        if (scriptName == null) {
            throw new NullPointerException("scriptName");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        StringBuilder result = new StringBuilder();
        result.append(String.format(SCRIPT_HEADER, scriptName, "4.6.1"));
        List<CommandDescriptor> hierarchy = AutoComplete.createHierarchy(scriptName, commandLine);
        result.append(AutoComplete.generateEntryPointFunction(scriptName, commandLine, hierarchy));
        for (CommandDescriptor descriptor : hierarchy) {
            if (descriptor.commandLine.getCommandSpec().usageMessage().hidden()) continue;
            result.append(AutoComplete.generateFunctionForCommand(descriptor.functionName, descriptor.commandName, descriptor.commandLine));
        }
        result.append(String.format(SCRIPT_FOOTER, scriptName));
        return result.toString();
    }

    private static List<CommandDescriptor> createHierarchy(String scriptName, CommandLine commandLine) {
        ArrayList<CommandDescriptor> result = new ArrayList<CommandDescriptor>();
        result.add(new CommandDescriptor("_picocli_" + scriptName, scriptName, commandLine, null));
        AutoComplete.createSubHierarchy(scriptName, commandLine, result);
        return result;
    }

    private static void createSubHierarchy(String scriptName, CommandLine commandLine, List<CommandDescriptor> out) {
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            CommandLine.Model.CommandSpec spec = entry.getValue().getCommandSpec();
            if (spec.usageMessage().hidden()) continue;
            String commandName = entry.getKey();
            String full = spec.qualifiedName("_");
            String withoutTopLevelCommand = full.substring(full.indexOf(95) + 1);
            String withoutCommand = withoutTopLevelCommand.substring(0, withoutTopLevelCommand.lastIndexOf(95) + 1);
            String functionName = "_picocli_" + scriptName + "_" + AutoComplete.bashify(withoutCommand + commandName);
            out.add(new CommandDescriptor(functionName, commandName, entry.getValue(), commandLine));
        }
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
            AutoComplete.createSubHierarchy(scriptName, entry.getValue(), out);
        }
    }

    private static String generateEntryPointFunction(String scriptName, CommandLine commandLine, List<CommandDescriptor> hierarchy) {
        String FUNCTION_HEADER = "# Bash completion entry point function.\n# _complete_%1$s finds which commands and subcommands have been specified\n# on the command line and delegates to the appropriate function\n# to generate possible options and subcommands for the last specified subcommand.\nfunction _complete_%1$s() {\n";
        String FUNCTION_FOOTER = "\n  # No subcommands were specified; generate completions for the top-level command.\n  _picocli_%1$s; return $?;\n}\n";
        StringBuilder buff = new StringBuilder(1024);
        buff.append(String.format(FUNCTION_HEADER, scriptName));
        ArrayList<String> functionCallsToArrContains = new ArrayList<String>();
        AutoComplete.generateFunctionCallsToArrContains(buff, functionCallsToArrContains, hierarchy);
        buff.append("\n");
        Collections.reverse(functionCallsToArrContains);
        for (String func : functionCallsToArrContains) {
            buff.append(func);
        }
        buff.append(String.format(FUNCTION_FOOTER, scriptName));
        return buff.toString();
    }

    private static void generateFunctionCallsToArrContains(StringBuilder buff, List<String> functionCalls, List<CommandDescriptor> hierarchy) {
        for (CommandDescriptor descriptor : hierarchy.subList(1, hierarchy.size())) {
            int count = functionCalls.size();
            CommandLine.Model.CommandSpec spec = descriptor.commandLine.getCommandSpec();
            String full = spec.qualifiedName(" ");
            String withoutTopLevelCommand = full.substring(spec.root().name().length() + 1);
            functionCalls.add(String.format("  if CompWordsContainsArray \"${cmds%2$d[@]}\"; then %1$s; return $?; fi\n", descriptor.functionName, count));
            buff.append(String.format("  local cmds%2$d=(%1$s)\n", withoutTopLevelCommand, count));
        }
    }

    private static String concat(String infix, String ... values) {
        return AutoComplete.concat(infix, Arrays.asList(values));
    }

    private static String concat(String infix, List<String> values) {
        return AutoComplete.concat(infix, values, null, new NullFunction());
    }

    private static <V, T extends V> String concat(String infix, List<T> values, T lastValue, Function<V, String> normalize) {
        StringBuilder sb = new StringBuilder();
        for (T val : values) {
            if (sb.length() > 0) {
                sb.append(infix);
            }
            sb.append(normalize.apply(val));
        }
        if (lastValue == null) {
            return sb.toString();
        }
        if (sb.length() > 0) {
            sb.append(infix);
        }
        return sb.append(normalize.apply(lastValue)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String generateFunctionForCommand(String functionName, String commandName, CommandLine commandLine) {
        void var15_20;
        String FUNCTION_HEADER = "\n# Generates completions for the options and subcommands of the `%s` %scommand.\nfunction %s() {\n  # Get completion data\n  local curr_word=${COMP_WORDS[COMP_CWORD]}\n%s\n  local commands=\"%s\"\n  local flag_opts=\"%s\"\n  local arg_opts=\"%s\"\n";
        String FUNCTION_FOOTER = "\n  if [[ \"${curr_word}\" == -* ]]; then\n    COMPREPLY=( $(compgen -W \"${flag_opts} ${arg_opts}\" -- \"${curr_word}\") )\n  else\n    local positionals=\"\"\n%s    COMPREPLY=( $(compgen -W \"${commands} ${positionals}\" -- \"${curr_word}\") )\n  fi\n}\n";
        CommandLine.Model.CommandSpec commandSpec = commandLine.getCommandSpec();
        String flagOptionNames = AutoComplete.optionNames(AutoComplete.filter(commandSpec.options(), new BooleanArgFilter()));
        List<CommandLine.Model.OptionSpec> argOptionFields = AutoComplete.filter(commandSpec.options(), AutoComplete.negate(new BooleanArgFilter()));
        String argOptionNames = AutoComplete.optionNames(argOptionFields);
        LinkedHashSet<String> subCommands = new LinkedHashSet<String>();
        for (String sub : commandLine.getSubcommands().keySet()) {
            if (commandLine.getSubcommands().get(sub).getCommandSpec().usageMessage().hidden()) continue;
            subCommands.add(sub);
        }
        if (commandLine.getParent() != null && commandLine.getCommand() instanceof CommandLine.HelpCommand) {
            subCommands = new LinkedHashSet(subCommands);
            for (CommandLine subCommandLine : commandLine.getParent().getSubcommands().values()) {
                if (commandLine == subCommandLine || subCommandLine.getCommandSpec().usageMessage().hidden()) continue;
                subCommands.add(subCommandLine.getCommandName());
            }
        }
        String commands = AutoComplete.concat(" ", new ArrayList<String>(subCommands)).trim();
        StringBuilder buff = new StringBuilder(1024);
        String sub = functionName.equals("_picocli_" + commandName) ? "" : "sub";
        String previous_word = argOptionFields.isEmpty() ? "" : "  local prev_word=${COMP_WORDS[COMP_CWORD-1]}\n";
        buff.append(String.format(FUNCTION_HEADER, commandName, sub, functionName, previous_word, commands, flagOptionNames, argOptionNames));
        for (CommandLine.Model.OptionSpec optionSpec : commandSpec.options()) {
            if (optionSpec.hidden() || optionSpec.completionCandidates() == null) continue;
            AutoComplete.generateCompletionCandidates(buff, optionSpec);
        }
        buff.append(AutoComplete.generateOptionsSwitch(argOptionFields));
        for (CommandLine.Model.PositionalParamSpec positionalParamSpec : commandSpec.positionalParameters()) {
            if (positionalParamSpec.completionCandidates() == null) continue;
            AutoComplete.generatePositionParamCompletionCandidates(buff, positionalParamSpec);
        }
        String paramsCases = AutoComplete.generatePositionalParamsCases(commandSpec.positionalParameters(), "", "${curr_word}");
        String string = "";
        if (paramsCases.length() > 0) {
            String POSITIONAL_PARAMS_FOOTER = "    local currIndex\n    currIndex=$(currentPositionalIndex \"%s\" \"${arg_opts}\" \"${flag_opts}\")\n%s";
            String string2 = String.format(POSITIONAL_PARAMS_FOOTER, commandName, paramsCases);
        }
        buff.append(String.format(FUNCTION_FOOTER, var15_20));
        return buff.toString();
    }

    private static void generatePositionParamCompletionCandidates(StringBuilder buff, CommandLine.Model.PositionalParamSpec f) {
        String paramName = AutoComplete.bashify(f.paramLabel());
        buff.append(String.format("  local %s_pos_param_args=\"%s\" # %d-%d values\n", paramName, AutoComplete.concat(" ", AutoComplete.extract(f.completionCandidates())).trim(), f.index().min(), f.index().max()));
    }

    private static void generateCompletionCandidates(StringBuilder buff, CommandLine.Model.OptionSpec f) {
        buff.append(String.format("  local %s_option_args=\"%s\" # %s values\n", AutoComplete.bashify(f.paramLabel()), AutoComplete.concat(" ", AutoComplete.extract(f.completionCandidates())).trim(), f.longestName()));
    }

    private static List<String> extract(Iterable<String> generator) {
        ArrayList<String> result = new ArrayList<String>();
        for (String e : generator) {
            result.add(e);
        }
        return result;
    }

    private static String generatePositionalParamsCases(List<CommandLine.Model.PositionalParamSpec> posParams, String indent, String currWord) {
        StringBuilder buff = new StringBuilder(1024);
        for (CommandLine.Model.PositionalParamSpec param : posParams) {
            if (param.hidden()) continue;
            Class<?> type = param.type();
            if (param.typeInfo().isMultiValue()) {
                type = param.typeInfo().getAuxiliaryTypes()[0];
            }
            String paramName = AutoComplete.bashify(param.paramLabel());
            String ifOrElif = buff.length() > 0 ? "elif" : "if";
            int min = param.index().min();
            int max = param.index().max();
            if (param.completionCandidates() != null) {
                buff.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", indent, ifOrElif, min, max));
                buff.append(String.format("%s      positionals=$( compgen -W \"$%s_pos_param_args\" -- \"%s\" )\n", indent, paramName, currWord));
                continue;
            }
            if (type.equals(File.class) || "java.nio.file.Path".equals(type.getName())) {
                buff.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", indent, ifOrElif, min, max));
                buff.append(String.format("%s      compopt -o filenames\n", indent));
                buff.append(String.format("%s      positionals=$( compgen -f -- \"%s\" ) # files\n", indent, currWord));
                continue;
            }
            if (!type.equals(InetAddress.class)) continue;
            buff.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", indent, ifOrElif, min, max));
            buff.append(String.format("%s      compopt -o filenames\n", indent));
            buff.append(String.format("%s      positionals=$( compgen -A hostname -- \"%s\" )\n", indent, currWord));
        }
        if (buff.length() > 0) {
            buff.append(String.format("%s    fi\n", indent));
        }
        return buff.toString();
    }

    private static String generateOptionsSwitch(List<CommandLine.Model.OptionSpec> argOptions) {
        String optionsCases = AutoComplete.generateOptionsCases(argOptions, "", "${curr_word}");
        if (optionsCases.length() == 0) {
            return "";
        }
        return "\n  compopt +o default\n\n  case ${prev_word} in\n" + optionsCases + "  esac\n";
    }

    private static String generateOptionsCases(List<CommandLine.Model.OptionSpec> argOptionFields, String indent, String currWord) {
        StringBuilder buff = new StringBuilder(1024);
        for (CommandLine.Model.OptionSpec option : argOptionFields) {
            if (option.hidden()) continue;
            Class<?> type = option.type();
            if (option.typeInfo().isMultiValue()) {
                type = option.typeInfo().getAuxiliaryTypes()[0];
            }
            if (option.completionCandidates() != null) {
                buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
                buff.append(String.format("%s      COMPREPLY=( $( compgen -W \"${%s_option_args}\" -- \"%s\" ) )\n", indent, AutoComplete.bashify(option.paramLabel()), currWord));
                buff.append(String.format("%s      return $?\n", indent));
                buff.append(String.format("%s      ;;\n", indent));
                continue;
            }
            if (type.equals(File.class) || "java.nio.file.Path".equals(type.getName())) {
                buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
                buff.append(String.format("%s      compopt -o filenames\n", indent));
                buff.append(String.format("%s      COMPREPLY=( $( compgen -f -- \"%s\" ) ) # files\n", indent, currWord));
                buff.append(String.format("%s      return $?\n", indent));
                buff.append(String.format("%s      ;;\n", indent));
                continue;
            }
            if (type.equals(InetAddress.class)) {
                buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
                buff.append(String.format("%s      compopt -o filenames\n", indent));
                buff.append(String.format("%s      COMPREPLY=( $( compgen -A hostname -- \"%s\" ) )\n", indent, currWord));
                buff.append(String.format("%s      return $?\n", indent));
                buff.append(String.format("%s      ;;\n", indent));
                continue;
            }
            buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
            buff.append(String.format("%s      return\n", indent));
            buff.append(String.format("%s      ;;\n", indent));
        }
        return buff.toString();
    }

    private static String optionNames(List<CommandLine.Model.OptionSpec> options) {
        ArrayList<String> result = new ArrayList<String>();
        for (CommandLine.Model.OptionSpec option : options) {
            if (option.hidden()) continue;
            result.addAll(Arrays.asList(option.names()));
        }
        return AutoComplete.concat(" ", result, "", new NullFunction()).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int complete(CommandLine.Model.CommandSpec spec, String[] args, int argIndex, int positionInArg, int cursor, List<CharSequence> candidates) {
        if (spec == null) {
            throw new NullPointerException("spec is null");
        }
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        if (candidates == null) {
            throw new NullPointerException("candidates list is null");
        }
        if (argIndex == args.length) {
            String[] copy = new String[args.length + 1];
            System.arraycopy(args, 0, copy, 0, args.length);
            args = copy;
            args[argIndex] = "";
        }
        if (argIndex < 0 || argIndex >= args.length) {
            throw new IllegalArgumentException("Invalid argIndex " + argIndex + ": args array only has " + args.length + " elements.");
        }
        if (positionInArg < 0 || positionInArg > args[argIndex].length()) {
            throw new IllegalArgumentException("Invalid positionInArg " + positionInArg + ": args[" + argIndex + "] (" + args[argIndex] + ") only has " + args[argIndex].length() + " characters.");
        }
        String currentArg = args[argIndex];
        boolean reset = spec.parser().collectErrors();
        try {
            String committedPrefix = currentArg.substring(0, positionInArg);
            spec.parser().collectErrors(true);
            CommandLine parser = new CommandLine(spec);
            CommandLine.ParseResult parseResult = parser.parseArgs(args);
            if (argIndex >= parseResult.tentativeMatch.size()) {
                Object startPoint = AutoComplete.findCompletionStartPoint(parseResult);
                AutoComplete.addCandidatesForArgsFollowing(startPoint, candidates);
            } else {
                Object obj = parseResult.tentativeMatch.get(argIndex);
                if (obj instanceof CommandLine.Model.CommandSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(((CommandLine.Model.CommandSpec)obj).parent(), candidates);
                } else if (obj instanceof CommandLine.Model.OptionSpec) {
                    int sep = currentArg.indexOf(spec.parser().separator());
                    if (sep < 0 || positionInArg < sep) {
                        AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)obj, spec), candidates);
                    } else {
                        AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)obj, candidates);
                        int sepLength = spec.parser().separator().length();
                        if (positionInArg < sep + sepLength) {
                            int posInSeparator = positionInArg - sep;
                            String prefix = spec.parser().separator().substring(posInSeparator);
                            for (int i = 0; i < candidates.size(); ++i) {
                                candidates.set(i, prefix + candidates.get(i));
                            }
                            committedPrefix = currentArg.substring(sep, positionInArg);
                        } else {
                            committedPrefix = currentArg.substring(sep + sepLength, positionInArg);
                        }
                    }
                } else if (obj instanceof CommandLine.Model.PositionalParamSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)obj, spec), candidates);
                } else {
                    int i;
                    for (i = argIndex - 1; i > 0 && !AutoComplete.isPicocliModelObject(parseResult.tentativeMatch.get(i)); --i) {
                    }
                    if (i < 0) {
                        int n = -1;
                        return n;
                    }
                    AutoComplete.addCandidatesForArgsFollowing(parseResult.tentativeMatch.get(i), candidates);
                }
            }
            AutoComplete.filterAndTrimMatchingPrefix(committedPrefix, candidates);
            int n = candidates.isEmpty() ? -1 : cursor;
            return n;
        }
        finally {
            spec.parser().collectErrors(reset);
        }
    }

    private static Object findCompletionStartPoint(CommandLine.ParseResult parseResult) {
        List<Object> tentativeMatches = parseResult.tentativeMatch;
        for (int i = 1; i <= tentativeMatches.size(); ++i) {
            Object found = tentativeMatches.get(tentativeMatches.size() - i);
            if (found instanceof CommandLine.Model.CommandSpec) {
                return found;
            }
            if (!(found instanceof CommandLine.Model.ArgSpec)) continue;
            CommandLine.Range arity = ((CommandLine.Model.ArgSpec)found).arity();
            if (i < arity.min()) {
                return found;
            }
            return AutoComplete.findCommandFor((CommandLine.Model.ArgSpec)found, parseResult.commandSpec());
        }
        return parseResult.commandSpec();
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.ArgSpec arg, CommandLine.Model.CommandSpec cmd) {
        return arg instanceof CommandLine.Model.OptionSpec ? AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)arg, cmd) : AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)arg, cmd);
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.OptionSpec option, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.OptionSpec defined : commandSpec.options()) {
            if (defined != option) continue;
            return commandSpec;
        }
        for (CommandLine sub : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec result = AutoComplete.findCommandFor(option, sub.getCommandSpec());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.PositionalParamSpec positional, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.PositionalParamSpec defined : commandSpec.positionalParameters()) {
            if (defined != positional) continue;
            return commandSpec;
        }
        for (CommandLine sub : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec result = AutoComplete.findCommandFor(positional, sub.getCommandSpec());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static boolean isPicocliModelObject(Object obj) {
        return obj instanceof CommandLine.Model.CommandSpec || obj instanceof CommandLine.Model.OptionSpec || obj instanceof CommandLine.Model.PositionalParamSpec;
    }

    private static void filterAndTrimMatchingPrefix(String prefix, List<CharSequence> candidates) {
        ArrayList<CharSequence> replace = new ArrayList<CharSequence>();
        for (CharSequence seq : candidates) {
            if (!seq.toString().startsWith(prefix)) continue;
            replace.add(seq.subSequence(prefix.length(), seq.length()));
        }
        candidates.clear();
        candidates.addAll(replace);
    }

    private static void addCandidatesForArgsFollowing(Object obj, List<CharSequence> candidates) {
        if (obj == null) {
            return;
        }
        if (obj instanceof CommandLine.Model.CommandSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.CommandSpec)obj, candidates);
        } else if (obj instanceof CommandLine.Model.OptionSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)obj, candidates);
        } else if (obj instanceof CommandLine.Model.PositionalParamSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.PositionalParamSpec)obj, candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.CommandSpec commandSpec, List<CharSequence> candidates) {
        if (commandSpec == null) {
            return;
        }
        for (Map.Entry<String, CommandLine> entry : commandSpec.subcommands().entrySet()) {
            if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
            candidates.add(entry.getKey());
            candidates.addAll(Arrays.asList(entry.getValue().getCommandSpec().aliases()));
        }
        candidates.addAll(commandSpec.optionsMap().keySet());
        for (CommandLine.Model.PositionalParamSpec positional : commandSpec.positionalParameters()) {
            if (positional.hidden()) continue;
            AutoComplete.addCandidatesForArgsFollowing(positional, candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.OptionSpec optionSpec, List<CharSequence> candidates) {
        if (optionSpec != null && !optionSpec.hidden()) {
            AutoComplete.addCompletionCandidates(optionSpec.completionCandidates(), candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.PositionalParamSpec positionalSpec, List<CharSequence> candidates) {
        if (positionalSpec != null && !positionalSpec.hidden()) {
            AutoComplete.addCompletionCandidates(positionalSpec.completionCandidates(), candidates);
        }
    }

    private static void addCompletionCandidates(Iterable<String> completionCandidates, List<CharSequence> candidates) {
        if (completionCandidates != null) {
            for (String candidate : completionCandidates) {
                candidates.add(candidate);
            }
        }
    }

    private static class CommandDescriptor {
        final String functionName;
        final String commandName;
        final CommandLine commandLine;
        final CommandLine parent;

        CommandDescriptor(String functionName, String commandName, CommandLine commandLine, CommandLine parent) {
            this.functionName = functionName;
            this.commandName = commandName;
            this.commandLine = commandLine;
            this.parent = parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanArgFilter
    implements Predicate<CommandLine.Model.ArgSpec> {
        private BooleanArgFilter() {
        }

        @Override
        public boolean test(CommandLine.Model.ArgSpec f) {
            return f.type() == Boolean.TYPE || f.type() == Boolean.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Predicate<T> {
        public boolean test(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullFunction
    implements Function<CharSequence, String> {
        private NullFunction() {
        }

        @Override
        public String apply(CharSequence value) {
            return value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bashify
    implements Function<CharSequence, String> {
        private Bashify() {
        }

        @Override
        public String apply(CharSequence value) {
            return AutoComplete.bashify(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Function<T, V> {
        public V apply(T var1);
    }

    @CommandLine.Command(name="generate-completion", version={"generate-completion 4.6.1"}, mixinStandardHelpOptions=true, description={"Generate bash/zsh completion script for ${ROOT-COMMAND-NAME:-the root command of this command}.", "Run the following command to give `${ROOT-COMMAND-NAME:-$PARENTCOMMAND}` TAB completion in the current shell:", "", "  source <(${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME})", ""}, optionListHeading="Options:%n", helpCommand=true)
    public static class GenerateCompletion
    implements Runnable {
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        public void run() {
            String script = AutoComplete.bash(this.spec.root().name(), this.spec.root().commandLine());
            this.spec.commandLine().getOut().print(script);
            this.spec.commandLine().getOut().print('\n');
            this.spec.commandLine().getOut().flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CommandLine.Command(name="org.junit.platform.console.shadow.picocli.AutoComplete", mixinStandardHelpOptions=true, showAtFileInUsageHelp=true, version={"org.junit.platform.console.shadow.picocli.AutoComplete 4.6.1"}, sortOptions=false, description={"Generates a bash completion script for the specified command class."}, footerHeading="%n@|bold System Properties:|@%n", footer={"Set the following system properties to control the exit code of this program:", "", "* `\"@|yellow picocli.autocomplete.systemExitOnSuccess|@\"`", "   call `System.exit(0)` when execution completes normally.", "* `\"@|yellow picocli.autocomplete.systemExitOnError|@\"`", "   call `System.exit(ERROR_CODE)` when an error occurs.", "", "If these system properties are not defined or have value \"false\", this program completes without terminating the JVM.", "", "Example", "-------", "  java -cp \"myapp.jar;picocli-4.6.1.jar\" \\", "              picocli.AutoComplete my.pkg.MyClass"}, exitCodeListHeading="%nExit Codes:%n", exitCodeList={"0:Successful program execution", "1:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc.", "2:The specified command script exists (Specify `--force` to overwrite).", "3:The specified completion script exists (Specify `--force` to overwrite).", "4:An exception occurred while generating the completion script."}, exitCodeOnInvalidInput=1, exitCodeOnExecutionException=4)
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="1", description={"Fully qualified class name of the annotated `@Command` class to generate a completion script for."})
        String commandLineFQCN;
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. When omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Option(names={"-n", "--name"}, description={"Optionally specify the name of the command to create a completion script for. When omitted, the annotated class `@Command(name = \"...\")` attribute is used. If no `@Command(name = ...)` attribute exists, '<CLASS-SIMPLE-NAME>' (in lower-case) is used."})
        String commandName;
        @CommandLine.Option(names={"-o", "--completionScript"}, description={"Optionally specify the path of the completion script file to generate. When omitted, a file named '<commandName>_completion' is generated in the current directory."})
        File autoCompleteScript;
        @CommandLine.Option(names={"-w", "--writeCommandScript"}, description={"Write a '<commandName>' sample command script to the same directory as the completion script."})
        boolean writeCommandScript;
        @CommandLine.Option(names={"-f", "--force"}, description={"Overwrite existing script files."})
        boolean overwriteIfExists;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            CommandLine.IFactory factory = CommandLine.defaultFactory();
            if (this.factoryClass != null) {
                factory = (CommandLine.IFactory)factory.create(Class.forName(this.factoryClass));
            }
            Class<?> cls = Class.forName(this.commandLineFQCN);
            Object instance = factory.create(cls);
            CommandLine commandLine = new CommandLine(instance, factory);
            if (this.commandName == null) {
                this.commandName = commandLine.getCommandName();
                if ("<main class>".equals(this.commandName)) {
                    this.commandName = cls.getSimpleName().toLowerCase();
                }
            }
            if (this.autoCompleteScript == null) {
                this.autoCompleteScript = new File(this.commandName + "_completion");
            }
            File commandScript = null;
            if (this.writeCommandScript) {
                commandScript = new File(this.autoCompleteScript.getAbsoluteFile().getParentFile(), this.commandName);
            }
            if (commandScript != null && !this.overwriteIfExists && this.checkExists(commandScript)) {
                return 2;
            }
            if (!this.overwriteIfExists && this.checkExists(this.autoCompleteScript)) {
                return 3;
            }
            AutoComplete.bash(this.commandName, this.autoCompleteScript, commandScript, commandLine);
            return 0;
        }

        private boolean checkExists(File file) {
            if (file.exists()) {
                PrintWriter err = this.spec.commandLine().getErr();
                err.printf("ERROR: picocli.AutoComplete: %s exists. Specify --force to overwrite.%n", file.getAbsolutePath());
                this.spec.commandLine().usage(err);
                return true;
            }
            return false;
        }
    }
}

