/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u0018H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "factory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "packageFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;Ljava/util/Collection;)V", "allDeclaredSubPackages", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "containsFile", "", "file", "doCreateIndex", "", "index", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "getAllDeclaredSubPackages", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "getPackageFiles", "toString", "", "frontend"})
public final class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FileBasedDeclarationProviderFactory factory;
    @NotNull
    private final Collection<KtFile> packageFiles;
    @NotNull
    private final NotNullLazyValue<Collection<FqName>> allDeclaredSubPackages;

    public FileBasedPackageMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull FqName fqName2, @NotNull FileBasedDeclarationProviderFactory factory2, @NotNull Collection<? extends KtFile> packageFiles) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter(packageFiles, (String)"packageFiles");
        super(storageManager);
        this.fqName = fqName2;
        this.factory = factory2;
        this.packageFiles = packageFiles;
        this.allDeclaredSubPackages = storageManager.createLazyValue((Function0)new Function0<Collection<? extends FqName>>(this){
            final /* synthetic */ FileBasedPackageMemberDeclarationProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Collection<FqName> invoke() {
                Collection<FqName> collection = FileBasedPackageMemberDeclarationProvider.access$getFactory$p(this.this$0).getAllDeclaredSubPackagesOf(FileBasedPackageMemberDeclarationProvider.access$getFqName$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue(collection, (String)"factory.getAllDeclaredSubPackagesOf(fqName)");
                return collection;
            }
        });
    }

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index2) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        for (KtFile file2 : this.packageFiles) {
            for (KtDeclaration declaration2 : file2.getDeclarations()) {
                boolean bl = Intrinsics.areEqual((Object)this.fqName, (Object)file2.getPackageFqName());
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Files declaration utils contains file with invalid package";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                index2.putToIndex(declaration2);
            }
        }
    }

    @Override
    @NotNull
    public Collection<FqName> getAllDeclaredSubPackages(@NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        return (Collection)this.allDeclaredSubPackages.invoke();
    }

    @Override
    @NotNull
    public Collection<KtFile> getPackageFiles() {
        return this.packageFiles;
    }

    @Override
    public boolean containsFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.packageFiles.contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        String string2;
        KtFile it;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.packageFiles;
        StringBuilder stringBuilder2 = new StringBuilder().append("Declarations for package ").append(this.fqName).append(" with files ");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string2 = it.getName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = this.packageFiles;
        stringBuilder2 = stringBuilder2.append(collection).append(" with declarations inside ");
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (KtFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getDeclarations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$flatMap$iv = collection;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (KtDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it.getName();
            string2 = string3 == null ? "???" : string3;
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder2.append(collection).toString();
    }

    public static final /* synthetic */ FileBasedDeclarationProviderFactory access$getFactory$p(FileBasedPackageMemberDeclarationProvider $this) {
        return $this.factory;
    }

    public static final /* synthetic */ FqName access$getFqName$p(FileBasedPackageMemberDeclarationProvider $this) {
        return $this.fqName;
    }
}

