/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PublishedApiUsageChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class PublishedApiUsageChecker {
    @NotNull
    public static final PublishedApiUsageChecker INSTANCE = new PublishedApiUsageChecker();

    private PublishedApiUsageChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility) || Intrinsics.areEqual((Object)((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        for (KtAnnotationEntry entry : declaration2.getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor;
            AnnotationDescriptor annotationDescriptor2;
            AnnotationDescriptor annotationDescriptor3 = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor3 == null || !Intrinsics.areEqual((Object)(annotationDescriptor2 = (annotationDescriptor = annotationDescriptor3)).getFqName(), (Object)StandardNames.FqNames.publishedApi)) continue;
            trace.report(Errors.NON_INTERNAL_PUBLISHED_API.on((KtAnnotationEntry)((PsiElement)entry)));
        }
    }
}

