/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrAbstractFunctionFactory;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KParameterProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeParameterProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KParameterState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeParameterState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\r\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010$\u001a\u00020%J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020+H\u0016R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "functionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)V", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "functionFactory", "Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;)V", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "_parameters", "", "Lkotlin/reflect/KParameter;", "_returnType", "Lkotlin/reflect/KType;", "_typeParameters", "Lkotlin/reflect/KTypeParameter;", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getFields", "()Ljava/util/List;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "upValues", "getUpValues", "getArity", "", "()Ljava/lang/Integer;", "getParameters", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "getReturnType", "getTypeParameters", "isLambda", "", "toString", "", "ir.interpreter"})
public final class KFunctionState
extends ReflectionState
implements StateWithClosure {
    @NotNull
    private final IrFunction irFunction;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final List<Variable> upValues;
    @NotNull
    private final List<Variable> fields;
    @Nullable
    private List<? extends KParameter> _parameters;
    @Nullable
    private KType _returnType;
    @Nullable
    private List<? extends KTypeParameter> _typeParameters;

    public KFunctionState(@NotNull IrFunction irFunction2, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.irFunction = irFunction2;
        this.irClass = irClass2;
        boolean bl = false;
        this.upValues = new ArrayList();
        bl = false;
        this.fields = new ArrayList();
    }

    @NotNull
    public final IrFunction getIrFunction() {
        return this.irFunction;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public List<Variable> getUpValues() {
        return this.upValues;
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    public KFunctionState(@NotNull IrFunctionReference functionReference2) {
        Intrinsics.checkNotNullParameter((Object)functionReference2, (String)"functionReference");
        IrFunction irFunction2 = ((IrFunctionSymbol)functionReference2.getSymbol()).getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(functionReference2.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this(irFunction2, (IrClass)irClassSymbol.getOwner());
    }

    public KFunctionState(@NotNull IrFunction irFunction2, @NotNull IrAbstractFunctionFactory functionFactory) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)functionFactory, (String)"functionFactory");
        this(irFunction2, functionFactory.kFunctionN(irFunction2.getValueParameters().size()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KParameter> getParameters(@NotNull CallInterceptor callInterceptor) {
        Collection<KParameterProxy> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KParameterProxy kParameterProxy;
        boolean bl;
        Object object;
        KParameterProxy kParameterProxy2;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._parameters != null) {
            List<KParameter> list2 = this._parameters;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        IrClass kParameterIrClass = this.getIrClassOfReflectionFromList(this.getIrClass(), "parameters");
        int index2 = 0;
        Object[] objectArray = this.irFunction.getDispatchReceiverParameter();
        if (objectArray == null) {
            kParameterProxy2 = null;
        } else {
            object = objectArray;
            boolean bl2 = false;
            bl = false;
            Object[] it = object;
            boolean bl3 = false;
            int n = index2;
            index2 = n + 1;
            KParameterProxy kParameterProxy3 = new KParameterProxy(new KParameterState(kParameterIrClass, (IrValueParameter)it, n, KParameter.Kind.INSTANCE), callInterceptor);
            kParameterProxy2 = kParameterProxy3;
        }
        KParameterProxy instanceParameter = kParameterProxy2;
        object = this.irFunction.getExtensionReceiverParameter();
        if (object == null) {
            kParameterProxy = null;
        } else {
            Object[] objectArray2 = object;
            bl = false;
            boolean it = false;
            Object[] it2 = objectArray2;
            boolean bl4 = false;
            int n = index2;
            index2 = n + 1;
            KParameterProxy kParameterProxy4 = new KParameterProxy(new KParameterState(kParameterIrClass, (IrValueParameter)it2, n, KParameter.Kind.EXTENSION_RECEIVER), callInterceptor);
            kParameterProxy = kParameterProxy4;
        }
        KParameterProxy extensionParameter = kParameterProxy;
        object = new KParameterProxy[]{instanceParameter, extensionParameter};
        Collection collection2 = CollectionsKt.listOfNotNull((Object[])object);
        object = this.irFunction.getValueParameters();
        Collection collection3 = collection2;
        KFunctionState kFunctionState = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            int n = index2;
            index2 = n + 1;
            KParameterProxy kParameterProxy5 = new KParameterProxy(new KParameterState(kParameterIrClass, (IrValueParameter)it, n, null, 8, null), callInterceptor);
            collection.add(kParameterProxy5);
        }
        collection = (List)destination$iv$iv;
        kFunctionState._parameters = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
        List<KParameter> list3 = this._parameters;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    @NotNull
    public final KType getReturnType(@NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._returnType != null) {
            KType kType = this._returnType;
            Intrinsics.checkNotNull((Object)kType);
            return kType;
        }
        IrClass kTypeIrClass = this.getIrClassOfReflection(this.getIrClass(), "returnType");
        KType kType = this._returnType = (KType)new KTypeProxy(new KTypeState(this.irFunction.getReturnType(), kTypeIrClass), callInterceptor);
        Intrinsics.checkNotNull((Object)kType);
        return kType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KTypeParameter> getTypeParameters(@NotNull CallInterceptor callInterceptor) {
        Collection<KTypeParameterProxy> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._typeParameters != null) {
            List<KTypeParameter> list2 = this._typeParameters;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        IrClass kTypeParametersIrClass = this.getIrClassOfReflectionFromList(this.getIrClass(), "typeParameters");
        Iterable iterable = this.getIrClass().getTypeParameters();
        KFunctionState kFunctionState = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KTypeParameterProxy kTypeParameterProxy = new KTypeParameterProxy(new KTypeParameterState((IrTypeParameter)it, kTypeParametersIrClass), callInterceptor);
            collection.add(kTypeParameterProxy);
        }
        collection = (List)destination$iv$iv;
        kFunctionState._typeParameters = collection;
        List<KTypeParameter> list3 = this._typeParameters;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    @Nullable
    public final Integer getArity() {
        String string2 = this.getIrClass().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irClass.name.asString()");
        return StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string2, (CharSequence)"Suspend"), (CharSequence)"Function"), (CharSequence)"KFunction"));
    }

    private final boolean isLambda() {
        Name name = this.irFunction.getName();
        boolean bl = false;
        boolean bl2 = false;
        Name it = name;
        boolean bl3 = false;
        return Intrinsics.areEqual((Object)it, (Object)Name.special("<anonymous>")) || Intrinsics.areEqual((Object)it, (Object)Name.special("<no name provided>"));
    }

    @NotNull
    public String toString() {
        return this.isLambda() ? this.renderLambda(this.irFunction) : this.renderFunction(this.irFunction);
    }
}

