/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/ArrayOf;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "canHandleFunctionWithName", "", "fqName", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "ir.interpreter"})
public final class ArrayOf
extends IntrinsicBase {
    @NotNull
    public static final ArrayOf INSTANCE = new ArrayOf();

    private ArrayOf() {
        super(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHandleFunctionWithName(@NotNull String fqName2, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.arrayOf")) return true;
        CharSequence charSequence = fqName2;
        String string2 = "kotlin\\.(byte|char|short|int|long|float|double|boolean|)ArrayOf";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        if (!string2.matches(charSequence)) return false;
        return true;
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrValueParameterSymbol elementsSymbol = ((IrValueParameter)CollectionsKt.single(irFunction2.getValueParameters())).getSymbol();
        State varargVariable = environment.getCallStack().getState(elementsSymbol);
        environment.getCallStack().pushState(varargVariable);
    }
}

