/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.ImplementationStatus;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNotImplementedOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isFromInterfaceOrEnum", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkers"})
public final class FirNotImplementedOverrideChecker
extends FirDeclarationChecker<FirClass<?>> {
    @NotNull
    public static final FirNotImplementedOverrideChecker INSTANCE = new FirNotImplementedOverrideChecker();

    private FirNotImplementedOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object invisible;
        Object notImplemented;
        Object $this$baseForIntersectionOverride$iv$iv$iv$iv;
        Iterator iterator2;
        ClassKind classKind;
        boolean canHaveAbstractDeclarations;
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSourceElement firSourceElement = declaration2.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        FirSourceElementKind sourceKind = source.getKind();
        if (sourceKind instanceof FirFakeSourceElementKind && !Intrinsics.areEqual((Object)sourceKind, (Object)FirFakeSourceElementKind.EnumInitializer.INSTANCE)) {
            return;
        }
        Modality modality = FirHelpersKt.modality(declaration2);
        boolean bl = canHaveAbstractDeclarations = modality == Modality.ABSTRACT || modality == Modality.SEALED;
        if (declaration2 instanceof FirRegularClass) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)((Object)declaration2);
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
        }
        if ((classKind = declaration2.getClassKind()) == ClassKind.ANNOTATION_CLASS || classKind == ClassKind.ENUM_CLASS) {
            return;
        }
        FirTypeScope classScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        boolean bl2 = false;
        List notImplementedSymbols = new ArrayList();
        boolean bl3 = false;
        List notImplementedIntersectionSymbols = new ArrayList();
        boolean bl4 = false;
        List invisibleSymbols = new ArrayList();
        for (Name name : classScope.getCallableNames()) {
            classScope.processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirCallableSymbol<?>, Unit>(context2, declaration2, notImplementedIntersectionSymbols, notImplementedSymbols, invisibleSymbols){
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ FirClass<?> $declaration;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedIntersectionSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $invisibleSymbols;
                {
                    this.$context = $context;
                    this.$declaration = $declaration;
                    this.$notImplementedIntersectionSymbols = $notImplementedIntersectionSymbols;
                    this.$notImplementedSymbols = $notImplementedSymbols;
                    this.$invisibleSymbols = $invisibleSymbols;
                    super(1);
                }

                public final void invoke(@NotNull FirCallableSymbol<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    FirNotImplementedOverrideChecker.access$check$collectSymbol(this.$context, this.$declaration, this.$notImplementedIntersectionSymbols, this.$notImplementedSymbols, this.$invisibleSymbols, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "check$collectSymbol(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V";
                }

                @NotNull
                public final String getName() {
                    return "collectSymbol";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
                }
            });
            classScope.processPropertiesByName(name, (Function1)new Function1<FirCallableSymbol<?>, Unit>(context2, declaration2, notImplementedIntersectionSymbols, notImplementedSymbols, invisibleSymbols){
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ FirClass<?> $declaration;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedIntersectionSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $invisibleSymbols;
                {
                    this.$context = $context;
                    this.$declaration = $declaration;
                    this.$notImplementedIntersectionSymbols = $notImplementedIntersectionSymbols;
                    this.$notImplementedSymbols = $notImplementedSymbols;
                    this.$invisibleSymbols = $invisibleSymbols;
                    super(1);
                }

                public final void invoke(@NotNull FirCallableSymbol<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    FirNotImplementedOverrideChecker.access$check$collectSymbol(this.$context, this.$declaration, this.$notImplementedIntersectionSymbols, this.$notImplementedSymbols, this.$invisibleSymbols, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "check$collectSymbol(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V";
                }

                @NotNull
                public final String getName() {
                    return "collectSymbol";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
                }
            });
        }
        if (!canHaveAbstractDeclarations) {
            Collection collection = notImplementedSymbols;
            boolean name = false;
            if (!collection.isEmpty()) {
                FirCallableSymbol $this$unwrapFakeOverrides$iv = (FirCallableSymbol)CollectionsKt.first((List)notImplementedSymbols);
                boolean $i$f$unwrapFakeOverrides = false;
                FirCallableDeclaration $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
                boolean $i$f$unwrapFakeOverrides2 = false;
                FirCallableDeclaration current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
                while (true) {
                    FirCallableDeclaration next$iv$iv;
                    FirCallableDeclaration firCallableDeclaration;
                    Object object;
                    FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
                    boolean $i$f$originalIfFakeOverride = false;
                    FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getOriginalForSubstitutionOverride = false;
                    Iterator iterator3 = iterator2 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                    if (iterator2 == null) {
                        $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        boolean $i$f$getBaseForIntersectionOverride = false;
                        object = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                    } else {
                        object = firCallableDeclaration = iterator2;
                    }
                    if (firCallableDeclaration == null) break;
                    current$iv$iv = next$iv$iv = firCallableDeclaration;
                }
                FirCallableSymbol firCallableSymbol = current$iv$iv.getSymbol();
                if (firCallableSymbol == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                }
                notImplemented = (FirCallableDeclaration)firCallableSymbol.getFir();
                if (this.isFromInterfaceOrEnum((FirCallableDeclaration<?>)notImplemented, context2)) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getABSTRACT_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplemented, context2, null, 32, null);
                } else {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplemented, context2, null, 32, null);
                }
            }
        }
        if (!canHaveAbstractDeclarations) {
            notImplemented = invisibleSymbols;
            boolean $this$unwrapFakeOverrides$iv = false;
            if (!notImplemented.isEmpty()) {
                invisible = (FirCallableDeclaration)((FirCallableSymbol)CollectionsKt.first((List)invisibleSymbols)).getFir();
                if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitInvisibleAbstractMethodsInSuperclasses)) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getINVISIBLE_ABSTRACT_MEMBER_FROM_SUPER(), declaration2, invisible, context2, null, 32, null);
                } else {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getINVISIBLE_ABSTRACT_MEMBER_FROM_SUPER_WARNING(), declaration2, invisible, context2, null, 32, null);
                }
            }
        }
        invisible = notImplementedIntersectionSymbols;
        boolean $this$unwrapFakeOverrides$iv = false;
        if (!invisible.isEmpty()) {
            boolean overridingFinalByDelegationReported = false;
            boolean manyMemberNotImplementedReported = false;
            boolean delegatedHidesSupertypeReported = false;
            for (FirCallableSymbol notImplementedIntersectionSymbol : notImplementedIntersectionSymbols) {
                boolean bl5;
                FirCallableDeclaration notImplementedIntersection;
                block34: {
                    Object v4;
                    FirCallableSymbol<Object> it;
                    Object object;
                    Collection<FirCallableSymbol<?>> intersections;
                    block31: {
                        notImplementedIntersection = (FirCallableDeclaration)notImplementedIntersectionSymbol.getFir();
                        intersections = ((FirIntersectionCallableSymbol)((Object)notImplementedIntersectionSymbol)).getIntersections();
                        $this$baseForIntersectionOverride$iv$iv$iv$iv = intersections;
                        boolean $i$f$getBaseForIntersectionOverride = false;
                        iterator2 = $this$baseForIntersectionOverride$iv$iv$iv$iv;
                        boolean bl6 = false;
                        Iterator next$iv$iv = iterator2.iterator();
                        while (next$iv$iv.hasNext()) {
                            object = next$iv$iv.next();
                            it = (FirCallableSymbol)object;
                            boolean bl7 = false;
                            FirCallableMemberDeclaration fir = (FirCallableMemberDeclaration)it.getFir();
                            if (!Intrinsics.areEqual((Object)fir.getOrigin(), (Object)FirDeclarationOrigin.Delegated.INSTANCE)) continue;
                            v4 = object;
                            break block31;
                        }
                        v4 = null;
                    }
                    FirCallableSymbol delegatedIntersected = v4;
                    if (delegatedIntersected != null) {
                        Object v6;
                        block33: {
                            FirCallableSymbol<Object> firCallableSymbol;
                            block32: {
                                Iterable $i$f$getBaseForIntersectionOverride = intersections;
                                boolean bl8 = false;
                                Iterable iterable = $i$f$getBaseForIntersectionOverride;
                                boolean next$iv$iv = false;
                                object = iterable.iterator();
                                while (object.hasNext()) {
                                    FirCallableSymbol<Object> it2 = it = object.next();
                                    boolean bl9 = false;
                                    FirMemberDeclaration $this$modality$iv = (FirCallableMemberDeclaration)it2.getFir();
                                    boolean $i$f$getModality = false;
                                    if (!($this$modality$iv.getStatus().getModality() == Modality.FINAL)) continue;
                                    firCallableSymbol = it;
                                    break block32;
                                }
                                firCallableSymbol = null;
                            }
                            FirCallableSymbol finalIntersected = firCallableSymbol;
                            if (finalIntersected != null) {
                                if (overridingFinalByDelegationReported) continue;
                                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER_BY_DELEGATION(), delegatedIntersected.getFir(), finalIntersected.getFir(), context2, null, 32, null);
                                overridingFinalByDelegationReported = true;
                                continue;
                            }
                            Iterable $this$firstOrNull$iv = intersections;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (FirCallableSymbol)element$iv;
                                boolean bl10 = false;
                                if (!(!Intrinsics.areEqual((Object)((FirCallableMemberDeclaration)it.getFir()).getOrigin(), (Object)FirDeclarationOrigin.Delegated.INSTANCE))) continue;
                                v6 = element$iv;
                                break block33;
                            }
                            v6 = null;
                        }
                        FirCallableSymbol notDelegatedIntersected = v6;
                        if (notDelegatedIntersected != null) {
                            if (delegatedHidesSupertypeReported) continue;
                            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getDELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE(), delegatedIntersected.getFir(), notDelegatedIntersected.getFir(), context2, null, 32, null);
                            delegatedHidesSupertypeReported = true;
                            continue;
                        }
                    }
                    if (manyMemberNotImplementedReported) continue;
                    Iterable $this$any$iv = intersections;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirClassLikeSymbol<?> firClassLikeSymbol;
                            FirCallableSymbol it3 = (FirCallableSymbol)element$iv;
                            boolean bl11 = false;
                            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(it3);
                            FirClassLikeDeclaration firClassLikeDeclaration = coneClassLikeLookupTag == null ? null : ((firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession())) == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir());
                            FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
                            if (!((firRegularClass == null ? null : firRegularClass.getClassKind()) == ClassKind.CLASS)) continue;
                            bl5 = true;
                            break block34;
                        }
                        bl5 = false;
                    }
                }
                if (bl5) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getMANY_IMPL_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplementedIntersection, context2, null, 32, null);
                } else {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getMANY_INTERFACES_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplementedIntersection, context2, null, 32, null);
                }
                manyMemberNotImplementedReported = true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFromInterfaceOrEnum(FirCallableDeclaration<?> $this$isFromInterfaceOrEnum, CheckerContext context2) {
        FirRegularClass firRegularClass = FirHelpersKt.getContainingClass((FirSymbolOwner)$this$isFromInterfaceOrEnum, context2);
        if (!(firRegularClass instanceof FirRegularClass)) return false;
        FirRegularClass firRegularClass2 = firRegularClass;
        FirRegularClass firRegularClass3 = firRegularClass2;
        if (firRegularClass3 == null) {
            return false;
        }
        firRegularClass = firRegularClass3;
        boolean bl = false;
        boolean bl2 = false;
        FirRegularClass it = firRegularClass;
        boolean bl3 = false;
        FirClass $this$isInterface$iv = it;
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv.getClassKind() == ClassKind.INTERFACE) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        FirClass $this$isEnumClass$iv = it;
        boolean $i$f$isEnumClass = false;
        if ($this$isEnumClass$iv.getClassKind() != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    private static final void check$collectSymbol(CheckerContext $context, FirClass<?> $declaration, List<FirCallableSymbol<?>> notImplementedIntersectionSymbols, List<FirCallableSymbol<?>> notImplementedSymbols, List<FirCallableSymbol<?>> invisibleSymbols, FirCallableSymbol<?> symbol2) {
        Object object;
        Object e = symbol2.getFir();
        Object object2 = object = e instanceof FirCallableMemberDeclaration ? (FirCallableMemberDeclaration)e : null;
        if (object == null) {
            return;
        }
        FirCallableMemberDeclaration fir = object;
        object = FirHelpersKt.getImplementationStatus(fir, $context.getSessionHolder(), $declaration);
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                notImplementedIntersectionSymbols.add(symbol2);
                break;
            }
            case 2: {
                if (FirHelpersKt.isVisibleInClass(fir, $declaration)) {
                    notImplementedSymbols.add(symbol2);
                    break;
                }
                invisibleSymbols.add(symbol2);
            }
        }
    }

    public static final /* synthetic */ void access$check$collectSymbol(CheckerContext $context, FirClass $declaration, List notImplementedIntersectionSymbols, List notImplementedSymbols, List invisibleSymbols, FirCallableSymbol symbol2) {
        FirNotImplementedOverrideChecker.check$collectSymbol($context, $declaration, notImplementedIntersectionSymbols, notImplementedSymbols, invisibleSymbols, symbol2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImplementationStatus.values().length];
            nArray[ImplementationStatus.AMBIGUOUSLY_INHERITED.ordinal()] = 1;
            nArray[ImplementationStatus.NOT_IMPLEMENTED.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

