/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CfgUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.LocalFunctionDeclarationNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PostponedLambdaEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PostponedLambdaExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/LocalPropertyAndCapturedWriteCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "()V", "capturedWrites", "", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "lambdaOrLocalFunctionStack", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "symbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "", "visitFunctionExitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionExitNode;", "visitLocalFunctionDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/LocalFunctionDeclarationNode;", "data", "", "visitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitPostponedLambdaEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PostponedLambdaEnterNode;", "visitPostponedLambdaExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PostponedLambdaExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "Companion", "checkers"})
public final class LocalPropertyAndCapturedWriteCollector
extends ControlFlowGraphVisitorVoid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FirPropertySymbol, Boolean> symbols;
    @NotNull
    private final List<FirFunction<?>> lambdaOrLocalFunctionStack;
    @NotNull
    private final Set<FirVariableAssignment> capturedWrites;

    private LocalPropertyAndCapturedWriteCollector() {
        boolean bl = false;
        this.symbols = new LinkedHashMap();
        bl = false;
        this.lambdaOrLocalFunctionStack = new ArrayList();
        bl = false;
        this.capturedWrites = new LinkedHashSet();
    }

    @Override
    public void visitNode(@NotNull CFGNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
    }

    @Override
    public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Map<FirPropertySymbol, Boolean> map = this.symbols;
        FirPropertySymbol firPropertySymbol = node.getFir().getSymbol();
        Boolean bl = CollectionsKt.lastOrNull(this.lambdaOrLocalFunctionStack) == null;
        boolean bl2 = false;
        map.put(firPropertySymbol, bl);
    }

    @Override
    public void visitPostponedLambdaEnterNode(@NotNull PostponedLambdaEnterNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.lambdaOrLocalFunctionStack.add(node.getFir());
    }

    @Override
    public void visitPostponedLambdaExitNode(@NotNull PostponedLambdaExitNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.lambdaOrLocalFunctionStack.remove(node.getFir());
    }

    public void visitLocalFunctionDeclarationNode(@NotNull LocalFunctionDeclarationNode node, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.lambdaOrLocalFunctionStack.add((FirFunction<?>)node.getFir());
    }

    @Override
    public void visitFunctionExitNode(@NotNull FunctionExitNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.lambdaOrLocalFunctionStack.remove(node.getFir());
    }

    @Override
    public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.lambdaOrLocalFunctionStack.isEmpty()) {
                return;
            }
            Object object = FirDeclarationUtilKt.getReferredPropertySymbol(node.getFir());
            if (object == null) {
                return;
            }
            FirPropertySymbol symbol2 = object;
            object = this.symbols;
            boolean bl2 = false;
            Iterator iterator2 = object;
            boolean bl3 = false;
            if (!iterator2.containsKey(symbol2) || Intrinsics.areEqual((Object)this.symbols.get(symbol2), (Object)false)) {
                return;
            }
            Iterable $this$all$iv = this.lambdaOrLocalFunctionStack;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirFunction it = (FirFunction)element$iv;
                    boolean bl4 = false;
                    if (it instanceof FirAnonymousFunction && CfgUtilsKt.isInPlace(((FirAnonymousFunction)it).getInvocationKind())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.capturedWrites.add(node.getFir());
    }

    public /* synthetic */ LocalPropertyAndCapturedWriteCollector(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/LocalPropertyAndCapturedWriteCollector$Companion;", "", "()V", "collect", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<Set<FirPropertySymbol>, Set<FirVariableAssignment>> collect(@NotNull ControlFlowGraph graph2) {
            Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
            LocalPropertyAndCapturedWriteCollector collector2 = new LocalPropertyAndCapturedWriteCollector(null);
            CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, collector2);
            return TuplesKt.to(collector2.symbols.keySet(), (Object)collector2.capturedWrites);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

