/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.Lazy;
import javaslang.collection.Collections;
import javaslang.collection.Iterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.Queue;
import javaslang.collection.StreamModule;

public interface Stream<T>
extends LinearSeq<T> {
    public static final long serialVersionUID = 1L;

    public static <T> Stream<T> cons(T head, Supplier<? extends Stream<? extends T>> tailSupplier) {
        Objects.requireNonNull(tailSupplier, "tailSupplier is null");
        return new StreamModule.ConsImpl<T>(head, tailSupplier);
    }

    public static <T> Stream<T> empty() {
        return Empty.instance();
    }

    public static <T> Stream<T> of(T element) {
        return Stream.cons(element, Empty::instance);
    }

    @SafeVarargs
    public static <T> Stream<T> of(final T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < elements.length;
            }

            @Override
            public T next() {
                return elements[this.i++];
            }
        });
    }

    public static <T> Stream<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Stream) {
            return (Stream)elements;
        }
        return StreamModule.StreamFactory.create(elements.iterator());
    }

    default public Stream<T> append(T element) {
        return this.isEmpty() ? Stream.of(element) : new StreamModule.AppendElements(this.head(), Queue.of(element), () -> this.tail());
    }

    default public Stream<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(this.isEmpty() ? elements : Iterator.concat(this, elements));
    }

    @Override
    default public T get(int index2) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ") on Nil");
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        LinearSeq<T> stream = this;
        for (int i = index2 - 1; i >= 0; --i) {
            if (!(stream = stream.tail()).isEmpty()) continue;
            throw new IndexOutOfBoundsException(String.format("get(%s) on Stream of size %s", index2, index2 - i));
        }
        return stream.head();
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public int length() {
        return this.foldLeft(0, (n, ignored) -> n + 1);
    }

    @Override
    default public <U> Stream<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return Stream.cons(mapper.apply(this.head()), () -> this.tail().map(mapper));
    }

    default public Stream<T> prepend(T element) {
        return Stream.cons(element, () -> this);
    }

    default public Stream<T> prependAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(elements).appendAll(this);
    }

    default public Stream<T> reverse() {
        return this.isEmpty() ? this : this.foldLeft(Stream.empty(), Stream::prepend);
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    default public String stringPrefix() {
        return "Stream";
    }

    @Override
    public Stream<T> tail();

    public static abstract class Cons<T>
    implements Stream<T> {
        private static final long serialVersionUID = 1L;
        final T head;
        final Lazy<Stream<T>> tail;

        Cons(T head, Supplier<Stream<T>> tail) {
            Objects.requireNonNull(tail, "tail is null");
            this.head = head;
            this.tail = Lazy.of(tail);
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new StreamModule.StreamIterator(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Stream) {
                LinearSeq<T> stream1 = this;
                LinearSeq stream2 = (Stream)o;
                while (!stream1.isEmpty() && !stream2.isEmpty()) {
                    boolean isEqual = Objects.equals(stream1.head(), stream2.head());
                    if (!isEqual) {
                        return false;
                    }
                    stream1 = stream1.tail();
                    stream2 = stream2.tail();
                }
                return stream1.isEmpty() && stream2.isEmpty();
            }
            return false;
        }

        public int hashCode() {
            return Collections.hash(this);
        }

        @Override
        public String toString() {
            StringBuilder builder2 = new StringBuilder(this.stringPrefix()).append("(");
            LinearSeq<T> stream = this;
            while (stream != null && !stream.isEmpty()) {
                Cons cons = stream;
                builder2.append(cons.head);
                if (cons.tail.isEvaluated()) {
                    if ((stream = stream.tail()).isEmpty()) continue;
                    builder2.append(", ");
                    continue;
                }
                builder2.append(", ?");
                stream = null;
            }
            return builder2.append(")").toString();
        }
    }

    public static final class Empty<T>
    implements Serializable,
    Stream<T> {
        private static final long serialVersionUID = 1L;
        private static final Empty<?> INSTANCE = new Empty();

        private Empty() {
        }

        public static <T> Empty<T> instance() {
            return INSTANCE;
        }

        @Override
        public T head() {
            throw new NoSuchElementException("head of empty stream");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterator.empty();
        }

        @Override
        public Stream<T> tail() {
            throw new UnsupportedOperationException("tail of empty stream");
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }
    }
}

