/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.AbstractDiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.jandex.Jandex;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexClassFileServices;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexFileSystemBeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexIndexBeanArchiveHandler;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.collections.ImmutableSet;

public class JandexDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final int ANNOTATION = 8192;
    private Set<DotName> beanDefiningAnnotations;
    private CompositeIndex cindex;
    private JandexClassFileServices classFileServices;

    public JandexDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        super(resourceLoader, bootstrap, initialBeanDefiningAnnotations);
        this.registerHandler(new JandexIndexBeanArchiveHandler());
        this.registerHandler(new JandexFileSystemBeanArchiveHandler());
    }

    @Override
    public ClassFileServices getClassFileServices() {
        return this.classFileServices;
    }

    @Override
    protected void beforeDiscovery(Collection<BeanArchiveBuilder> builders) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (BeanArchiveBuilder builder : builders) {
            IndexView index = (IndexView)builder.getAttribute(Jandex.INDEX_ATTRIBUTE_NAME);
            if (index == null) continue;
            indexes.add(index);
        }
        this.cindex = CompositeIndex.create(indexes);
        this.beanDefiningAnnotations = this.buildBeanDefiningAnnotationSet(this.initialBeanDefiningAnnotations, this.cindex);
        this.classFileServices = new JandexClassFileServices(this);
    }

    @Override
    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        Iterator<String> classIterator = builder.getClassIterator();
        while (classIterator.hasNext()) {
            String className = classIterator.next();
            ClassInfo cinfo = this.cindex.getClassByName(DotName.createSimple((String)className));
            if (cinfo != null) {
                if (this.containsBeanDefiningAnnotation(cinfo, className)) continue;
                classIterator.remove();
                continue;
            }
            Class clazz = Reflections.loadClass(this.resourceLoader, className);
            if (clazz != null && Reflections.hasBeanDefiningAnnotation(clazz, this.initialBeanDefiningAnnotations)) continue;
            classIterator.remove();
        }
        return builder.build();
    }

    private Set<DotName> buildBeanDefiningAnnotationSet(Set<Class<? extends Annotation>> initialBeanDefiningAnnotations, CompositeIndex index) {
        ImmutableSet.Builder<DotName> beanDefiningAnnotations = ImmutableSet.builder();
        for (Class<? extends Annotation> annotation : initialBeanDefiningAnnotations) {
            DotName annotationDotName = DotName.createSimple((String)annotation.getName());
            if (this.isMetaAnnotation(annotation)) {
                for (AnnotationInstance instance : index.getAnnotations(annotationDotName)) {
                    ClassInfo classInfo;
                    if (!(instance.target() instanceof ClassInfo) || ((classInfo = (ClassInfo)instance.target()).flags() & 0x2000) == 0) continue;
                    beanDefiningAnnotations.add(classInfo.name());
                }
                continue;
            }
            beanDefiningAnnotations.add(annotationDotName);
        }
        return beanDefiningAnnotations.build();
    }

    private boolean isMetaAnnotation(Class<? extends Annotation> annotation) {
        Target target = annotation.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        if (target.value() == null) {
            return false;
        }
        for (ElementType elementType : target.value()) {
            if (!ElementType.ANNOTATION_TYPE.equals((Object)elementType)) continue;
            return true;
        }
        return false;
    }

    private boolean containsBeanDefiningAnnotation(ClassInfo cinfo, String className) {
        for (Map.Entry<DotName, List<AnnotationInstance>> entry : cinfo.annotations().entrySet()) {
            Class clazz;
            if (this.beanDefiningAnnotations.contains(entry.getKey())) {
                return true;
            }
            if (!this.isDeclaredOnBeanClass(entry, cinfo) || this.cindex.getClassByName(entry.getKey()) != null || (clazz = Reflections.loadClass(this.resourceLoader, className)) == null) continue;
            for (Class<? extends Annotation> metaAnnotation : Reflections.META_ANNOTATIONS) {
                if (!Reflections.hasBeanDefiningMetaAnnotationSpecified(clazz.getAnnotations(), metaAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    public CompositeIndex getCompositeJandexIndex() {
        return this.cindex;
    }

    private boolean isDeclaredOnBeanClass(Map.Entry<DotName, List<AnnotationInstance>> entry, ClassInfo cinfo) {
        for (AnnotationInstance annotationInstance : entry.getValue()) {
            if (!annotationInstance.target().equals(cinfo)) continue;
            return true;
        }
        return false;
    }
}

