/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.retro;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.jboss.weaver.Main;

public abstract class AbstractWeaveMojo
extends AbstractMojo {
    public static final String JBOSS_RETRO_ARTIFACTID = "jboss-retro";
    protected final String fileSep = File.separator;
    protected final String pathSep = File.pathSeparator;
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected List pluginArtifacts;
    protected boolean verbose = false;
    protected boolean useSystemClasspath = false;
    protected boolean suppress = false;
    protected String weaverClass = "org.jboss.weaver.Weaver";
    protected String classifier;
    protected boolean fork = true;
    protected String jvm;

    protected abstract String getOutputPath();

    protected String getJarClassifier() {
        return this.classifier;
    }

    public void doWeave(String classpath, String[] args) throws Exception {
        block5: {
            if (this.fork) {
                Commandline cli = new Commandline();
                if (this.jvm == null || this.jvm.equals("")) {
                    this.jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                    this.getLog().debug((CharSequence)("Using JVM: " + this.jvm));
                }
                cli.setExecutable(this.jvm);
                String[] jvmArgs = new String[]{"-cp", classpath, Main.class.getName()};
                cli.addArguments(jvmArgs);
                cli.addArguments(args);
                MojoLogStreamConsumer out = new MojoLogStreamConsumer();
                MojoLogStreamConsumer err = new MojoLogStreamConsumer();
                this.getLog().debug((CharSequence)"Forking Command Line: ");
                this.getLog().debug((CharSequence)cli.toString());
                this.getLog().debug((CharSequence)"");
                try {
                    int returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
                    if (returnCode != 0) {
                        throw new MojoExecutionException("There were errors during the weave");
                    }
                    break block5;
                }
                catch (CommandLineException e) {
                    throw new MojoExecutionException("Error while executing forked tests.", (Exception)((Object)e));
                }
            }
            Main.main((String[])args);
        }
    }

    public class MojoLogStreamConsumer
    implements StreamConsumer {
        public void consumeLine(String line) {
            AbstractWeaveMojo.this.getLog().info((CharSequence)line);
        }
    }
}

