/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Map;
import org.jboss.logging.AbstractLoggerProvider;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logging.Slf4jLocationAwareLogger;
import org.jboss.logging.Slf4jLogger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.LocationAwareLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Slf4jLoggerProvider
extends AbstractLoggerProvider
implements LoggerProvider {
    Slf4jLoggerProvider() {
    }

    @Override
    public Logger getLogger(String name, String resourceBundleName, String prefix) {
        org.slf4j.Logger l = LoggerFactory.getLogger((String)name);
        if (l instanceof LocationAwareLogger) {
            return new Slf4jLocationAwareLogger(name, resourceBundleName, prefix, (LocationAwareLogger)l);
        }
        return new Slf4jLogger(name, resourceBundleName, prefix, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putMdc(String key, Object value) {
        try {
            String string = MDC.get((String)key);
            return string;
        }
        finally {
            if (value == null) {
                MDC.remove((String)key);
            } else {
                MDC.put((String)key, (String)String.valueOf(value));
            }
        }
    }

    @Override
    public Object getMdc(String key) {
        return MDC.get((String)key);
    }

    @Override
    public void removeMdc(String key) {
        MDC.remove((String)key);
    }

    @Override
    public Map<String, Object> getMdcMap() {
        return MDC.getCopyOfContextMap();
    }
}

