/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.SubjectSecurityManager;

public class SecurityFlushSessionListener
implements HttpSessionListener {
    private static Logger log = Logger.getLogger(SecurityFlushSessionListener.class);
    private boolean trace = log.isTraceEnabled();
    private String securityDomain = null;

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (this.trace) {
            log.trace((Object)("Session Created with id=" + httpSessionEvent.getSession().getId()));
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.trace) {
            log.trace((Object)("Session Destroy with id=" + httpSessionEvent.getSession().getId()));
        }
        try {
            Principal principal;
            Subject subject = this.getSubjectAndSecurityDomain();
            if (this.trace) {
                log.trace((Object)("securityDomain=" + this.securityDomain));
            }
            if (this.securityDomain == null) {
                log.debug((Object)"Unable to obtain SecurityDomain");
            }
            if ((principal = this.getPrincipal(subject)) != null && this.securityDomain != null) {
                this.flushAuthenticationCache(principal);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception in sessionDestroyed:", (Throwable)e);
        }
    }

    private void flushAuthenticationCache(Principal principal) throws JMException {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ObjectName on = new ObjectName("jboss.security:service=JaasSecurityManager");
        Object[] obj = new Object[]{this.securityDomain, principal};
        String[] sig = new String[]{"java.lang.String", "java.security.Principal"};
        if (this.trace) {
            this.logAuthenticatedPrincipals(on, true);
        }
        server.invoke(on, "flushAuthenticationCache", obj, sig);
        if (this.trace) {
            this.logAuthenticatedPrincipals(on, false);
        }
    }

    private Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal2 = null;
        if (!(subject == null || (principals = subject.getPrincipals()) == null && principals.isEmpty())) {
            for (Principal principal2 : principals) {
                if (!(principal2 instanceof Group)) break;
            }
        }
        if (this.trace) {
            log.trace((Object)("Authenticated Principal=" + principal2));
        }
        return principal2;
    }

    private Subject getSubjectAndSecurityDomain() throws Exception {
        SubjectSecurityManager mgr = null;
        try {
            mgr = this.getSecurityManagerService();
        }
        catch (Exception e) {
            log.debug((Object)"Obtaining SecurityManagerService failed::", (Throwable)e);
        }
        String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        Subject subject = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
        if (this.trace) {
            log.trace((Object)("Jacc Subject = " + subject));
        }
        if (mgr != null) {
            this.securityDomain = mgr.getSecurityDomain();
        }
        if (subject == null && mgr != null) {
            subject = mgr.getActiveSubject();
            if (this.trace) {
                log.trace((Object)("Active Subject from security mgr service = " + subject));
            }
        }
        return subject;
    }

    private SubjectSecurityManager getSecurityManagerService() throws Exception {
        InitialContext ctx = new InitialContext();
        return (SubjectSecurityManager)ctx.lookup("java:comp/env/security/securityMgr");
    }

    private void logAuthenticatedPrincipals(ObjectName on, boolean isBeforeFlush) throws JMException {
        if (isBeforeFlush) {
            log.trace((Object)"Before flush of authentication cache::");
        } else {
            log.trace((Object)"After flush of authentication cache::");
        }
        MBeanServer server = MBeanServerLocator.locateJBoss();
        List list = (List)server.invoke(on, "getAuthenticationCachePrincipals", new Object[]{this.securityDomain}, new String[]{"java.lang.String"});
        int len = list != null ? list.size() : 0;
        log.trace((Object)("Number of authenticated principals remaining in cache=" + len));
        for (int i = 0; i < len; ++i) {
            log.trace((Object)("Authenticated principal in cache=" + list.get(i)));
        }
    }
}

