/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.context;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceAwareObjectFactory;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.as.naming.context.SecurityActions;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.ServiceRegistry;

public class ObjectFactoryBuilder
implements javax.naming.spi.ObjectFactoryBuilder,
ObjectFactory {
    public static final ObjectFactoryBuilder INSTANCE = new ObjectFactoryBuilder();

    private ObjectFactoryBuilder() {
    }

    @Override
    public ObjectFactory createObjectFactory(Object obj, Hashtable<?, ?> environment) throws NamingException {
        try {
            if (obj instanceof Reference) {
                return this.factoryFromReference((Reference)obj, environment);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        if (classLoader == null) {
            return ref;
        }
        String factoriesProp = (String)environment.get("java.naming.factory.object");
        if (factoriesProp != null) {
            String[] classes;
            for (String className : classes = factoriesProp.split(":")) {
                try {
                    Class<?> factoryClass = classLoader.loadClass(className);
                    ObjectFactory objectFactory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
                    Object result = objectFactory.getObjectInstance(ref, name, nameCtx, environment);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
        }
        return ref;
    }

    private ObjectFactory factoryFromReference(Reference reference, Hashtable<?, ?> environment) throws Exception {
        if (reference instanceof ModularReference) {
            return this.factoryFromModularReference((ModularReference)ModularReference.class.cast(reference), environment);
        }
        return this.factoryFromReference(reference, SecurityActions.getContextClassLoader(), environment);
    }

    private ObjectFactory factoryFromModularReference(ModularReference modularReference, Hashtable<?, ?> environment) throws Exception {
        Module module = Module.getCallerModuleLoader().loadModule(modularReference.getModuleIdentifier());
        ModuleClassLoader classLoader = module.getClassLoader();
        return this.factoryFromReference(modularReference, (ClassLoader)classLoader, environment);
    }

    private ObjectFactory factoryFromReference(Reference reference, ClassLoader classLoader, Hashtable<?, ?> environment) throws Exception {
        try {
            Class<?> factoryClass = classLoader.loadClass(reference.getFactoryClassName());
            ObjectFactory factory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
            if (factory instanceof ServiceAwareObjectFactory) {
                ((ServiceAwareObjectFactory)factory).injectServiceRegistry((ServiceRegistry)CurrentServiceContainer.getServiceContainer());
            }
            return factory;
        }
        catch (Throwable t) {
            throw NamingMessages.MESSAGES.objectFactoryCreationFailure(t);
        }
    }
}

