/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hornetq.core.security.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityFormatter {
    public static Set<Role> createSecurity(String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles) {
        List<String> createDurableQueue = SecurityFormatter.toList(createDurableQueueRoles);
        List<String> deleteDurableQueue = SecurityFormatter.toList(deleteDurableQueueRoles);
        List<String> createNonDurableQueue = SecurityFormatter.toList(createNonDurableQueueRoles);
        List<String> deleteNonDurableQueue = SecurityFormatter.toList(deleteNonDurableQueueRoles);
        List<String> send = SecurityFormatter.toList(sendRoles);
        List<String> consume = SecurityFormatter.toList(consumeRoles);
        List<String> manage = SecurityFormatter.toList(manageRoles);
        HashSet<String> allRoles = new HashSet<String>();
        allRoles.addAll(createDurableQueue);
        allRoles.addAll(deleteDurableQueue);
        allRoles.addAll(createNonDurableQueue);
        allRoles.addAll(deleteNonDurableQueue);
        allRoles.addAll(send);
        allRoles.addAll(consume);
        allRoles.addAll(manage);
        HashSet<Role> roles = new HashSet<Role>();
        for (String role : allRoles) {
            roles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role)));
        }
        return roles;
    }

    private static List<String> toList(String commaSeparatedString) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return list;
        }
        String[] values = commaSeparatedString.split(",");
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].trim());
        }
        return list;
    }
}

