/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionExpireMessage
extends PacketImpl {
    private long consumerID;
    private long messageID;

    public SessionExpireMessage(long consumerID, long messageID) {
        super((byte)42);
        this.consumerID = consumerID;
        this.messageID = messageID;
    }

    public SessionExpireMessage() {
        super((byte)42);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.messageID);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.messageID = buffer.readLong();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionExpireMessage)) {
            return false;
        }
        SessionExpireMessage r = (SessionExpireMessage)other;
        return super.equals(other) && this.consumerID == r.consumerID && this.messageID == r.messageID;
    }
}

