/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.annotations.AnnotationProcessor;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.BackGroundRegistration;
import org.apache.juddi.v3.client.config.ClientConfig;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.config.XRegistration;
import org.apache.juddi.v3.client.embed.EmbeddedRegistry;
import org.apache.juddi.v3.client.transport.InVMTransport;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;

public class UDDIClerkManager {
    private static Log log = LogFactory.getLog(UDDIClerkManager.class);
    private ClientConfig clientConfig = null;
    private String CONFIG_FILE = "META-INF/uddi.xml";
    private Properties properties = null;

    public UDDIClerkManager() throws ConfigurationException {
        this.clientConfig = new ClientConfig(this.CONFIG_FILE, this.properties);
    }

    public UDDIClerkManager(String configurationFile) throws ConfigurationException {
        this.clientConfig = new ClientConfig(configurationFile);
    }

    public UDDIClerkManager(String configurationFile, Properties properties) throws ConfigurationException {
        this.clientConfig = new ClientConfig(configurationFile, properties);
    }

    public void stop() throws ConfigurationException {
        log.info((Object)("Stopping UDDI Clerks for manager " + this.clientConfig.getManagerName()));
        this.releaseResources();
        UDDIClientContainer.removeClerkManager(this.getName());
        if (InVMTransport.class.getCanonicalName().equals(this.getClientConfig().getHomeNode().getProxyTransport())) {
            log.info((Object)"Shutting down embedded Server");
            this.stopEmbeddedServer();
        }
        log.info((Object)("UDDI Clerks shutdown completed for manager " + this.clientConfig.getManagerName()));
    }

    private void releaseResources() {
        this.unRegisterBindingsOfAnnotatedServices(true);
    }

    public void start() throws ConfigurationException {
        if (UDDIClientContainer.addClerkManager(this)) {
            if (InVMTransport.class.getCanonicalName().equals(this.getClientConfig().getHomeNode().getProxyTransport())) {
                log.info((Object)"Starting embedded Server");
                this.startEmbeddedServer();
            }
            BackGroundRegistration runnable = new BackGroundRegistration(this);
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    protected void startEmbeddedServer() throws ConfigurationException {
        try {
            String embeddedServerClass = this.getClientConfig().getHomeNode().getProperties().getProperty("embeddedServer", "org.apache.juddi.v3.client.embed.JUDDIRegistry");
            Class<?> clazz = ClassUtil.forName(embeddedServerClass, this.getClass());
            EmbeddedRegistry embeddedRegistry = (EmbeddedRegistry)clazz.newInstance();
            embeddedRegistry.start();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void stopEmbeddedServer() throws ConfigurationException {
        try {
            String embeddedServerClass = this.getClientConfig().getHomeNode().getProperties().getProperty("embeddedServer", "org.apache.juddi.v3.client.embed.JUDDIRegistry");
            Class<?> clazz = ClassUtil.forName(embeddedServerClass, this.getClass());
            EmbeddedRegistry embeddedRegistry = (EmbeddedRegistry)clazz.newInstance();
            embeddedRegistry.stop();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void restart() throws ConfigurationException {
        this.stop();
        this.start();
    }

    public void saveClerkAndNodeInfo() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            UDDIClerk homeClerk = null;
            for (UDDIClerk clerk : uddiClerks.values()) {
                if (!clerk.getUDDINode().isHomeJUDDI()) continue;
                homeClerk = clerk;
            }
            if (homeClerk != null) {
                int numberOfHomeJUDDIs = 0;
                for (UDDINode uddiNode : this.clientConfig.getUDDINodes().values()) {
                    if (uddiNode.isHomeJUDDI()) {
                        ++numberOfHomeJUDDIs;
                    }
                    homeClerk.saveNode(uddiNode.getApiNode());
                }
                if (numberOfHomeJUDDIs == 1) {
                    for (UDDIClerk clerk : this.clientConfig.getUDDIClerks().values()) {
                        homeClerk.saveClerk(clerk);
                    }
                } else {
                    log.error((Object)("The client config needs to have one homeJUDDI node and found " + numberOfHomeJUDDIs));
                }
            } else {
                log.debug((Object)"No home clerk found.");
            }
        }
    }

    public void xRegister() {
        log.debug((Object)"Starting cross registration...");
        Set<XRegistration> xBusinessRegistrations = this.clientConfig.getXBusinessRegistrations();
        for (XRegistration xRegistration : xBusinessRegistrations) {
            xRegistration.xRegisterBusiness();
        }
        Set<XRegistration> xServiceBindingRegistrations = this.clientConfig.getXServiceBindingRegistrations();
        for (XRegistration xRegistration : xServiceBindingRegistrations) {
            xRegistration.xRegisterServiceBinding();
        }
        log.debug((Object)"Cross registration completed");
    }

    public void registerAnnotatedServices() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk uddiClerk : uddiClerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(uddiClerk.getClassWithAnnotations(), uddiClerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    log.info((Object)("Node=" + uddiClerk.getUDDINode().getApiNode().getName()));
                    uddiClerk.register(businessService, uddiClerk.getUDDINode().getApiNode());
                }
            }
        }
    }

    public void unRegisterAnnotatedServices() {
        Map<String, UDDIClerk> clerks = this.clientConfig.getUDDIClerks();
        if (clerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk clerk : clerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(clerk.getClassWithAnnotations(), clerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    clerk.unRegisterService(businessService.getServiceKey(), clerk.getUDDINode().getApiNode());
                }
            }
        }
    }

    public void unRegisterBindingsOfAnnotatedServices(boolean removeServiceWithNoBindingTemplates) {
        Map<String, UDDIClerk> clerks = this.clientConfig.getUDDIClerks();
        if (clerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk clerk : clerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(clerk.getClassWithAnnotations(), clerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    if (businessService.getBindingTemplates() != null) {
                        List bindingTemplates = businessService.getBindingTemplates().getBindingTemplate();
                        for (BindingTemplate bindingTemplate : bindingTemplates) {
                            clerk.unRegisterBinding(bindingTemplate.getBindingKey(), clerk.getUDDINode().getApiNode());
                        }
                    }
                    if (!removeServiceWithNoBindingTemplates) continue;
                    try {
                        BusinessService existingService = clerk.findService(businessService.getServiceKey(), clerk.getUDDINode().getApiNode());
                        if (existingService.getBindingTemplates() != null && existingService.getBindingTemplates().getBindingTemplate().size() != 0) continue;
                        clerk.unRegisterService(businessService.getServiceKey(), clerk.getUDDINode().getApiNode());
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getName() {
        return this.clientConfig.getManagerName();
    }

    public Transport getTransport() throws ConfigurationException {
        return this.getTransport("default");
    }

    public Transport getTransport(String nodeName) throws ConfigurationException {
        try {
            String clazz = this.clientConfig.getHomeNode().getProxyTransport();
            String managerName = this.clientConfig.getManagerName();
            Class<?> transportClass = ClassUtil.forName(clazz, UDDIClerkManager.class);
            if (transportClass != null) {
                Transport transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(managerName, nodeName);
                return transport;
            }
            throw new ConfigurationException("ProxyTransport was not defined in the " + this.clientConfig.getConfigurationFile());
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }
}

