/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface JAXRLogger
extends BasicLogger {
    public static final JAXRLogger ROOT_LOGGER = (JAXRLogger)Logger.getMessageLogger(JAXRLogger.class, (String)JAXRLogger.class.getPackage().getName());
    public static final JAXRLogger JAXR_LOGGER = (JAXRLogger)Logger.getMessageLogger(JAXRLogger.class, (String)"org.jboss.jaxr");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14000, value="Started JAXR subsystem, binding JAXR connection factory into JNDI as: %s")
    public void bindingJAXRConnectionFactory(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14001, value="Cannot bind JAXR ConnectionFactory")
    public void bindingJAXRConnectionFactoryFailed();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14002, value="UnBinding JAXR ConnectionFactory: %s")
    public void unBindingJAXRConnectionFactory(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14003, value="Cannot unbind JAXR ConnectionFactory")
    public void unBindingJAXRConnectionFactoryFailed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=14004, value="Obtained the JAXR factory name from System Property %s, using jaxr implementation %s")
    public void factoryNameFromSystemProperty(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=14005, value="Obtained the JAXR factory name from JBoss configuration %s, using jaxr implementation %s")
    public void factoryNameFromJBossConfig(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=14006, value="Obtained the JAXR factory name from the ServiceLoader API reading file META-INF/services/javax.xml.registry.ConnectionFactory, using jaxr implementation %s")
    public void factoryNameFromServiceLoader(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=14007, value="Using default JAXR factory implementation %s")
    public void factoryNameFromDefault(String var1);
}

