/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.map;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.Relationship;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.jboss.ws.api.addressing.MAPRelatesTo;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.addressing.map.NativeMAPBuilder;
import org.jboss.ws.extensions.addressing.map.NativeMAPEndpoint;
import org.w3c.dom.Element;

public class NativeMAP
implements MAP {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NativeMAP.class);
    private AddressingProperties implementation;

    NativeMAP(AddressingProperties implementation) {
        this.implementation = implementation;
    }

    public String getTo() {
        AttributedURI to = this.implementation.getTo();
        return to != null ? to.getURI().toString() : null;
    }

    public MAPEndpoint getFrom() {
        EndpointReference from = this.implementation.getFrom();
        return from != null ? new NativeMAPEndpoint(from) : null;
    }

    public String getMessageID() {
        AttributedURI messageId = this.implementation.getMessageID();
        return messageId != null ? messageId.getURI().toString() : null;
    }

    public String getAction() {
        AttributedURI action = this.implementation.getAction();
        return action != null ? action.getURI().toString() : null;
    }

    public MAPEndpoint getFaultTo() {
        EndpointReference faultTo = this.implementation.getFaultTo();
        return faultTo != null ? new NativeMAPEndpoint(faultTo) : null;
    }

    public MAPEndpoint getReplyTo() {
        EndpointReference replyTo = this.implementation.getReplyTo();
        return replyTo != null ? new NativeMAPEndpoint(replyTo) : null;
    }

    public MAPRelatesTo getRelatesTo() {
        MAPBuilder builder = NativeMAPBuilder.getBuilder();
        Relationship[] relationship = this.implementation.getRelatesTo();
        if (relationship != null) {
            Relationship relatesTo = relationship[0];
            return builder.newRelatesTo(relatesTo.getID().toString(), relatesTo.getType());
        }
        return null;
    }

    public void setTo(String address) {
        if (address != null) {
            try {
                AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
                AttributedURI uri = builder.newURI(address);
                this.implementation.setTo(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.implementation.setTo(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFrom(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof NativeMAPEndpoint)) throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
            this.implementation.setFrom(((NativeMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setFrom(null);
        }
    }

    public void setMessageID(String messageID) {
        if (messageID != null) {
            try {
                AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
                AttributedURI uri = builder.newURI(messageID);
                this.implementation.setMessageID(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.implementation.setMessageID(null);
        }
    }

    public void setAction(String action) {
        if (action != null) {
            try {
                AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
                AttributedURI uri = builder.newURI(action);
                this.implementation.setAction(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.implementation.setAction(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setReplyTo(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof NativeMAPEndpoint)) throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
            this.implementation.setReplyTo(((NativeMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setReplyTo(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFaultTo(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof NativeMAPEndpoint)) throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
            this.implementation.setFaultTo(((NativeMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setFaultTo(null);
        }
    }

    public void setRelatesTo(MAPRelatesTo relatesTo) {
        if (relatesTo != null) {
            try {
                AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
                Relationship[] relationships = new Relationship[1];
                String relatesToId = relatesTo.getRelatesTo();
                URI uri = new URI(relatesToId);
                Relationship relationship = builder.newRelationship(uri);
                relationship.setType(relatesTo.getType());
                relationships[0] = relationship;
                this.implementation.setRelatesTo(relationships);
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.implementation.setRelatesTo(null);
        }
    }

    public void addReferenceParameter(Element refParam) {
        this.implementation.getReferenceParameters().addElement(refParam);
    }

    public List<Object> getReferenceParameters() {
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.implementation.getReferenceParameters() != null) {
            list.addAll(this.implementation.getReferenceParameters().getElements());
        }
        return list;
    }

    public void initializeAsDestination(MAPEndpoint epref) {
        if (!(epref instanceof NativeMAPEndpoint)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
        }
        this.implementation.initializeAsDestination(((NativeMAPEndpoint)epref).getImplementation());
    }

    public void installOutboundMapOnClientSide(Map<String, Object> requestContext, MAP map) {
        if (!(map instanceof NativeMAP)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAP", (Object[])new Object[]{map}));
        }
        AddressingProperties addressingProperties = ((NativeMAP)map).implementation;
        requestContext.put("javax.xml.ws.addressing.context", addressingProperties);
        requestContext.put("javax.xml.ws.addressing.context.outbound", addressingProperties);
    }

    public void installOutboundMapOnServerSide(Map<String, Object> requestContext, MAP map) {
        if (!(map instanceof NativeMAP)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAP", (Object[])new Object[]{map}));
        }
        AddressingProperties addressingProperties = ((NativeMAP)map).implementation;
        requestContext.put("javax.xml.ws.addressing.context.outbound", addressingProperties);
    }
}

