/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.UUIDGenerator;

public class CIDGenerator {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CIDGenerator.class);
    private static Logger log = Logger.getLogger(CIDGenerator.class);
    private int count = 0;

    public String generateFromCount() {
        StringBuilder cid = new StringBuilder();
        long time = System.currentTimeMillis();
        cid.append(this.count++).append("-").append(time).append("-").append(cid.hashCode()).append("@").append("ws.jboss.org");
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateFromCount: " + cid));
        }
        return cid.toString();
    }

    public String generateFromName(String name) {
        try {
            name = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_ENCODE_NAME", (Object[])new Object[]{ex}));
        }
        String cid = name + "-" + UUIDGenerator.generateRandomUUIDString() + "@" + "ws.jboss.org";
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateFromName: " + cid));
        }
        return cid;
    }
}

