/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class CommonXml
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<ModelMarshallingContext> {
    protected static final Set<String> RESTRICTED_PATHS;
    private static final char[] NEW_LINE;

    protected CommonXml() {
    }

    protected void parseNamespaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null || prefix.length() <= 0) continue;
            nodes.add(NamespaceAddHandler.getAddNamespaceOperation(address, prefix, reader.getNamespaceURI(i)));
        }
    }

    protected void readHeadComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void readTailComment(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) throws XMLStreamException {
    }

    protected void parseSchemaLocations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updateList, int idx) throws XMLStreamException {
        List elements = reader.getListAttributeValue(idx);
        ArrayList<String> values = new ArrayList<String>();
        for (String element : elements) {
            if (element.trim().isEmpty()) continue;
            values.add(element);
        }
        if ((values.size() & 1) != 0) {
            throw ParseUtils.invalidAttributeValue(reader, idx);
        }
        Iterator it = values.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)it.next();
            if (key.length() <= 0 || val.length() <= 0) continue;
            updateList.add(SchemaLocationAddHandler.getAddSchemaLocationOperation(address, key, val));
        }
    }

    protected void writeSchemaLocation(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (!modelNode.hasDefined("schema-locations")) {
            return;
        }
        StringBuilder b = new StringBuilder();
        Iterator iterator = modelNode.get("schema-locations").asList().iterator();
        while (iterator.hasNext()) {
            ModelNode location = (ModelNode)iterator.next();
            Property property = location.asProperty();
            b.append(property.getName()).append(' ').append(property.getValue().asString());
            if (!iterator.hasNext()) continue;
            b.append(' ');
        }
        if (b.length() > 0) {
            writer.writeAttribute(Namespace.XML_SCHEMA_INSTANCE.getUriString(), Attribute.SCHEMA_LOCATION.getLocalName(), b.toString());
        }
    }

    protected void writeNamespaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        boolean needXsd = modelNode.hasDefined("schema-locations") && modelNode.get("schema-locations").asInt() > 0;
        boolean hasNamespaces = modelNode.hasDefined("namespaces");
        if (!needXsd && !hasNamespaces) {
            return;
        }
        boolean wroteXsd = false;
        String xsdUri = Namespace.XML_SCHEMA_INSTANCE.getUriString();
        if (hasNamespaces) {
            for (Property property : modelNode.get("namespaces").asPropertyList()) {
                String uri = property.getValue().asString();
                writer.writeNamespace(property.getName(), uri);
                if (wroteXsd || !xsdUri.equals(uri)) continue;
                wroteXsd = true;
            }
        }
        if (needXsd && !wroteXsd) {
            writer.writeNamespace("xsd", xsdUri);
        }
    }

    protected static void writeElement(XMLExtendedStreamWriter writer, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
    }

    protected void writePaths(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List paths = node.asPropertyList();
        if (paths.size() > 0) {
            writer.writeStartElement(Element.PATHS.getLocalName());
            for (Property path : paths) {
                ModelNode value = path.getValue();
                writer.writeEmptyElement(Element.PATH.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), path.getName());
                writer.writeAttribute(Attribute.PATH.getLocalName(), value.get("path").asString());
                if (!value.has("relative-to") || !value.get("relative-to").isDefined()) continue;
                writer.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), value.get("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    protected void parseFSBaseType(XMLExtendedStreamReader reader, ModelNode parent, boolean isArchive) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        content.get("archive").set(isArchive);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case PATH: {
                    content.get("path").set(value);
                    continue block4;
                }
                case RELATIVE_TO: {
                    content.get("relative-to").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parsePaths(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean requirePath) throws XMLStreamException {
        HashSet<String> pathNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            ParseUtils.requireNamespace(reader, expectedNs);
            switch (element) {
                case PATH: {
                    this.parsePath(reader, address, list, requirePath, pathNames);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    protected void parsePath(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requirePath, Set<String> defined) throws XMLStreamException {
        String name = null;
        String path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    if (RESTRICTED_PATHS.contains(value)) {
                        throw ControllerMessages.MESSAGES.reserved(name, reader.getLocation());
                    }
                    if (defined.add(name)) continue block5;
                    throw ControllerMessages.MESSAGES.alreadyDefined(name, reader.getLocation());
                }
                case PATH: {
                    path = value;
                    continue block5;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (requirePath && path == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent(reader);
        ModelNode update = new ModelNode();
        update.get("address").set(address).add("path", name);
        update.get("operation").set("add");
        update.get("name").set(name);
        if (path != null) {
            update.get("path").set(path);
        }
        if (relativeTo != null) {
            update.get("relative-to").set(relativeTo);
        }
        list.add(update);
    }

    protected void parseSystemProperties(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> updates, boolean standalone) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String name = null;
            String value = null;
            Boolean boottime = null;
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                String val = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (name != null) {
                            throw ParseUtils.duplicateAttribute(reader, "name");
                        }
                        name = val;
                        continue block6;
                    }
                    case VALUE: {
                        if (value != null) {
                            throw ParseUtils.duplicateAttribute(reader, "value");
                        }
                        value = val;
                        continue block6;
                    }
                    case BOOT_TIME: {
                        if (standalone) {
                            throw ParseUtils.unexpectedAttribute(reader, i);
                        }
                        boottime = Boolean.valueOf(val);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            ParseUtils.requireNoContent(reader);
            ModelNode propAddr = new ModelNode().set(address).add("system-property", name);
            ModelNode op = Util.getEmptyOperation("add", propAddr);
            op.get("value").set(value);
            if (boottime != null) {
                op.get("boot-time").set(boottime.booleanValue());
            }
            updates.add(op);
        }
    }

    public static ModelNode parseProperties(XMLExtendedStreamReader reader, Namespace expectedNs) throws XMLStreamException {
        ModelNode properties = new ModelNode();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String[] array = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
            ParseUtils.requireNoContent(reader);
            properties.get(array[0]).set(array[1]);
        }
        return properties;
    }

    protected void parseInterfaceCriteria(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode interfaceModel) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return;
        }
        ParseUtils.requireNamespace(reader, expectedNs);
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ANY_ADDRESS: 
            case ANY_IPV4_ADDRESS: 
            case ANY_IPV6_ADDRESS: {
                interfaceModel.get(element.getLocalName()).set(true);
                ParseUtils.requireNoContent(reader);
                ParseUtils.requireNoContent(reader);
                return;
            }
        }
        do {
            ParseUtils.requireNamespace(reader, expectedNs);
            element = Element.forName(reader.getLocalName());
            switch (element) {
                case ANY: {
                    this.parseCompoundInterfaceCriterion(reader, expectedNs, interfaceModel.get("any").setEmptyObject());
                    break;
                }
                case NOT: {
                    this.parseCompoundInterfaceCriterion(reader, expectedNs, interfaceModel.get("not").setEmptyObject());
                    break;
                }
                default: {
                    this.parseSimpleInterfaceCriterion(reader, interfaceModel, false);
                }
            }
        } while (reader.nextTag() != 2);
    }

    protected void parseCompoundInterfaceCriterion(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode subModel) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            this.parseSimpleInterfaceCriterion(reader, subModel, true);
        }
    }

    protected void parseContentType(XMLExtendedStreamReader reader, ModelNode parent) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case SHA1: {
                    try {
                        content.get("hash").set(HashUtil.hexStringToByteArray(value));
                        continue block5;
                    }
                    catch (Exception e) {
                        throw ControllerMessages.MESSAGES.invalidSha1Value(e, value, attribute.getLocalName(), reader.getLocation());
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseSimpleInterfaceCriterion(XMLExtendedStreamReader reader, ModelNode subModel, boolean nested) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        String localName = element.getLocalName();
        switch (element) {
            case INET_ADDRESS: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ModelNode valueNode = ParseUtils.parsePossibleExpression(value);
                ParseUtils.requireNoContent(reader);
                if (nested) {
                    subModel.get(localName).add(valueNode);
                    break;
                }
                subModel.get(localName).set(valueNode);
                break;
            }
            case LOOPBACK_ADDRESS: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ModelNode valueNode = ParseUtils.parsePossibleExpression(value);
                ParseUtils.requireNoContent(reader);
                subModel.get(localName).set(valueNode);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                ParseUtils.requireNoAttributes(reader);
                ParseUtils.requireNoContent(reader);
                subModel.get(localName).set(true);
                break;
            }
            case NIC: {
                ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            case NIC_MATCH: {
                ParseUtils.requireSingleAttribute(reader, Attribute.PATTERN.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            case SUBNET_MATCH: {
                ParseUtils.requireSingleAttribute(reader, Attribute.VALUE.getLocalName());
                String value = reader.getAttributeValue(0);
                ParseUtils.requireNoContent(reader);
                this.validateAddressMask(value, reader.getLocation());
                if (nested) {
                    subModel.get(localName).add(value);
                    break;
                }
                subModel.get(localName).set(value);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void validateAddressMask(String value, Location location) throws XMLStreamException {
        String[] split = value.split("/");
        try {
            if (split.length != 2) {
                throw new XMLStreamException(ControllerMessages.MESSAGES.invalidAddressMaskValue(value), location);
            }
            InetAddress addr = InetAddress.getByName(split[0]);
            addr.getAddress();
            Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            throw new XMLStreamException(ControllerMessages.MESSAGES.invalidAddressMask(split[1], e.getLocalizedMessage()), location, e);
        }
        catch (UnknownHostException e) {
            throw new XMLStreamException(ControllerMessages.MESSAGES.invalidAddressValue(split[0], e.getLocalizedMessage()), location, e);
        }
    }

    protected void parseInterfaces(XMLExtendedStreamReader reader, Set<String> names, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean checkSpecified) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            Element element = Element.forName(reader.getLocalName());
            if (Element.INTERFACE != element) {
                throw ParseUtils.unexpectedElement(reader);
            }
            ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw ControllerMessages.MESSAGES.duplicateInterfaceDeclaration(reader.getLocation());
            }
            ModelNode interfaceAdd = new ModelNode();
            interfaceAdd.get("address").set(address).add("interface", name);
            interfaceAdd.get("operation").set("add");
            ModelNode criteriaNode = interfaceAdd;
            this.parseInterfaceCriteria(reader, expectedNs, interfaceAdd);
            if (checkSpecified && criteriaNode.getType() != ModelType.STRING && criteriaNode.getType() != ModelType.EXPRESSION && criteriaNode.asInt() == 0) {
                throw ParseUtils.unexpectedEndElement(reader);
            }
            list.add(interfaceAdd);
        }
    }

    protected void parseSocketBindingGroupRef(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = null;
        int offset = -1;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REF: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    name = value;
                    continue block6;
                }
                case PORT_OFFSET: {
                    try {
                        if (offset != -1) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        offset = Integer.parseInt(value);
                        if (offset >= 0) continue block6;
                        throw ControllerMessages.MESSAGES.invalidValueGreaterThan(attribute.getLocalName(), offset, 0, reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw ControllerMessages.MESSAGES.invalid(e, offset, attribute.getLocalName(), reader.getLocation());
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.REF));
        }
        ParseUtils.requireNoContent(reader);
        ModelNode update = Util.getWriteAttributeOperation(address, "socket-binding-group", name);
        updates.add(update);
        if (offset < 0) {
            offset = 0;
        }
        if (offset > 0) {
            update = Util.getWriteAttributeOperation(address, "socket-binding-port-offset", offset);
        }
        updates.add(update);
    }

    protected String parseSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PORT);
        String name = null;
        ModelNode binding = new ModelNode();
        binding.get("address");
        binding.get("operation").set("add");
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    binding.get("address").set(address).add("socket-binding", name);
                    continue block13;
                }
                case INTERFACE: {
                    if (!interfaces.contains(value)) {
                        throw ControllerMessages.MESSAGES.unknownInterface(value, attribute.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    binding.get("interface").set(value);
                    continue block13;
                }
                case PORT: {
                    binding.get("port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 0, 65535, true));
                    continue block13;
                }
                case FIXED_PORT: {
                    binding.get("fixed-port").set(Boolean.parseBoolean(value));
                    continue block13;
                }
                case MULTICAST_ADDRESS: {
                    ModelNode mcastNode = ParseUtils.parsePossibleExpression(value);
                    if (mcastNode.getType() == ModelType.EXPRESSION) {
                        binding.get("multicast-address").set(mcastNode);
                        continue block13;
                    }
                    try {
                        InetAddress mcastAddr = InetAddress.getByName(value);
                        if (!mcastAddr.isMulticastAddress()) {
                            throw ControllerMessages.MESSAGES.invalidMulticastAddress(value, attribute.getLocalName(), reader.getLocation());
                        }
                        binding.get("multicast-address").set(value);
                        continue block13;
                    }
                    catch (UnknownHostException e) {
                        throw ControllerMessages.MESSAGES.invalidMulticastAddress(e, value, attribute.getLocalName(), reader.getLocation());
                    }
                }
                case MULTICAST_PORT: {
                    binding.get("multicast-port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 1, 65535, true));
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLIENT_MAPPING: {
                    binding.get("client-mappings").add(this.parseClientMapping(reader));
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        updates.add(binding);
        return name;
    }

    private ModelNode parseClientMapping(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode mapping = new ModelNode();
        ModelNode sourceNetwork = mapping.get("source-network");
        ModelNode destination = mapping.get("destination-address");
        ModelNode destinationPort = mapping.get("destination-port");
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOURCE_NETWORK: {
                    this.validateAddressMask(value, reader.getLocation());
                    sourceNetwork.set(value);
                    continue block5;
                }
                case DESTINATION_ADDRESS: {
                    if (value == null || value.isEmpty()) {
                        throw ParseUtils.invalidAttributeValue(reader, i);
                    }
                    destination.set(value);
                    continue block5;
                }
                case DESTINATION_PORT: {
                    destinationPort.set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 0, 65535, true));
                }
            }
        }
        if (!destination.isDefined()) {
            throw ControllerMessages.MESSAGES.missingRequiredAttributes(new StringBuilder("destination-address"), reader.getLocation());
        }
        ParseUtils.requireNoContent(reader);
        return mapping;
    }

    protected String parseOutboundSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, String socketBindingGroupName, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String outboundSocketBindingName = null;
        ModelNode outboundSocketBindingAddOperation = new ModelNode();
        outboundSocketBindingAddOperation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    outboundSocketBindingName = value;
                    continue block10;
                }
                case SOURCE_INTERFACE: {
                    if (!interfaces.contains(value)) {
                        throw ControllerMessages.MESSAGES.unknownValueForElement(Attribute.SOURCE_INTERFACE.getLocalName(), value, Element.INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    outboundSocketBindingAddOperation.get("source-interface").set(value);
                    continue block10;
                }
                case SOURCE_PORT: {
                    outboundSocketBindingAddOperation.get("source-port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 0, 65535, true));
                    continue block10;
                }
                case FIXED_SOURCE_PORT: {
                    outboundSocketBindingAddOperation.get("fixed-source-port").set(ParseUtils.parsePossibleExpression(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        boolean mutuallyExclusiveElementAlreadyFound = false;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case LOCAL_DESTINATION: {
                    if (mutuallyExclusiveElementAlreadyFound) {
                        throw ControllerMessages.MESSAGES.invalidOutboundSocketBinding(outboundSocketBindingName, Element.LOCAL_DESTINATION.getLocalName(), Element.REMOTE_DESTINATION.getLocalName(), reader.getLocation());
                    }
                    mutuallyExclusiveElementAlreadyFound = true;
                    this.parseLocalDestinationOutboundSocketBinding(reader, outboundSocketBindingName, outboundSocketBindingAddOperation);
                    ModelNode addr = address.clone().add("local-destination-outbound-socket-binding", outboundSocketBindingName);
                    outboundSocketBindingAddOperation.get("address").set(addr);
                    continue block11;
                }
                case REMOTE_DESTINATION: {
                    if (mutuallyExclusiveElementAlreadyFound) {
                        throw ControllerMessages.MESSAGES.invalidOutboundSocketBinding(outboundSocketBindingName, Element.LOCAL_DESTINATION.getLocalName(), Element.REMOTE_DESTINATION.getLocalName(), reader.getLocation());
                    }
                    mutuallyExclusiveElementAlreadyFound = true;
                    this.parseRemoteDestinationOutboundSocketBinding(reader, outboundSocketBindingName, outboundSocketBindingAddOperation);
                    ModelNode addr = address.clone().add("remote-destination-outbound-socket-binding", outboundSocketBindingName);
                    outboundSocketBindingAddOperation.get("address").set(addr);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        updates.add(outboundSocketBindingAddOperation);
        return outboundSocketBindingName;
    }

    private void parseLocalDestinationOutboundSocketBinding(XMLExtendedStreamReader reader, String outboundSocketBindingName, ModelNode outboundSocketBindingAddOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case SOCKET_BINDING_REF: {
                    outboundSocketBindingAddOperation.get("socket-binding-ref").set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseRemoteDestinationOutboundSocketBinding(XMLExtendedStreamReader reader, String outboundSocketBindingName, ModelNode outboundSocketBindingAddOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.HOST, Attribute.PORT);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case HOST: {
                    outboundSocketBindingAddOperation.get("host").set(value);
                    continue block4;
                }
                case PORT: {
                    outboundSocketBindingAddOperation.get("port").set(ParseUtils.parseBoundedIntegerAttribute(reader, i, 0, 65535, true));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseDeployments(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean allowEnabled) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            Element deployment = Element.forName(reader.getLocalName());
            if (Element.DEPLOYMENT != deployment) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String uniqueName = null;
            String runtimeName = null;
            String startInput = null;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement(reader, value);
                        }
                        uniqueName = value;
                        continue block11;
                    }
                    case RUNTIME_NAME: {
                        runtimeName = value;
                        continue block11;
                    }
                    case ENABLED: {
                        if (allowEnabled) {
                            startInput = value;
                            continue block11;
                        }
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (uniqueName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
            }
            if (runtimeName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.RUNTIME_NAME));
            }
            boolean enabled = startInput == null ? true : Boolean.parseBoolean(startInput);
            ModelNode deploymentAddress = address.clone().add("deployment", uniqueName);
            ModelNode deploymentAdd = Util.getEmptyOperation("add", deploymentAddress);
            block12: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace(reader, expectedNs);
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case CONTENT: {
                        this.parseContentType(reader, deploymentAdd);
                        continue block12;
                    }
                    case FS_ARCHIVE: {
                        this.parseFSBaseType(reader, deploymentAdd, true);
                        continue block12;
                    }
                    case FS_EXPLODED: {
                        this.parseFSBaseType(reader, deploymentAdd, false);
                        continue block12;
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
            deploymentAdd.get("runtime-name").set(runtimeName);
            if (allowEnabled) {
                deploymentAdd.get("enabled").set(enabled);
            }
            list.add(deploymentAdd);
        }
    }

    protected void parseVault(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        int vaultAttribCount = reader.getAttributeCount();
        ModelNode vault = new ModelNode();
        String code = null;
        if (vaultAttribCount > 1) {
            throw ParseUtils.unexpectedAttribute(reader, vaultAttribCount);
        }
        block6: for (int i = 0; i < vaultAttribCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    code = value;
                    vault.get(Attribute.CODE.getLocalName()).set(code);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ModelNode vaultAddress = address.clone();
        vaultAddress.add("core-service", "vault");
        if (code != null) {
            vault.get(Attribute.CODE.getLocalName()).set(code);
        }
        vault.get("address").set(vaultAddress);
        vault.get("operation").set("add");
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case VAULT_OPTION: {
                    this.parseModuleOption(reader, vault.get("vault-options"));
                }
            }
        }
        list.add(vault);
    }

    protected void parseModuleOption(XMLExtendedStreamReader reader, ModelNode moduleOptions) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired(reader, required);
        }
        moduleOptions.add(name, val);
        ParseUtils.requireNoContent(reader);
    }

    protected void writeInterfaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        writer.writeStartElement(Element.INTERFACES.getLocalName());
        Set interfaces = modelNode.keys();
        for (String ifaceName : interfaces) {
            ModelNode iface = modelNode.get(ifaceName);
            writer.writeStartElement(Element.INTERFACE.getLocalName());
            CommonXml.writeAttribute(writer, Attribute.NAME, ifaceName);
            if (iface.get(Element.ANY_ADDRESS.getLocalName()).asBoolean(false)) {
                writer.writeEmptyElement(Element.ANY_ADDRESS.getLocalName());
            } else if (iface.get(Element.ANY_IPV4_ADDRESS.getLocalName()).asBoolean(false)) {
                writer.writeEmptyElement(Element.ANY_IPV4_ADDRESS.getLocalName());
            } else if (iface.get(Element.ANY_IPV6_ADDRESS.getLocalName()).asBoolean(false)) {
                writer.writeEmptyElement(Element.ANY_IPV6_ADDRESS.getLocalName());
            } else {
                this.writeInterfaceCriteria(writer, iface, false);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, ModelNode subModel, boolean nested) throws XMLStreamException {
        for (Property property : subModel.asPropertyList()) {
            if (!property.getValue().isDefined()) continue;
            this.writeInterfaceCriteria(writer, property, nested);
        }
    }

    private void writeInterfaceCriteria(XMLExtendedStreamWriter writer, Property property, boolean nested) throws XMLStreamException {
        Element element = Element.forName(property.getName());
        switch (element) {
            case INET_ADDRESS: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), nested);
                break;
            }
            case LOOPBACK_ADDRESS: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), false);
                break;
            }
            case LINK_LOCAL_ADDRESS: 
            case LOOPBACK: 
            case MULTICAST: 
            case POINT_TO_POINT: 
            case PUBLIC_ADDRESS: 
            case SITE_LOCAL_ADDRESS: 
            case UP: 
            case VIRTUAL: {
                if (!property.getValue().asBoolean(false)) break;
                writer.writeEmptyElement(element.getLocalName());
                break;
            }
            case NIC: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.NAME, property.getValue(), nested);
                break;
            }
            case NIC_MATCH: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.PATTERN, property.getValue(), nested);
                break;
            }
            case SUBNET_MATCH: {
                CommonXml.writeInterfaceCriteria(writer, element, Attribute.VALUE, property.getValue(), nested);
                break;
            }
            case ANY: 
            case NOT: {
                if (nested) break;
                writer.writeStartElement(element.getLocalName());
                this.writeInterfaceCriteria(writer, property.getValue(), true);
                writer.writeEndElement();
                break;
            }
            case NAME: {
                break;
            }
            default: {
                throw ControllerMessages.MESSAGES.unknownCriteriaInterfaceProperty(property.getName());
            }
        }
    }

    private static void writeInterfaceCriteria(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel, boolean asList) throws XMLStreamException {
        if (asList) {
            CommonXml.writeListAsMultipleElements(writer, element, attribute, subModel);
        } else {
            CommonXml.writeSingleElement(writer, element, attribute, subModel);
        }
    }

    private static void writeSingleElement(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel) throws XMLStreamException {
        writer.writeEmptyElement(element.getLocalName());
        CommonXml.writeAttribute(writer, attribute, subModel.asString());
    }

    private static void writeListAsMultipleElements(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel) throws XMLStreamException {
        List list = subModel.asList();
        for (ModelNode node : list) {
            writer.writeEmptyElement(element.getLocalName());
            CommonXml.writeAttribute(writer, attribute, node.asString());
        }
    }

    protected void writeSocketBindingGroup(XMLExtendedStreamWriter writer, ModelNode bindingGroup, boolean fromServer) throws XMLStreamException {
        String fixedSourcePort;
        String sourceInterface;
        String sourcePort;
        ModelNode outboundSocketBinding;
        writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
        SocketBindingGroupResourceDefinition.NAME.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        if (fromServer) {
            SocketBindingGroupResourceDefinition.PORT_OFFSET.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        }
        if (!fromServer) {
            SocketBindingGroupResourceDefinition.INCLUDES.marshallAsElement(bindingGroup, (XMLStreamWriter)writer);
        }
        if (bindingGroup.hasDefined("socket-binding")) {
            ModelNode bindings = bindingGroup.get("socket-binding");
            for (String bindingName : bindings.keys()) {
                ModelNode binding = bindings.get(bindingName);
                writer.writeStartElement(Element.SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, bindingName);
                ModelNode attr = binding.get("interface");
                if (attr.isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.INTERFACE, attr.asString());
                }
                attr = binding.get("port");
                CommonXml.writeAttribute(writer, Attribute.PORT, attr.asString());
                attr = binding.get("fixed-port");
                if (attr.isDefined() && attr.asBoolean()) {
                    CommonXml.writeAttribute(writer, Attribute.FIXED_PORT, attr.asString());
                }
                if ((attr = binding.get("multicast-address")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.MULTICAST_ADDRESS, attr.asString());
                }
                if ((attr = binding.get("multicast-port")).isDefined()) {
                    CommonXml.writeAttribute(writer, Attribute.MULTICAST_PORT, attr.asString());
                }
                if ((attr = binding.get("client-mappings")).isDefined()) {
                    for (ModelNode mapping : attr.asList()) {
                        writer.writeEmptyElement(Element.CLIENT_MAPPING.getLocalName());
                        attr = mapping.get("source-network");
                        if (attr.isDefined()) {
                            CommonXml.writeAttribute(writer, Attribute.SOURCE_NETWORK, attr.asString());
                        }
                        if ((attr = mapping.get("destination-address")).isDefined()) {
                            CommonXml.writeAttribute(writer, Attribute.DESTINATION_ADDRESS, attr.asString());
                        }
                        if (!(attr = mapping.get("destination-port")).isDefined()) continue;
                        CommonXml.writeAttribute(writer, Attribute.DESTINATION_PORT, attr.asString());
                    }
                }
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("local-destination-outbound-socket-binding")) {
            ModelNode localDestinationOutboundSocketBindings = bindingGroup.get("local-destination-outbound-socket-binding");
            for (String outboundSocketBindingName : localDestinationOutboundSocketBindings.keys()) {
                outboundSocketBinding = localDestinationOutboundSocketBindings.get(outboundSocketBindingName);
                writer.writeStartElement(Element.OUTBOUND_SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, outboundSocketBindingName);
                if (outboundSocketBinding.hasDefined("source-port")) {
                    sourcePort = outboundSocketBinding.get("source-port").asString();
                    CommonXml.writeAttribute(writer, Attribute.SOURCE_PORT, sourcePort);
                }
                if (outboundSocketBinding.hasDefined("source-interface")) {
                    sourceInterface = outboundSocketBinding.get("source-interface").asString();
                    CommonXml.writeAttribute(writer, Attribute.SOURCE_INTERFACE, sourceInterface);
                }
                if (outboundSocketBinding.hasDefined("fixed-source-port")) {
                    fixedSourcePort = outboundSocketBinding.get("fixed-source-port").asString();
                    CommonXml.writeAttribute(writer, Attribute.FIXED_SOURCE_PORT, fixedSourcePort);
                }
                writer.writeStartElement(Element.LOCAL_DESTINATION.getLocalName());
                ModelNode socketBindingRef = outboundSocketBinding.get("socket-binding-ref");
                CommonXml.writeAttribute(writer, Attribute.SOCKET_BINDING_REF, socketBindingRef.asString());
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("remote-destination-outbound-socket-binding")) {
            ModelNode remoteDestinationOutboundSocketBindings = bindingGroup.get("remote-destination-outbound-socket-binding");
            for (String outboundSocketBindingName : remoteDestinationOutboundSocketBindings.keys()) {
                outboundSocketBinding = remoteDestinationOutboundSocketBindings.get(outboundSocketBindingName);
                writer.writeStartElement(Element.OUTBOUND_SOCKET_BINDING.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, outboundSocketBindingName);
                if (outboundSocketBinding.hasDefined("source-port")) {
                    sourcePort = outboundSocketBinding.get("source-port").asString();
                    CommonXml.writeAttribute(writer, Attribute.SOURCE_PORT, sourcePort);
                }
                if (outboundSocketBinding.hasDefined("source-interface")) {
                    sourceInterface = outboundSocketBinding.get("source-interface").asString();
                    CommonXml.writeAttribute(writer, Attribute.SOURCE_INTERFACE, sourceInterface);
                }
                if (outboundSocketBinding.hasDefined("fixed-source-port")) {
                    fixedSourcePort = outboundSocketBinding.get("fixed-source-port").asString();
                    CommonXml.writeAttribute(writer, Attribute.FIXED_SOURCE_PORT, fixedSourcePort);
                }
                writer.writeStartElement(Element.REMOTE_DESTINATION.getLocalName());
                ModelNode host = outboundSocketBinding.get("host");
                CommonXml.writeAttribute(writer, Attribute.HOST, host.asString());
                ModelNode destPort = outboundSocketBinding.get("port");
                CommonXml.writeAttribute(writer, Attribute.PORT, destPort.asString());
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    protected void writeProperties(XMLExtendedStreamWriter writer, ModelNode modelNode, Element element, boolean standalone) throws XMLStreamException {
        List properties = modelNode.asPropertyList();
        if (properties.size() > 0) {
            writer.writeStartElement(element.getLocalName());
            for (Property prop : properties) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                CommonXml.writeAttribute(writer, Attribute.NAME, prop.getName());
                ModelNode sysProp = prop.getValue();
                if (sysProp.hasDefined("value")) {
                    CommonXml.writeAttribute(writer, Attribute.VALUE, sysProp.get("value").asString());
                }
                if (!standalone && sysProp.hasDefined("boot-time") && !sysProp.get("boot-time").asBoolean()) {
                    CommonXml.writeAttribute(writer, Attribute.BOOT_TIME, "false");
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    protected static void writeContentItem(XMLExtendedStreamWriter writer, ModelNode contentItem) throws XMLStreamException {
        if (contentItem.has("hash")) {
            CommonXml.writeElement(writer, Element.CONTENT);
            CommonXml.writeAttribute(writer, Attribute.SHA1, HashUtil.bytesToHexString(contentItem.require("hash").asBytes()));
            writer.writeEndElement();
        } else {
            if (contentItem.require("archive").asBoolean()) {
                CommonXml.writeElement(writer, Element.FS_ARCHIVE);
            } else {
                CommonXml.writeElement(writer, Element.FS_EXPLODED);
            }
            CommonXml.writeAttribute(writer, Attribute.PATH, contentItem.require("path").asString());
            if (contentItem.has("relative-to")) {
                CommonXml.writeAttribute(writer, Attribute.RELATIVE_TO, contentItem.require("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }

    protected void writeVault(XMLExtendedStreamWriter writer, ModelNode vault) throws XMLStreamException {
        String code;
        writer.writeStartElement(Element.VAULT.getLocalName());
        String string = code = vault.hasDefined(Attribute.CODE.getLocalName()) ? vault.get(Attribute.CODE.getLocalName()).asString() : null;
        if (code != null && !code.isEmpty()) {
            writer.writeAttribute(Attribute.CODE.getLocalName(), code);
        }
        if (vault.hasDefined("vault-options")) {
            ModelNode properties = vault.get("vault-options");
            for (Property prop : properties.asPropertyList()) {
                writer.writeEmptyElement(Element.VAULT_OPTION.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
            }
        }
        writer.writeEndElement();
    }

    protected static void writeNewLine(XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(NEW_LINE, 0, 1);
    }

    static {
        HashSet<String> set = new HashSet<String>(10);
        set.add("jboss.home");
        set.add("jboss.home.dir");
        set.add("user.home");
        set.add("user.dir");
        set.add("java.home");
        set.add("jboss.server.base.dir");
        set.add("jboss.server.data.dir");
        set.add("jboss.server.log.dir");
        set.add("jboss.server.temp.dir");
        set.add("jboss.modules.dir");
        set.add("jboss.server.deploy.dir");
        set.add("jboss.domain.servers.dir");
        RESTRICTED_PATHS = Collections.unmodifiableSet(set);
        NEW_LINE = new char[]{'\n'};
    }
}

