/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module.descriptor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.deployment.module.descriptor.ModuleStructureSpec;
import org.jboss.as.server.deployment.module.descriptor.ParseResult;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class JBossDeploymentStructureParser11
implements XMLElementReader<ParseResult> {
    public static final String NAMESPACE_1_1 = "urn:jboss:deployment-structure:1.1";
    public static final JBossDeploymentStructureParser11 INSTANCE = new JBossDeploymentStructureParser11();

    private JBossDeploymentStructureParser11() {
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult result) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw JBossDeploymentStructureParser11.unexpectedContent((XMLStreamReader)reader);
        }
        boolean deploymentVisited = false;
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EAR_SUBDEPLOYMENTS_ISOLATED: {
                            String value = reader.getElementText();
                            if (value == null || value.isEmpty()) {
                                result.setEarSubDeploymentsIsolated(true);
                                continue block10;
                            }
                            result.setEarSubDeploymentsIsolated(Boolean.valueOf(value));
                            continue block10;
                        }
                        case DEPLOYMENT: {
                            if (deploymentVisited) {
                                throw JBossDeploymentStructureParser11.unexpectedContent((XMLStreamReader)reader);
                            }
                            deploymentVisited = true;
                            JBossDeploymentStructureParser11.parseDeployment((XMLStreamReader)reader, result);
                            continue block10;
                        }
                        case SUB_DEPLOYMENT: {
                            JBossDeploymentStructureParser11.parseSubDeployment((XMLStreamReader)reader, result);
                            continue block10;
                        }
                        case MODULE: {
                            JBossDeploymentStructureParser11.parseModule((XMLStreamReader)reader, result);
                            continue block10;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent((XMLStreamReader)reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseDeployment(XMLStreamReader reader, ParseResult result) throws XMLStreamException {
        result.setRootDeploymentSpecification(new ModuleStructureSpec());
        JBossDeploymentStructureParser11.parseModuleStructureSpec(result.getDeploymentUnit(), reader, result.getRootDeploymentSpecification(), result.getModuleLoader());
    }

    private static void parseSubDeployment(XMLStreamReader reader, ParseResult result) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        if (result.getSubDeploymentSpecifications().containsKey(name)) {
            throw new XMLStreamException("Sub deployment " + name + " is listed twice in jboss-structure.xml");
        }
        ModuleStructureSpec moduleSpecification = new ModuleStructureSpec();
        result.getSubDeploymentSpecifications().put(name, moduleSpecification);
        JBossDeploymentStructureParser11.parseModuleStructureSpec(result.getDeploymentUnit(), reader, moduleSpecification, result.getModuleLoader());
    }

    private static void parseModule(XMLStreamReader reader, ParseResult result) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        if (!name.startsWith("deployment.")) {
            throw new XMLStreamException("Additional module name " + name + " is not valid. Names must start with 'deployment.'");
        }
        ModuleStructureSpec moduleSpecification = new ModuleStructureSpec();
        moduleSpecification.setModuleIdentifier(ModuleIdentifier.create((String)name, slot));
        result.getAdditionalModules().add(moduleSpecification);
        JBossDeploymentStructureParser11.parseModuleStructureSpec(result.getDeploymentUnit(), reader, moduleSpecification, result.getModuleLoader());
    }

    private static void parseModuleStructureSpec(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec moduleSpec, ModuleLoader moduleLoader) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EXPORTS: {
                            JBossDeploymentStructureParser11.parseFilterList(reader, moduleSpec.getExportFilters());
                            continue block13;
                        }
                        case DEPENDENCIES: {
                            JBossDeploymentStructureParser11.parseDependencies(reader, moduleSpec, moduleLoader);
                            continue block13;
                        }
                        case RESOURCES: {
                            JBossDeploymentStructureParser11.parseResources(deploymentUnit, reader, moduleSpec);
                            continue block13;
                        }
                        case TRANSFORMERS: {
                            JBossDeploymentStructureParser11.parseTransformers(reader, moduleSpec);
                            continue block13;
                        }
                        case EXCLUSIONS: {
                            JBossDeploymentStructureParser11.parseExclusions(reader, moduleSpec);
                            continue block13;
                        }
                        case LOCAL_LAST: {
                            JBossDeploymentStructureParser11.parseLocalLast(reader, moduleSpec);
                            continue block13;
                        }
                        case MODULE_ALIAS: {
                            JBossDeploymentStructureParser11.parseModuleAlias(reader, moduleSpec);
                            continue block13;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseModuleAlias(XMLStreamReader reader, ModuleStructureSpec moduleSpec) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    moduleSpec.addAlias(ModuleIdentifier.create(name, slot));
                    return;
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseDependencies(XMLStreamReader reader, ModuleStructureSpec specBuilder, ModuleLoader moduleLoader) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            JBossDeploymentStructureParser11.parseModuleDependency(reader, specBuilder, moduleLoader);
                            continue block8;
                        }
                        case SYSTEM: {
                            JBossDeploymentStructureParser11.parseSystemDependency(reader, specBuilder);
                            continue block8;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseSystemDependency(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        boolean export = false;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block11;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        Set<Object> paths = Collections.emptySet();
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder((boolean)export);
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (export) {
                        exportBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        exportBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    PathFilter exportFilter = exportBuilder.create();
                    specBuilder.addSystemDependency(DependencySpec.createSystemDependencySpec((PathFilter)PathFilters.getDefaultImportFilter(), (PathFilter)exportFilter, paths));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATHS: {
                            paths = JBossDeploymentStructureParser11.parseSet(reader);
                            break block3;
                        }
                        case EXPORTS: {
                            JBossDeploymentStructureParser11.parseFilterList(reader, exportBuilder);
                            break block3;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
    }

    private static void parseSet(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        builder.addFilter(PathFilters.in(JBossDeploymentStructureParser11.parseSet(reader)), include);
    }

    private static Set<String> parseSet(XMLStreamReader reader) throws XMLStreamException {
        HashSet<String> set = new HashSet<String>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return set;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATH: {
                            JBossDeploymentStructureParser11.parsePathName(reader, set);
                        }
                    }
                }
            }
        }
        return set;
    }

    private static void parseFilterList(XMLStreamReader reader, MultiplePathFilterBuilder builder) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            JBossDeploymentStructureParser11.parsePath(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE: {
                            JBossDeploymentStructureParser11.parsePath(reader, false, builder);
                            continue block10;
                        }
                        case INCLUDE_SET: {
                            JBossDeploymentStructureParser11.parseSet(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE_SET: {
                            JBossDeploymentStructureParser11.parseSet(reader, false, builder);
                            continue block10;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parsePath(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        boolean literal;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                builder.addFilter(PathFilters.isChildOf((String)path), include);
            } else {
                builder.addFilter(PathFilters.is((String)path), include);
            }
        } else {
            builder.addFilter(PathFilters.match((String)path), include);
        }
        JBossDeploymentStructureParser11.parseNoContent(reader);
    }

    private static void parseModuleDependency(XMLStreamReader reader, ModuleStructureSpec specBuilder, ModuleLoader moduleLoader) throws XMLStreamException {
        String name = null;
        String slot = null;
        boolean export = false;
        boolean optional = false;
        boolean annotations = false;
        Disposition services = Disposition.NONE;
        Disposition metaInf = Disposition.NONE;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block21: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block21;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block21;
                }
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block21;
                }
                case SERVICES: {
                    services = Disposition.of(reader.getAttributeValue(i));
                    continue block21;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block21;
                }
                case ANNOTATIONS: {
                    annotations = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block21;
                }
                case META_INF: {
                    metaInf = Disposition.of(reader.getAttributeValue(i));
                    continue block21;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        ModuleIdentifier identifier = ModuleIdentifier.create(name, slot);
        ModuleDependency dependency = new ModuleDependency(moduleLoader, identifier, optional, export, services == Disposition.IMPORT, true);
        if (annotations) {
            specBuilder.addAnnotationModule(identifier);
        }
        switch (metaInf) {
            case EXPORT: {
                dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
                dependency.addExportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
                break;
            }
            case IMPORT: {
                dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
            }
        }
        specBuilder.addModuleDependency(dependency);
        block22: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (services == Disposition.EXPORT) {
                        dependency.addExportFilter(PathFilters.getMetaInfServicesFilter(), true);
                    }
                    if (export) {
                        dependency.addExportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        dependency.addExportFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    if (dependency.getImportFilters().isEmpty()) {
                        dependency.addImportFilter(services == Disposition.NONE ? PathFilters.getDefaultImportFilter() : PathFilters.getDefaultImportFilterWithServices(), true);
                    } else {
                        if (services != Disposition.NONE) {
                            dependency.addImportFilter(PathFilters.getMetaInfServicesFilter(), true);
                        }
                        dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        dependency.addImportFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    specBuilder.addModuleDependency(dependency);
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case EXPORTS: {
                            JBossDeploymentStructureParser11.parseFilterList(reader, dependency.getExportFilters());
                            continue block22;
                        }
                        case IMPORTS: {
                            JBossDeploymentStructureParser11.parseFilterList(reader, dependency.getImportFilters());
                            continue block22;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
    }

    private static void parseResources(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case RESOURCE_ROOT: {
                            JBossDeploymentStructureParser11.parseResourceRoot(deploymentUnit, reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseResourceRoot(DeploymentUnit deploymentUnit, XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        String name = null;
        String path = null;
        boolean usePhysicalCodeSource = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block14;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block14;
                }
                case USE_PHYSICAL_CODE_SOURCE: {
                    usePhysicalCodeSource = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block14;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        if (name == null) {
            name = path;
        }
        ArrayList<FilterSpecification> resourceFilters = new ArrayList<FilterSpecification>();
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                        VirtualFile deploymentRootFile = deploymentRoot.getRoot();
                        VirtualFile child = deploymentRootFile.getChild(path);
                        Closeable closable = child.isFile() ? VFS.mountZip((VirtualFile)child, (VirtualFile)child, (TempFileProvider)TempFileProviderService.provider()) : null;
                        MountHandle mountHandle = new MountHandle(closable);
                        ResourceRoot resourceRoot = new ResourceRoot(name, child, mountHandle);
                        for (FilterSpecification filter : resourceFilters) {
                            resourceRoot.getExportFilters().add(filter);
                        }
                        resourceRoot.setUsePhysicalCodeSource(usePhysicalCodeSource);
                        specBuilder.addResourceRoot(resourceRoot);
                    }
                    catch (IOException e) {
                        throw new XMLStreamException(e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (!encountered.add(element)) {
                        throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                    }
                    switch (element) {
                        case FILTER: {
                            JBossDeploymentStructureParser11.parseFilterList(reader, resourceFilters);
                            continue block15;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
    }

    private static void parseFilterList(XMLStreamReader reader, List<FilterSpecification> filters) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            JBossDeploymentStructureParser11.parsePath(reader, true, filters);
                            continue block10;
                        }
                        case EXCLUDE: {
                            JBossDeploymentStructureParser11.parsePath(reader, false, filters);
                            continue block10;
                        }
                        case INCLUDE_SET: {
                            JBossDeploymentStructureParser11.parseSet(reader, true, filters);
                            continue block10;
                        }
                        case EXCLUDE_SET: {
                            JBossDeploymentStructureParser11.parseSet(reader, false, filters);
                            continue block10;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parsePath(XMLStreamReader reader, boolean include, List<FilterSpecification> filters) throws XMLStreamException {
        boolean literal;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                filters.add(new FilterSpecification(PathFilters.isChildOf((String)path), include));
            } else {
                filters.add(new FilterSpecification(PathFilters.is((String)path), include));
            }
        } else {
            filters.add(new FilterSpecification(PathFilters.match((String)path), include));
        }
        JBossDeploymentStructureParser11.parseNoContent(reader);
    }

    private static void parseSet(XMLStreamReader reader, boolean include, List<FilterSpecification> filters) throws XMLStreamException {
        HashSet<String> set = new HashSet<String>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    filters.add(new FilterSpecification(PathFilters.in(set), include));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATH: {
                            JBossDeploymentStructureParser11.parsePathName(reader, set);
                        }
                    }
                }
            }
        }
    }

    private static void parsePathName(XMLStreamReader reader, Set<String> set) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        set.add(name);
        JBossDeploymentStructureParser11.parseNoContent(reader);
    }

    private static void parseTransformers(XMLStreamReader reader, ModuleStructureSpec moduleSpec) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case TRANSFORMER: {
                            JBossDeploymentStructureParser11.parseTransformer(reader, moduleSpec.getClassFileTransformers());
                            continue block7;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseTransformer(XMLStreamReader reader, List<String> transformerClassNames) throws XMLStreamException {
        String className = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLASS: {
                    className = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        transformerClassNames.add(className);
        JBossDeploymentStructureParser11.parseNoContent(reader);
    }

    private static void parseLocalLast(XMLStreamReader reader, ModuleStructureSpec moduleSpec) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    String value = reader.getAttributeValue(i);
                    moduleSpec.setLocalLast(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        JBossDeploymentStructureParser11.parseNoContent(reader);
    }

    private static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseEndDocument(XMLStreamReader reader) throws XMLStreamException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block5;
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
                case 5: 
                case 6: {
                    continue block5;
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
    }

    private static void parseExclusions(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            JBossDeploymentStructureParser11.parseModuleExclusion(reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
            throw JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
        throw JBossDeploymentStructureParser11.endOfDocument(reader.getLocation());
    }

    private static void parseModuleExclusion(XMLStreamReader reader, ModuleStructureSpec specBuilder) throws XMLStreamException {
        String name = null;
        String slot = "main";
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block7;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw JBossDeploymentStructureParser11.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw JBossDeploymentStructureParser11.missingAttributes(reader.getLocation(), required);
        }
        specBuilder.getExclusions().add(ModuleIdentifier.create(name, (String)slot));
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            JBossDeploymentStructureParser11.unexpectedContent(reader);
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document", location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    static enum Disposition {
        NONE("none"),
        IMPORT("import"),
        EXPORT("export");

        private static final Map<String, Disposition> values;
        private final String value;

        private Disposition(String value) {
            this.value = value;
        }

        static Disposition of(String value) {
            Disposition disposition = values.get(value);
            return disposition == null ? NONE : disposition;
        }

        static {
            HashMap<String, Disposition> map = new HashMap<String, Disposition>();
            for (Disposition d : Disposition.values()) {
                map.put(d.value, d);
            }
            values = map;
        }
    }

    static enum Attribute {
        NAME,
        SLOT,
        EXPORT,
        SERVICES,
        PATH,
        OPTIONAL,
        CLASS,
        VALUE,
        USE_PHYSICAL_CODE_SOURCE,
        ANNOTATIONS,
        META_INF,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("slot"), SLOT);
            attributesMap.put(new QName("export"), EXPORT);
            attributesMap.put(new QName("services"), SERVICES);
            attributesMap.put(new QName("path"), PATH);
            attributesMap.put(new QName("optional"), OPTIONAL);
            attributesMap.put(new QName("class"), CLASS);
            attributesMap.put(new QName("value"), VALUE);
            attributesMap.put(new QName("use-physical-code-source"), USE_PHYSICAL_CODE_SOURCE);
            attributesMap.put(new QName("annotations"), ANNOTATIONS);
            attributesMap.put(new QName("meta-inf"), META_INF);
            attributes = attributesMap;
        }
    }

    static enum Element {
        JBOSS_DEPLOYMENT_STRUCTURE,
        EAR_SUBDEPLOYMENTS_ISOLATED,
        DEPLOYMENT,
        SUB_DEPLOYMENT,
        MODULE,
        DEPENDENCIES,
        EXPORTS,
        IMPORTS,
        INCLUDE,
        INCLUDE_SET,
        EXCLUDE,
        EXCLUDE_SET,
        RESOURCES,
        RESOURCE_ROOT,
        PATH,
        FILTER,
        TRANSFORMERS,
        TRANSFORMER,
        EXCLUSIONS,
        LOCAL_LAST,
        SYSTEM,
        PATHS,
        MODULE_ALIAS,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "jboss-deployment-structure"), JBOSS_DEPLOYMENT_STRUCTURE);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "ear-subdeployments-isolated"), EAR_SUBDEPLOYMENTS_ISOLATED);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "deployment"), DEPLOYMENT);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "sub-deployment"), SUB_DEPLOYMENT);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "module"), MODULE);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "dependencies"), DEPENDENCIES);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "resources"), RESOURCES);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "resource-root"), RESOURCE_ROOT);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "path"), PATH);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "exports"), EXPORTS);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "imports"), IMPORTS);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "include"), INCLUDE);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "exclude"), EXCLUDE);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "exclusions"), EXCLUSIONS);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "include-set"), INCLUDE_SET);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "exclude-set"), EXCLUDE_SET);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "filter"), FILTER);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "transformers"), TRANSFORMERS);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "transformer"), TRANSFORMER);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "local-last"), LOCAL_LAST);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "module-alias"), MODULE_ALIAS);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "system"), SYSTEM);
            elementsMap.put(new QName(JBossDeploymentStructureParser11.NAMESPACE_1_1, "paths"), PATHS);
            elements = elementsMap;
        }
    }
}

