/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ConnectionFactoryTypeValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    public static ConnectionFactoryTypeValidator INSTANCE = new ConnectionFactoryTypeValidator();
    private static final List<ModelNode> ALLOWED_VALUES = new ArrayList<ModelNode>();

    public ConnectionFactoryTypeValidator() {
        super(ModelType.STRING, true);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION && !ALLOWED_VALUES.contains(value)) {
            throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.invalidParameterValue(value.asString(), parameterName, ALLOWED_VALUES)));
        }
    }

    public List<ModelNode> getAllowedValues() {
        return ALLOWED_VALUES;
    }

    static {
        ALLOWED_VALUES.add(new ModelNode().set("GENERIC"));
        ALLOWED_VALUES.add(new ModelNode().set("QUEUE"));
        ALLOWED_VALUES.add(new ModelNode().set("TOPIC"));
        ALLOWED_VALUES.add(new ModelNode().set("XA_GENERIC"));
        ALLOWED_VALUES.add(new ModelNode().set("XA_QUEUE"));
        ALLOWED_VALUES.add(new ModelNode().set("XA_TOPIC"));
    }
}

