/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.resource;

import java.util.Locale;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DefaultResourceAddDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SocketBindingGroupIncludeAddHandler;
import org.jboss.as.controller.operations.common.SocketBindingGroupIncludeRemoveHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.resource.SocketBindingGroupIncludesAttribute;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SocketBindingGroupResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setValidator(new StringLengthValidator(1)).build();
    public static final SimpleAttributeDefinition DEFAULT_INTERFACE = new SimpleAttributeDefinitionBuilder("default-interface", ModelType.STRING, false).setAllowExpression(true).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES).build();
    public static final SimpleAttributeDefinition PORT_OFFSET = new SimpleAttributeDefinitionBuilder("port-offset", ModelType.INT, true).setAllowExpression(true).setValidator(new IntRangeValidator(0, 65535, true, true)).setDefaultValue(new ModelNode().set(0)).setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES).build();
    public static final ListAttributeDefinition INCLUDES = SocketBindingGroupIncludesAttribute.INSTANCE;
    private final boolean forDomainModel;

    public SocketBindingGroupResourceDefinition(OperationStepHandler addHandler, OperationStepHandler removeHandler, boolean forDomainModel) {
        super(PathElement.pathElement("socket-binding-group"), CommonDescriptions.getResourceDescriptionResolver("socket-binding-group"), addHandler, removeHandler, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES);
        this.forDomainModel = forDomainModel;
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute(NAME, null);
        resourceRegistration.registerReadWriteAttribute(DEFAULT_INTERFACE, null, new ReloadRequiredWriteAttributeHandler(DEFAULT_INTERFACE));
        if (this.forDomainModel) {
            resourceRegistration.registerReadWriteAttribute(INCLUDES, null, new WriteAttributeHandlers.AttributeDefinitionValidatingHandler(INCLUDES));
        } else {
            resourceRegistration.registerReadWriteAttribute(PORT_OFFSET, null, new ReloadRequiredWriteAttributeHandler(PORT_OFFSET));
        }
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.forDomainModel) {
            resourceRegistration.registerOperationHandler("add-include", SocketBindingGroupIncludeAddHandler.INSTANCE, SocketBindingGroupIncludeAddHandler.INSTANCE);
            resourceRegistration.registerOperationHandler("remove-included-group", SocketBindingGroupIncludeRemoveHandler.INSTANCE, SocketBindingGroupIncludeRemoveHandler.INSTANCE);
        }
    }

    @Override
    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        DefaultResourceAddDescriptionProvider provider = new DefaultResourceAddDescriptionProvider(registration, this.getResourceDescriptionResolver()){

            @Override
            public ModelNode getModelDescription(Locale locale) {
                ModelNode result = super.getModelDescription(locale);
                if (result.get("request-properties").hasDefined(NAME.getName())) {
                    result.get("request-properties").remove(NAME.getName());
                }
                return result;
            }
        };
        registration.registerOperationHandler("add", handler, (DescriptionProvider)provider, SocketBindingGroupResourceDefinition.getFlagsSet(flags));
    }
}

